/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.ui.kitchendisplay.KitchenTicketListPanel;
import com.floreantpos.ui.views.order.ViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.border.EmptyBorder;

public class KitchenDisplayView
extends ViewPanel {
    public static final String VIEW_NAME = "KD";
    private KeyboardDispatcher a;
    private KitchenTicketListPanel b;
    private static KitchenDisplayView c;

    private KitchenDisplayView() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new KitchenTicketListPanel();
        this.b.setOpaque(false);
        this.b.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.add(this.b);
        this.a = new KeyboardDispatcher();
    }

    @Override
    public Color getBackground() {
        return TerminalConfig.getColor("kds.background", Color.black);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            String string = TerminalConfig.getDefaultView();
            this.b.setBackButtonVisible(string != null && !string.equals(VIEW_NAME));
            this.b.updateKDSView();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(this.a);
        } else {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removeKeyEventDispatcher(this.a);
            this.cleanup();
        }
    }

    public synchronized void cleanup() {
        this.b.reset();
    }

    public void updateView() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static synchronized KitchenDisplayView getInstance() {
        if (c == null) {
            c = new KitchenDisplayView();
        }
        return c;
    }

    private class KeyboardDispatcher
    implements KeyEventDispatcher {
        private KeyboardDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 402) {
                KitchenDisplayView.this.b.setSelectedKey(keyEvent.getKeyCode());
            }
            return false;
        }
    }
}

