/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.CourseOrganizeTableModel;
import com.floreantpos.ui.order.TableDataTransferHandler;
import com.floreantpos.ui.ticket.TicketViewerTableCellRenderer;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class CourseOrganizeTableView
extends TransparentPanel {
    private JTable a;
    private CourseOrganizeTableModel b;
    private Course c;
    protected boolean pressed;
    private Ticket d;

    public CourseOrganizeTableView(Course course, List<ITicketItem> list) {
        this.c = course;
        this.a();
        ArrayList<ITicketItem> arrayList = new ArrayList<ITicketItem>();
        for (ITicketItem iTicketItem : list) {
            if (iTicketItem instanceof TicketItem && ((TicketItem)iTicketItem).isTreatAsSeat().booleanValue()) continue;
            arrayList.add(iTicketItem);
        }
        this.b.setItems(arrayList);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.a = new JTable();
        this.b = new CourseOrganizeTableModel();
        this.a.setModel(this.b);
        this.a.getSelectionModel().setSelectionMode(2);
        this.a.setDropMode(DropMode.INSERT_ROWS);
        this.a.setDragEnabled(true);
        this.a.setRowSelectionAllowed(true);
        this.a.setFillsViewportHeight(true);
        this.a.setFocusable(false);
        this.a.setAutoResizeMode(4);
        this.a.setAutoCreateRowSorter(false);
        this.a.setRowHeight(40);
        this.a.getTableHeader().setPreferredSize(new Dimension(0, 35));
        this.a.setAutoscrolls(true);
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CourseOrganizeTableView.this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CourseOrganizeTableView.this.pressed = false;
                CourseOrganizeTableView.this.a.setCursor(Cursor.getPredefinedCursor(0));
                super.mouseReleased(mouseEvent);
            }
        });
        PosScrollPane posScrollPane = new PosScrollPane(this.a);
        this.add(posScrollPane);
        PosButton posButton = new PosButton("Fire");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CourseOrganizeTableView.this.b();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center"));
        jPanel.add(posButton);
        this.add((Component)jPanel, "South");
    }

    private void b() {
        if (this.b.getRows() == null || this.b.getRowCount() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketDialog.10"));
            return;
        }
        SendToKitchenAction sendToKitchenAction = new SendToKitchenAction();
        if (!sendToKitchenAction.isPrintableToKitchen(this.d)) {
            return;
        }
        this.updateModel();
        boolean bl = false;
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : this.b.getRows()) {
            if (!bl && ticketItem.isShouldPrintToKitchen().booleanValue() && !ticketItem.isPrintedToKitchen().booleanValue()) {
                bl = true;
            }
            arrayList.add(ticketItem);
        }
        OrderController.saveOrder(this.d);
        ReceiptPrintService.printCourseItemsToKitchen(this.d, arrayList, bl);
        this.b.fireTableDataChanged();
    }

    public void setDataTransferHandler(TableDataTransferHandler tableDataTransferHandler) {
        this.a.setTransferHandler(tableDataTransferHandler);
        this.a.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = null;
                ListTableModel listTableModel = (ListTableModel)jTable.getModel();
                Object e = listTableModel.getRowData(n);
                component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (bl) {
                    return component;
                }
                component.setBackground(jTable.getBackground());
                if (e instanceof ITicketItem) {
                    ITicketItem iTicketItem = (ITicketItem)e;
                    if (iTicketItem.isPrintedToKitchen().booleanValue()) {
                        component.setBackground(Color.YELLOW);
                    } else if (iTicketItem.isSaved()) {
                        component.setBackground(TicketViewerTableCellRenderer.SAVED_ITEM_COLOR);
                    }
                }
                return component;
            }
        });
        ActionMap actionMap = this.a.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), abstractAction);
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), abstractAction);
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), abstractAction);
        TableColumn tableColumn = this.a.getColumnModel().getColumn(0);
        tableColumn.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = new JLabel(CourseOrganizeTableView.this.c.getShortName() + " - " + CourseOrganizeTableView.this.c.getName(), 0);
                jLabel.setBorder(jTable.getBorder());
                return jLabel;
            }
        });
    }

    public void updateView() {
        this.b.fireTableDataChanged();
    }

    public void updateModel() {
        for (ITicketItem iTicketItem : this.b.getRows()) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            ticketItem.setCourseId(this.c == null ? null : this.c.getId());
            ticketItem.setCourseName(this.c == null ? null : this.c.getShortName());
            ticketItem.setSortOrder(this.c == null ? null : this.c.getSortOrder());
        }
    }

    public void setTicket(Ticket ticket) {
        this.d = ticket;
    }
}

