/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.print.JasperPrintService;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;

public class TicketDetailView
extends JPanel {
    public static final String VIEW_NAME = "TICKET_DETAIL";
    private JPanel a;
    private List<Ticket> b;

    public TicketDetailView() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.a = new JPanel(new GridLayout());
        this.add((Component)this.a, "Center");
        this.setOpaque(false);
    }

    public void clearView() {
        this.a.removeAll();
    }

    public void updateView() {
        try {
            this.clearView();
            List<Ticket> list = this.getTickets();
            int n = list.size();
            if (n <= 0) {
                return;
            }
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            PosScrollPane posScrollPane = new PosScrollPane(jPanel);
            posScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            for (Ticket ticket : list) {
                TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** ORDER " + ticket.getId() + " ***", false, true, true);
                HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
                hashMap.put("IS_IGNORE_PAGINATION", true);
                JasperPrint jasperPrint = new JasperPrintService().createPrint(ticket, hashMap, null, false);
                TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
                jPanel.add(ticketReceiptView.getReportPanel());
            }
            this.a.add((Component)posScrollPane, "Center");
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public List<Ticket> getTickets() {
        return this.b;
    }

    public void setTickets(List<Ticket> list) {
        this.b = list;
        this.updateView();
    }

    public void setTicket(Ticket ticket) {
        this.b = new ArrayList<Ticket>(1);
        this.b.add(ticket);
        this.updateView();
    }

    public void cleanup() {
        this.b = null;
    }
}

