/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudConfigurationDialog;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class CloudSyncDialog
extends POSDialog
implements ProgressObserver,
ActionListener {
    private static final Color a = new Color(126, 180, 69);
    private static final String b = "UND";
    private static final String c = "SAVE";
    private static final String d = "cancel";
    private static final String e = "test";
    private PosButton f;
    private JButton g;
    private JLabel h;
    private boolean i;
    private JLabel j;
    private JProgressBar k;
    private JLabel l;
    private JTabbedPane m;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getBackOfficeWindow());
        this.a();
    }

    @Override
    public void setVisible(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudSyncDialog.this.b();
            }
        });
        super.setVisible(bl);
    }

    @Override
    protected void initUI() {
        this.m = new JTabbedPane();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 5 20 20 20,fill,hidemode 3"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("fill"));
        jPanel.add((Component)jPanel2, "growx,span");
        this.m.addTab(Messages.getString("CloudSyncDialog.3"), jPanel);
        this.j = new JLabel();
        this.j.setFont(new Font("Arial", 1, 20));
        this.k = new JProgressBar();
        this.k.setValue(0);
        this.k.setMaximum(100);
        this.k.setStringPainted(true);
        this.k.setPreferredSize(new Dimension(0, 30));
        this.l = new JLabel(Messages.getString("CloudSyncDialog.5"));
        this.k.setVisible(false);
        this.g = new JButton(Messages.getString("Cancel"));
        this.g.setActionCommand(d);
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.l, "right,newline,split 2");
        jPanel.add((Component)this.k, "grow");
        jPanel.add((Component)new JLabel(Messages.getString("CloudSyncDialog.9")), "newline,split 3");
        jPanel.add(this.j);
        this.h = new JLabel(Messages.getString("StoreId"));
        this.h.setFont(new Font("Arial", 1, 16));
        this.h.setForeground(Color.GRAY);
        jPanel.add((Component)this.j, "grow");
        jPanel.add((Component)this.h, "right,grow");
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.g, "newline,center,span");
        this.updateTitle();
        this.f = new PosButton("SYNC");
        this.f.setActionCommand(b);
        this.f.setIcon(IconFactory.getIcon("/ui_icons/", "upload_download.png"));
        JButton jButton = new JButton(IconFactory.getIcon("/ui_icons/", "backoffice.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudConfigurationDialog cloudConfigurationDialog = new CloudConfigurationDialog();
                cloudConfigurationDialog.setSize(PosUIManager.getSize(650, 500));
                cloudConfigurationDialog.open();
                boolean bl = CloudSyncDialog.this.b();
                if (bl && !cloudConfigurationDialog.isCanceled()) {
                    CloudSyncDialog.this.c();
                }
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CloudSyncDialog.this.b();
                if (!bl) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                    return;
                }
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.b);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                            CloudSyncDialog.this.k.setValue((Integer)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        jPanel2.add((Component)jButton, "right,wrap");
        jPanel2.add((Component)this.f, "split 2,gaptop 20,center");
        this.add(this.m);
    }

    private void a() {
        this.f.addActionListener(this);
        this.g.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (d.equalsIgnoreCase(string)) {
                this.dispose();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (e.equalsIgnoreCase(string)) {
                this.i = this.b();
                if (!this.i) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                } else {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                }
            } else if (c.equalsIgnoreCase(string)) {
                this.b();
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudSyncDialog.22"));
                this.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showMessage(this, exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void updateTitle() {
        super.setTitle("Sync with cloud");
    }

    private boolean b() {
        PosResponse posResponse = null;
        try {
            posResponse = PosWebService.get().checkConnection();
        }
        catch (Exception exception) {
            this.j.setText(Messages.getString("CloudSyncDialog.23"));
            this.j.setForeground(Color.RED);
        }
        if (posResponse != null) {
            if (posResponse.getResponseCode() == 200) {
                System.out.println("Connected");
                this.j.setText(Messages.getString("CloudSyncDialog.25"));
                this.j.setForeground(a);
                this.h.setText(Messages.getString("StoreId") + posResponse.getStoreId());
                String string = AppConfig.getString("store_uuid");
                if (string != null && !posResponse.getStoreId().equals(string)) {
                    try {
                        AppConfig.put("store_uuid", posResponse.getStoreId());
                        OroMqttClient.getInstance().subscribe();
                    }
                    catch (Exception exception) {
                        PosLog.error(this.getClass(), exception.getMessage());
                    }
                }
                Application.getInstance().setCloudConnected(true);
                return true;
            }
            this.j.setText(posResponse.getMsg());
            this.j.setForeground(Color.RED);
        }
        return false;
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setSize(PosUIManager.getSize(500, 350));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    private void c() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.k.setMaximum(105);
                this.k.setVisible(true);
                this.k.setValue(0);
                this.l.setForeground(Color.BLUE);
                SyncService.sync(this);
                this.k.setValue(100);
                this.l.setText(Messages.getString("CloudSyncDialog.29"));
                this.l.setForeground(a);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.l.setText(Messages.getString("CloudSyncDialog.30"));
                this.l.setForeground(Color.RED);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void progress(int n) {
        this.k.setValue(n);
    }

    @Override
    public void progress(String string) {
        this.l.setText(string);
    }

    @Override
    public void progress(int n, String string) {
        this.k.setValue(n);
        this.l.setText(string);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            CloudSyncDialog.this.f.setEnabled(false);
            CloudSyncDialog.this.g.setEnabled(false);
            if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.c();
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            CloudSyncDialog.this.k.setVisible(false);
            CloudSyncDialog.this.f.setEnabled(true);
            CloudSyncDialog.this.g.setEnabled(true);
        }
    }
}

