/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TicketReorderAction
extends PosAction {
    private Ticket a;
    private boolean b;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission userPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, userPermission);
        this.a = ticket;
    }

    public TicketReorderAction(DataChangeListener dataChangeListener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketReorderAction.0"), Messages.getString("TicketReorderAction.1"));
            if (n != 0) {
                return;
            }
            Ticket ticket = DataProvider.get().getTicketToBeCreated();
            if (ticket != null) {
                ticket.setCustomer(this.a.getCustomer());
                this.a(this.a, ticket.getOrderType(), ticket);
            } else {
                OrderTypeSelectionDialog orderTypeSelectionDialog = new OrderTypeSelectionDialog();
                orderTypeSelectionDialog.open();
                if (orderTypeSelectionDialog.isCanceled()) {
                    return;
                }
                OrderType orderType = orderTypeSelectionDialog.getSelectedOrderType();
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
                this.a(this.a, orderType, null);
            }
            this.b = true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, OrderType orderType, Ticket ticket2) {
        Serializable serializable;
        if (ticket == null) {
            throw new PosException(Messages.getString("TicketReorderAction.2"));
        }
        Ticket ticket3 = ticket2;
        if (ticket2 == null) {
            ticket3 = new Ticket(true);
            ticket3.setOrderType(orderType);
        }
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (TicketItem object : ticket.getTicketItems()) {
            if (object.isVoided().booleanValue()) continue;
            serializable = object.cloneAsNew();
            ((BaseTicketItem)serializable).setTicket(ticket3);
            arrayList.add((TicketItem)serializable);
        }
        ticket3.getTicketItems().addAll(arrayList);
        if (ticket2 == null && orderType.isShowTableSelection().booleanValue()) {
            TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(orderType);
            tableSelectorDialog.setCreateNewTicket(false);
            tableSelectorDialog.updateView(true);
            tableSelectorDialog.openUndecoratedFullScreen();
            if (tableSelectorDialog.isCanceled()) {
                return;
            }
            List<ShopTable> list = tableSelectorDialog.getSelectedTables();
            serializable = new ArrayList();
            for (ShopTable shopTable : list) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    ticket3.setSalesArea(salesArea);
                    ticket3.setSalesAreaId(salesArea.getId());
                }
                serializable.add(shopTable.getId());
            }
            ticket3.setTableNumbers((List<Integer>)((Object)serializable));
        }
        OrderView.getInstance().setCurrentTicket(ticket3);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    public boolean isReorder() {
        return this.b;
    }
}

