/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.MenuExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ItemExplorerAction
extends AbstractAction {
    public ItemExplorerAction() {
        super(POSConstants.MENU_ITEMS);
    }

    public ItemExplorerAction(String string) {
        super(string);
    }

    public ItemExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            MenuExplorer menuExplorer;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.ITEM_EXPLORER);
            if (n == -1) {
                menuExplorer = new MenuExplorer();
                jTabbedPane.addTab(POSConstants.ITEM_EXPLORER, menuExplorer);
            } else {
                menuExplorer = (MenuExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(menuExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

