/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.SalesBalanceReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class SalesBalanceReportAction
extends AbstractAction {
    public SalesBalanceReportAction() {
        super(POSConstants.SALES_BALANCE_REPORT);
    }

    public SalesBalanceReportAction(String string) {
        super(string);
    }

    public SalesBalanceReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            SalesBalanceReportView salesBalanceReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.SALES_BALANCE_REPORT);
            if (n == -1) {
                salesBalanceReportView = new SalesBalanceReportView();
                jTabbedPane.addTab(POSConstants.SALES_BALANCE_REPORT, salesBalanceReportView);
            } else {
                salesBalanceReportView = (SalesBalanceReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(salesBalanceReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

