/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.UserTypeExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class UserTypeExplorerAction
extends AbstractAction {
    public UserTypeExplorerAction() {
        super(POSConstants.USER_TYPES);
    }

    public UserTypeExplorerAction(String string) {
        super(string);
    }

    public UserTypeExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            UserTypeExplorer userTypeExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.USER_TYPE_EXPLORER);
            if (n == -1) {
                userTypeExplorer = new UserTypeExplorer();
                jTabbedPane.addTab(POSConstants.USER_TYPE_EXPLORER, userTypeExplorer);
            } else {
                userTypeExplorer = (UserTypeExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(userTypeExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

