/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ComboGroupTreeExplorer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private final ComboItemExplorerTableModel b;
    private MenuItem c;
    private ComboGroupTreeExplorer d;
    private JCheckBox e;

    public ComboItemExplorer() {
        this.a();
        this.b = new ComboItemExplorerTableModel();
        this.a.setModel(this.b);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable();
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(30);
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        this.e = new JCheckBox(Messages.getString("ComboItemExplorer.0"));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ComboItemExplorer.this.c.setModifiablePriceForComboItem(jCheckBox.isSelected());
            }
        });
        this.add((Component)this.e, "wrap");
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 150));
        this.add((Component)jScrollPane, "grow");
        this.add((Component)transparentPanel, "grow, newline");
        this.d = new ComboGroupTreeExplorer();
        this.add((Component)this.d, "grow, newline");
    }

    public void setMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.b();
    }

    private void b() {
        this.b.setItems(this.c.getComboItems());
        this.d.setMenuItem(this.c);
        this.e.setSelected(this.c.isModifiablePriceForComboItem());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(Messages.getString("ComboItemExplorer.8"));
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void c() {
        try {
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (ComboItem object2 : this.b.getItems()) {
                arrayList.add(object2.getMenuItem());
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem = (MenuItem)iterator.next();
                if (arrayList == null || arrayList.contains(menuItem)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setMenuItem(menuItem);
                comboItem.setQuantity(1.0);
                this.b.addComboItem(comboItem);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog(this.c);
            comboItemEntryDialog.setSelectedItem(comboItem.getMenuItem());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem = comboItemEntryDialog.getItem();
            comboItem.setMenuItem(menuItem);
            comboItem.setQuantity(comboItemEntryDialog.getQuantity());
            this.b.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        return this.b.getItems();
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.d.getGroups();
    }

    private class ComboItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("ComboItemExplorer.9"), Messages.getString("ComboItemExplorer.10"), Messages.getString("ComboItemExplorer.11") + " (" + CurrencyUtil.getCurrencySymbol() + ")"};
        List<ComboItem> b = new ArrayList<ComboItem>();

        public void setItems(List<ComboItem> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        public List<ComboItem> getItems() {
            return this.b;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            ComboItem comboItem = this.b.get(n);
            if (comboItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return comboItem.getName();
                }
                case 1: {
                    return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
                }
                case 2: {
                    return comboItem.getPrice() * comboItem.getQuantity();
                }
            }
            return null;
        }

        public void addComboItem(ComboItem comboItem) {
            int n = this.b.size();
            this.b.add(comboItem);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteItem(ComboItem comboItem, int n) {
            Iterator<ComboItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem2 = iterator.next();
                if (comboItem.getMenuItem() != comboItem2.getMenuItem()) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public ComboItem getComboItem(int n) {
            return this.b.get(n);
        }
    }
}

