/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidReasonDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public class VoidReasonExplorer
extends TransparentPanel
implements RefreshableView {
    private static final long a = 1L;
    private JXTable b;
    private BeanTableModel<VoidReason> c = new BeanTableModel(VoidReason.class);

    public VoidReasonExplorer() {
        this.c.addColumn(Messages.getString("VoidReasonExplorer.0"), "reasonText");
        this.c.addRows(VoidReasonDAO.getInstance().findAll());
        this.b = new JXTable(this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.getColumnModel().getColumn(0).setCellRenderer(new MultiLineTableCellRenderer());
        this.b.setAlignmentY(1.0f);
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    VoidReasonExplorer.this.b();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        this.add((Component)this.a(), "South");
    }

    private TransparentPanel a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton2.addActionListener(actionEvent -> this.c());
        jButton.addActionListener(actionEvent -> this.b());
        jButton3.addActionListener(actionEvent -> this.d());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        return transparentPanel;
    }

    private void b() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            VoidReason voidReason = this.c.getRow(n);
            VoidReasonDialog voidReasonDialog = new VoidReasonDialog();
            voidReasonDialog.setCaption(Messages.getString("VoidReasonExplorer.2"));
            voidReasonDialog.setPreferredSize(PosUIManager.getSize(500, 300));
            voidReasonDialog.setVoidReason(voidReason.getReasonText());
            voidReasonDialog.pack();
            voidReasonDialog.open();
            if (voidReasonDialog.isCanceled()) {
                return;
            }
            String string = voidReasonDialog.getVoidReason();
            voidReason.setReasonText(string.trim());
            VoidReasonDAO.getInstance().saveOrUpdate(voidReason);
            this.b.repaint();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void c() {
        try {
            VoidReasonDialog voidReasonDialog = new VoidReasonDialog();
            voidReasonDialog.setCaption(Messages.getString("VoidReasonExplorer.3"));
            voidReasonDialog.setPreferredSize(PosUIManager.getSize(500, 300));
            voidReasonDialog.pack();
            voidReasonDialog.open();
            if (voidReasonDialog.isCanceled()) {
                return;
            }
            String string = voidReasonDialog.getVoidReason();
            VoidReason voidReason = new VoidReason();
            voidReason.setReasonText(string.trim());
            VoidReasonDAO.getInstance().saveOrUpdate(voidReason);
            this.c.addRow(voidReason);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void d() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("VoidReasonExplorer.1"), POSConstants.CONFIRM) != 0) {
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            VoidReason voidReason = this.c.getRow(n);
            VoidReasonDAO.getInstance().delete(voidReason);
            this.c.removeRow(n);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    @Override
    public void refresh() {
        this.c.removeAll();
        this.c.addRows(VoidReasonDAO.getInstance().findAll());
        this.b.repaint();
    }
}

