/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.LargeComboBoxRenderer;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ChargeConfigurationView
extends ConfigurationView {
    private DoubleTextField a;
    private DoubleTextField b;
    private DoubleTextField c;
    private JCheckBox d;
    private JCheckBox e;
    private JComboBox f;
    private JComboBox g;
    private JCheckBox h;
    private Outlet i;
    private Store j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JLabel n;
    private IntegerTextField o;

    public ChargeConfigurationView(Store store) {
        this.j = store;
        this.a();
        this.c();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("RestaurantConfigurationView.42") + ":");
        jPanel.add((Component)jLabel, "alignx trailing");
        this.a = new DoubleTextField();
        jPanel.add((Component)this.a, "growx");
        JLabel jLabel2 = new JLabel("%");
        jPanel.add((Component)jLabel2, "wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        jPanel.add((Component)jLabel3, "flowy,alignx trailing");
        this.b = new DoubleTextField();
        jPanel.add((Component)this.b, "growx");
        JLabel jLabel4 = new JLabel("%");
        jPanel.add((Component)jLabel4, "wrap");
        JLabel jLabel5 = new JLabel(Messages.getString("ChargeConfigurationView.0"));
        jPanel.add((Component)jLabel5, "flowy,alignx trailing");
        this.c = new DoubleTextField();
        jPanel.add((Component)this.c, "growx");
        JLabel jLabel6 = new JLabel("%");
        jPanel.add((Component)jLabel6, "wrap");
        JLabel jLabel7 = new JLabel(Messages.getString("ChargeConfigurationView.1"));
        this.f = new JComboBox();
        this.f.setRenderer(new LargeComboBoxRenderer(PosUIManager.getSize(200)));
        Dimension dimension = PosUIManager.getSize(300, 30);
        this.f.setPreferredSize(dimension);
        this.f.setMinimumSize(dimension);
        jPanel.add((Component)jLabel7, "alignx trailing");
        jPanel.add((Component)this.f, "grow, wrap");
        JLabel jLabel8 = new JLabel(Messages.getString("ChargeConfigurationView.3"));
        this.g = new JComboBox();
        jPanel.add((Component)jLabel8, "alignx trailing");
        jPanel.add((Component)this.g, "grow, wrap");
        this.d = new JCheckBox(Messages.getString("ChargeConfigurationView.5"));
        jPanel.add((Component)this.d, "skip 1, wrap");
        this.e = new JCheckBox(Messages.getString("TaxConfigurationView.4"));
        jPanel.add((Component)this.e, "skip 1,wrap");
        this.h = new JCheckBox(Messages.getString("ChargeConfigurationView.6"));
        jPanel.add((Component)this.h, "skip 1,wrap");
        this.k = new JCheckBox(Messages.getString("ChargeConfigurationView.7"));
        jPanel.add((Component)this.k, "skip 1, wrap");
        this.l = new JCheckBox(Messages.getString("ChargeConfigurationView.21"));
        jPanel.add((Component)this.l, "skip 1, wrap");
        this.m = new JCheckBox(Messages.getString("ResetTokenNo"));
        this.m.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)this.m, "cell 1 10,growx");
        this.n = new JLabel(Messages.getString("NextTokenSequence"));
        jPanel.add((Component)this.n, "cell 0 11,alignx trailing");
        this.o = new IntegerTextField();
        jPanel.add((Component)this.o, "cell 1 11,growx");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void b() {
        if (this.m.isSelected()) {
            this.a(true);
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl) {
        this.n.setVisible(bl);
        this.o.setVisible(bl);
    }

    private void c() {
        ArrayList<TaxGroup> arrayList = new ArrayList<TaxGroup>();
        arrayList.add(null);
        arrayList.addAll(TaxGroupDAO.getInstance().findAll());
        this.f.setModel(new ComboBoxModel(arrayList));
        ArrayList<Currency> arrayList2 = new ArrayList<Currency>();
        arrayList2.add(null);
        arrayList2.addAll(CurrencyDAO.getInstance().findAll());
        this.g.setModel(new ComboBoxModel(arrayList2));
        this.l.setSelected(!this.j.isShowVoidedItemsOnTicket());
        boolean bl = this.j.getBooleanProperty("reset.token", true);
        this.m.setSelected(bl);
        String string = this.j.getProperty("token_no.start");
        String string2 = string == null ? String.valueOf(1) : string;
        this.o.setText(string2);
        this.a(bl);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        double d = 0.0;
        double d2 = 0.0;
        String string = null;
        String string2 = null;
        if (StringUtils.isEmpty(string)) {
            string = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = "$";
        }
        d = this.a.getDoubleOrZero();
        d2 = this.b.getDoubleOrZero();
        double d3 = this.c.getDoubleOrZero();
        if (d3 > 100.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ChargeConfigurationView.8"));
            return false;
        }
        this.j.setCurrencyName(string);
        this.j.setCurrencySymbol(string2);
        this.j.addProperty("overtime.markup", String.valueOf(d3));
        this.j.addProperty("store.peny.rounding", String.valueOf(this.h.isSelected()));
        this.j.addProperty("store.allow.multiple.discount", String.valueOf(this.k.isSelected()));
        this.j.setShowVoidedItemsOnTicket(!this.l.isSelected());
        this.j.setUseDetailedReconciliation(this.d.isSelected());
        this.j.setItemPriceIncludesTax(this.e.isSelected());
        if (this.m.isSelected()) {
            int n = this.o.getInteger();
            if (n < 1) {
                throw new PosException(Messages.getString("TokenNoGreaterOne"));
            }
            this.j.addProperty("token_no.start", String.valueOf(n));
        }
        this.j.addProperty("reset.token", String.valueOf(this.m.isSelected()));
        if (this.i != null) {
            this.i.setServiceChargePercentage(d);
            this.i.setDefaultGratuityPercentage(d2);
            TaxGroup taxGroup = (TaxGroup)this.f.getSelectedItem();
            this.i.setTaxGroup(taxGroup);
            Currency currency = (Currency)this.g.getSelectedItem();
            this.i.setCurrency(currency);
            OutletDAO.getInstance().saveOrUpdate(this.i);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.i = OutletDAO.getInstance().get(DataProvider.get().getStore().getDefaultOutletId());
        if (this.i != null) {
            this.a.setText(String.valueOf(this.i.getServiceChargePercentage()));
            this.b.setText(String.valueOf(this.i.getDefaultGratuityPercentage()));
            this.f.setSelectedItem(this.i.getTaxGroup());
            this.g.setSelectedItem(this.i.getCurrency());
        }
        this.c.setText(String.valueOf(this.j.getOvertimeMarkup()));
        this.d.setSelected(this.j.isUseDetailedReconciliation());
        this.e.setSelected(this.j.isItemPriceIncludesTax());
        this.h.setSelected(this.j.isAllowPenyRounding());
        this.k.setSelected(this.j.isAllowMulDiscount());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_CHARGE;
    }
}

