/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.AddPrinterDialog;
import com.floreantpos.config.ui.PrinterTypeSelectionDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXTable;

public class MultiPrinterPane
extends JPanel {
    private List<Printer> a = new ArrayList<Printer>();
    private DefaultListModel<Printer> b;
    private JXTable c;
    private BeanTableModel<Printer> d;
    private int e;
    private Terminal f;

    public MultiPrinterPane() {
    }

    public MultiPrinterPane(String string, List<Printer> list) {
        this(string, list, Application.getInstance().getTerminal());
    }

    public MultiPrinterPane(String string, List<Printer> list, Terminal terminal) {
        this.f = terminal;
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(Messages.getString("MultiPrinterPane.0"));
        jButton.addActionListener(actionEvent -> this.a());
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("EDIT"));
        jButton2.addActionListener(actionEvent -> this.doEditPrinter());
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(actionEvent -> this.doDeletePrinter());
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(Messages.getString("MultiPrinterPane.5"));
        jButton4.addActionListener(actionEvent -> this.c());
        jPanel.add(jButton4);
        this.b = new DefaultListModel();
        if (this.a != null) {
            for (Printer object : this.a) {
                this.b.addElement(object);
            }
        }
        this.d = new BeanTableModel(Printer.class);
        this.d.addColumn(Messages.getString("NAME"), "virtualPrinter");
        this.d.addColumn(Messages.getString("MultiPrinterPane.6"), "deviceName");
        this.d.addColumn(Messages.getString("Type"), "type");
        List<VirtualPrinter> list2 = VirtualPrinterDAO.getInstance().findAll();
        if (list2 != null && !list2.isEmpty()) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                VirtualPrinter virtualPrinter = (VirtualPrinter)iterator.next();
                Printer printer = new Printer();
                printer.setVirtualPrinter(virtualPrinter);
                printer.setDeviceName("");
                TerminalPrinters terminalPrinters = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), terminal);
                if (terminalPrinters != null && virtualPrinter.getName().equals(terminalPrinters.getVirtualPrinter().getName())) {
                    printer.setDeviceName(terminalPrinters.getPrinterName());
                }
                this.a.add(printer);
            }
        }
        this.d.addRows(this.a);
        this.c = new JXTable(this.d);
        this.add((Component)new JScrollPane((Component)this.c), "Center");
    }

    private void a() {
        try {
            PrinterTypeSelectionDialog printerTypeSelectionDialog = new PrinterTypeSelectionDialog();
            printerTypeSelectionDialog.open();
            if (printerTypeSelectionDialog.isCanceled()) {
                return;
            }
            this.e = printerTypeSelectionDialog.getSelectedPrinterType();
            this.doAddPrinter();
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    protected void doEditPrinter() {
        try {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.c.convertRowIndexToModel(n);
            Printer printer = this.d.getRow(n);
            TerminalPrinters terminalPrinters = null;
            if (printer.getVirtualPrinter() != null) {
                terminalPrinters = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), this.f);
            }
            AddPrinterDialog addPrinterDialog = new AddPrinterDialog();
            addPrinterDialog.setPrinter(printer, terminalPrinters);
            addPrinterDialog.open();
            if (addPrinterDialog.isCanceled()) {
                return;
            }
            Printer printer2 = addPrinterDialog.getPrinter();
            if (printer2.isDefaultPrinter()) {
                for (Printer printer3 : this.a) {
                    printer3.setDefaultPrinter(false);
                }
            }
            VirtualPrinter virtualPrinter = printer2.getVirtualPrinter();
            VirtualPrinterDAO.getInstance().saveOrUpdate(virtualPrinter);
            terminalPrinters = addPrinterDialog.getTerminalPrinter();
            terminalPrinters.setTerminal(this.f);
            terminalPrinters.setPrinterName(printer2.getDeviceName());
            terminalPrinters.setVirtualPrinter(printer2.getVirtualPrinter());
            TerminalPrintersDAO.getInstance().saveOrUpdate(terminalPrinters);
            this.b();
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    protected void doDeletePrinter() {
        try {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.c.convertRowIndexToModel(n);
            Printer printer = this.d.getRow(n);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findAll();
            for (TerminalPrinters terminalPrinters : list) {
                if (!terminalPrinters.getVirtualPrinter().equals(printer.getVirtualPrinter())) continue;
                TerminalPrintersDAO.getInstance().delete(terminalPrinters);
            }
            if (printer.getVirtualPrinter() != null) {
                VirtualPrinterDAO.getInstance().delete(printer.getVirtualPrinter());
            }
            this.b();
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void a(Exception exception) {
        POSMessageDialog.showError(exception.getMessage(), exception);
    }

    protected void doAddPrinter() {
        AddPrinterDialog addPrinterDialog = new AddPrinterDialog();
        addPrinterDialog.titlePanel.setTitle(VirtualPrinter.PRINTER_TYPE_NAMES[this.e] + " - Printer");
        addPrinterDialog.open();
        if (addPrinterDialog.isCanceled()) {
            return;
        }
        Printer printer = addPrinterDialog.getPrinter();
        VirtualPrinterDAO virtualPrinterDAO = VirtualPrinterDAO.getInstance();
        if (virtualPrinterDAO.findPrinterByName(printer.getVirtualPrinter().getName()) != null) {
            POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.12"));
            return;
        }
        if (printer.isDefaultPrinter()) {
            for (Printer object2 : this.a) {
                object2.setDefaultPrinter(false);
            }
        }
        VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
        for (Printer printer2 : this.a) {
            if (!virtualPrinter.equals(printer2.getVirtualPrinter())) continue;
            POSMessageDialog.showError(this.getParent(), Messages.getString("MultiPrinterPane.2"));
            return;
        }
        virtualPrinter.setType(this.e);
        VirtualPrinterDAO.getInstance().saveOrUpdate(virtualPrinter);
        TerminalPrinters terminalPrinters = addPrinterDialog.getTerminalPrinter();
        terminalPrinters.setTerminal(this.f);
        terminalPrinters.setPrinterName(printer.getDeviceName());
        terminalPrinters.setVirtualPrinter(printer.getVirtualPrinter());
        TerminalPrintersDAO.getInstance().saveOrUpdate(terminalPrinters);
        this.a.add(printer);
        this.b.addElement(printer);
        this.b();
    }

    private void b() {
        this.a.clear();
        List<VirtualPrinter> list = VirtualPrinterDAO.getInstance().findAll();
        if (list != null && !list.isEmpty()) {
            for (VirtualPrinter virtualPrinter : list) {
                Printer printer = new Printer();
                printer.setVirtualPrinter(virtualPrinter);
                printer.setDeviceName("");
                TerminalPrinters terminalPrinters = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), this.f);
                if (terminalPrinters != null && virtualPrinter.getName().equals(terminalPrinters.getVirtualPrinter().getName())) {
                    printer.setDeviceName(terminalPrinters.getPrinterName());
                }
                this.a.add(printer);
            }
        }
        this.d.removeAll();
        this.d.addRows(this.a);
        this.c.validate();
        this.c.repaint();
    }

    private void c() {
        int n = this.c.getSelectedRow();
        if (n < 0) {
            return;
        }
        Printer printer = this.d.getRow(n = this.c.convertRowIndexToModel(n));
        if (printer.getDeviceName() == null) {
            PosLog.info(this.getClass(), "No print selected for " + printer.getType());
            return;
        }
        TerminalPrinters terminalPrinters = null;
        if (printer.getVirtualPrinter() != null) {
            terminalPrinters = TerminalPrintersDAO.getInstance().findPrinters(printer.getVirtualPrinter(), this.f);
        }
        try {
            ReceiptPrintService.testPrinter(terminalPrinters == null ? printer : PosPrinters.createPrinter(terminalPrinters), "System Information", ReceiptPrintService.getSystemInfo(printer.getDeviceName(), printer.getVirtualPrinter().getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

