/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseComboGroup;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "image", "orderTypeList", "properties", "discounts", "terminals", "recepieItems", "units", "sizes", "variantName", "parentMenuItem", "explorerImage"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MenuItem
extends BaseMenuItem
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String TRANSIENT_PROP_VENDOR_NAME = "vendorNames";
    public static final String PROP_UNIT_BASE_PRICE_KEY = "unit.{name}.price";
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private static final String JSON_PROP_MOD_PRICE_COMBO_ITEM = "menuitem.modifiable.price.on.comboItem";
    private transient String vendorNames;
    private Double priceRulePrice;
    private MenuItem parentMenuItem;
    private MenuItemInventoryStatus stockStatus;
    public static final String TYPE_RAW_METARIAL = "Raw Material";
    public static final String TYPE_INVENTORY_ITEM = "Inventory Item";
    public static final String TYPE_MENU_ITEM = "Menu Item";
    private transient JSONObject properties;

    public MenuItem() {
    }

    public MenuItem(String string) {
        super(string);
    }

    public MenuItem(String string, String string2, Double d) {
        super(string, string2, d);
    }

    public void setImage(ImageIcon imageIcon) {
    }

    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    public ImageIcon getExplorerImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return ImageResource.getScaledImageIcon(imageResource.getImageIcon(), PosUIManager.getSize(30));
        }
        return null;
    }

    public void setExplorerImage(ImageIcon imageIcon) {
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColorCode() {
        Integer n = super.getButtonColorCode();
        if (n == null || n == 0 || n == -1316371) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    @XmlTransient
    public Color getButtonColor() {
        Integer n = this.getButtonColorCode();
        if (n == null) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public void setButtonColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public String getDisplayName() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if ((terminal != null && terminal.isShowTranslatedName().booleanValue() || this.isVariant().booleanValue()) && StringUtils.isNotEmpty((String)super.getTranslatedName())) {
            return super.getTranslatedName();
        }
        String string = super.getName();
        return string;
    }

    @XmlTransient
    public String getVariantName() {
        String string = super.getName();
        List<Attribute> list = this.getAttributes();
        if (list == null) {
            return string;
        }
        string = string + " (";
        Iterator<Attribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            string = string + attribute.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public void setVariantName(String string) {
    }

    public void setDisplayName(String string) {
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String getUniqueId() {
        return ("menu_item_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d) {
        return this.convertToTicketItem(ticket, d, false);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, IUnit iUnit) {
        return this.convertToTicketItem(ticket, d, false, iUnit);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, boolean bl) {
        return this.convertToTicketItem(ticket, d, bl, null);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, boolean bl, IUnit iUnit) {
        Object object;
        Object object2;
        TicketItem ticketItem = null;
        MenuItem menuItem = this;
        boolean bl2 = this.isComboItem();
        Terminal terminal = Application.getInstance().getTerminal();
        Department department = terminal == null ? null : terminal.getDepartment();
        SalesArea salesArea = null;
        OrderType orderType = null;
        String string = null;
        CustomerGroup customerGroup = null;
        if (this.isVariant().booleanValue()) {
            menuItem = this.getParentMenuItem();
            bl2 = menuItem.isComboItem();
        }
        ticketItem = bl2 ? new ComboTicketItem() : (menuItem.isPizzaType() != false || menuItem.hasModifiers() || bl ? new ModifiableTicketItem() : new TicketItem());
        ticketItem.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        if (ticket != null) {
            orderType = ticket.getOrderType();
            salesArea = ticket.getSalesArea();
            string = ticket.getCustomerId();
        }
        if (orderType != null && orderType.isEnableCourse().booleanValue()) {
            object2 = menuItem.getCourseOrganizeId();
            ticketItem.setCourseId((String)object2);
            if (StringUtils.isNotEmpty((String)object2)) {
                Course course = DataProvider.get().getCourse((String)object2);
                ticketItem.setCourseName(course.getShortName());
            }
        }
        if (string != null && (object2 = DataProvider.get().getCustomer(string)) != null) {
            customerGroup = ((Customer)object2).getCustomerGroup();
        }
        ticketItem.setMenuItemId(this.getId());
        ticketItem.setMenuItem(this);
        ticketItem.setComboItem(menuItem.isComboItem());
        ticketItem.setPizzaType(this.isPizzaType());
        ticketItem.setFractionalUnit(menuItem.isFractionalUnit());
        ticketItem.setName(this.getDisplayName());
        ticketItem.setGroupId(menuItem.getMenuGroupId());
        ticketItem.setGroupName(menuItem.getMenuGroupName());
        ticketItem.setCategoryName(menuItem.getMenuCategoryName());
        ticketItem.setCategoryId(menuItem.getMenuCategoryId());
        ticketItem.setServiceChargeApplicable(menuItem.isServiceChargeApplicable());
        ticketItem.setServiceChargeRate(menuItem.getServiceCharge());
        ticketItem.setTaxOnServiceCharge(menuItem.isTaxOnServiceCharge());
        ticketItem.setUnitSelection(menuItem.isAllowUnitSelection());
        if (StringUtils.isNotEmpty((String)menuItem.getTranslatedName())) {
            ticketItem.addProperty("translatedName", menuItem.getTranslatedName());
        }
        if (this.priceRulePrice == null) {
            this.priceRulePrice = DataProvider.get().getPriceFromPriceRule(this, ticket.getOrderType(), department, salesArea, customerGroup);
        }
        if (this.isVariant().booleanValue()) {
            ticketItem.setUnitPrice(this.priceRulePrice + this.getParentMenuItem().getPrice());
        } else {
            ticketItem.setUnitPrice(this.priceRulePrice);
        }
        if (iUnit != null) {
            double d2 = this.getUnitQuantity(this.getUnit(), iUnit);
            String string2 = PROP_UNIT_BASE_PRICE_KEY;
            string2 = string2.replace("{name}", iUnit.getUniqueCode());
            object = this.getProperty(string2);
            Double d3 = StringUtils.isNotEmpty((String)object) ? Double.valueOf(menuItem.getPrice() / ticketItem.getUnitPrice() * Double.parseDouble((String)object)) : Double.valueOf(ticketItem.getUnitPrice() / d2);
            Double d4 = menuItem.getCost() / d2;
            ticketItem.setUnitName(iUnit.getUniqueCode());
            ticketItem.setUnitCost(d4);
            ticketItem.setUnitPrice(d3);
        } else {
            ticketItem.setUnitName(menuItem.getUnitName());
            ticketItem.setUnitCost(this.getCost());
        }
        ticketItem.setQuantity(d);
        ticketItem.setInventoryItem(menuItem.isInventoryItem());
        ticketItem.setTicket(ticket);
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setBeverage(menuItem.isBeverage());
        ticketItem.setPrinterGroup(menuItem.getPrinterGroup());
        MenuItem.setItemTaxes(ticketItem, menuItem.getTaxGroup(), ticket.getOrderType());
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setPrintKitchenSticker(menuItem.isPrintKitchenSticker());
        List<Discount> list = menuItem.getDiscounts();
        if (list != null) {
            for (Discount discount : list) {
                if (!discount.isAutoApply().booleanValue()) continue;
                object = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
                ticketItem.addTodiscounts((TicketItemDiscount)object);
            }
        }
        return ticketItem;
    }

    public String getCourseOrganizeId() {
        String string = super.getCourseId();
        return string;
    }

    public static TicketItemDiscount convertToTicketItemDiscount(Discount discount, TicketItem ticketItem) {
        TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
        ticketItemDiscount.setDiscountId(discount.getId());
        ticketItemDiscount.setAutoApply(discount.isAutoApply());
        ticketItemDiscount.setName(discount.getName());
        ticketItemDiscount.setType(discount.getType());
        ticketItemDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketItemDiscount.setValue(discount.getValue());
        ticketItemDiscount.setAmount(discount.getValue());
        ticketItemDiscount.setCouponQuantity(1.0);
        ticketItemDiscount.setTicketItem(ticketItem);
        return ticketItemDiscount;
    }

    public boolean hasModifiers() {
        return super.isHasModifiers();
    }

    public boolean hasMandatoryModifiers() {
        return super.isHasMandatoryModifiers();
    }

    public boolean hasAutoShowGroup() {
        List<MenuItemModifierSpec> list = this.getMenuItemModiferSpecs();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            if (!menuItemModifierSpec.isAutoShow().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static TaxGroup getOutletTaxGroup() {
        Outlet outlet = Application.getOutlet();
        if (outlet != null) {
            TaxGroup taxGroup = outlet.getTaxGroup();
            return taxGroup;
        }
        return null;
    }

    public static void setItemTaxes(TicketItem ticketItem, TaxGroup object, OrderType orderType) {
        Object object2;
        ArrayList<TicketItemTax> arrayList = new ArrayList<TicketItemTax>();
        if (ticketItem.getTicket() != null && (object2 = ticketItem.getTicket().getSubOrderType()) != null) {
            if (object2 == SubOrderType.FOR_HERE) {
                object = orderType.getForHereTaxGroup();
            } else if (object2 == SubOrderType.TO_GO) {
                object = orderType.getToGoTaxGroup();
            }
        }
        if (object == null) {
            object2 = orderType.getDefaultTaxGroup();
            object = object2 != null ? object2 : MenuItem.getOutletTaxGroup();
        }
        if (object == null) {
            return;
        }
        object2 = object.getTaxes();
        if (object2 != null) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Tax tax = (Tax)iterator.next();
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(tax.getId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                arrayList.add(ticketItemTax);
            }
            ticketItem.setTaxes(arrayList);
        }
    }

    public String getStringWithUnderScore(String string, String string2) {
        string = string.replaceAll(" ", "_");
        return string + string2;
    }

    @XmlTransient
    public Set<MenuItemSize> getSizes() {
        HashSet<MenuItemSize> hashSet = new HashSet<MenuItemSize>();
        List<PizzaPrice> list = this.getPizzaPriceList();
        if (list != null) {
            for (PizzaPrice pizzaPrice : list) {
                hashSet.add(pizzaPrice.getSize());
            }
        }
        return hashSet;
    }

    public Set<PizzaCrust> getCrustsForSize(MenuItemSize menuItemSize) {
        HashSet<PizzaCrust> hashSet = new HashSet<PizzaCrust>();
        List<PizzaPrice> list = this.getPizzaPriceList();
        if (list != null) {
            for (PizzaPrice pizzaPrice : list) {
                if (!menuItemSize.equals(pizzaPrice.getSize())) continue;
                hashSet.add(pizzaPrice.getCrust());
            }
        }
        return hashSet;
    }

    public Set<PizzaPrice> getAvailablePrices(MenuItemSize menuItemSize) {
        HashSet<PizzaPrice> hashSet = new HashSet<PizzaPrice>();
        List<PizzaPrice> list = this.getPizzaPriceList();
        if (list != null) {
            for (PizzaPrice pizzaPrice : list) {
                if (!menuItemSize.equals(pizzaPrice.getSize())) continue;
                hashSet.add(pizzaPrice);
            }
        }
        return hashSet;
    }

    public List<IUnit> getUnits() {
        Object object;
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit != null && inventoryUnit.getUnitGroup() != null && (object = inventoryUnit.getUnitGroup().getUnits()) != null) {
            arrayList.addAll((Collection<IUnit>)object);
        }
        if (this.getStockUnits() != null) {
            for (InventoryStockUnit inventoryStockUnit : this.getStockUnits()) {
                arrayList.add(inventoryStockUnit.getPackagingUnit());
            }
        }
        return arrayList;
    }

    public Double getCost(IUnit iUnit) {
        if (iUnit == null) {
            return this.getCost();
        }
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit != null && iUnit.getUniqueCode().equals(inventoryUnit.getCode())) {
            return this.getCost();
        }
        if (iUnit instanceof InventoryUnit) {
            InventoryUnit inventoryUnit2 = (InventoryUnit)iUnit;
            return this.getCost() * this.getUnit().getConversionRate() / inventoryUnit2.getBaseUnitConversionValue();
        }
        if (iUnit instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)iUnit;
            for (InventoryStockUnit inventoryStockUnit : this.getStockUnits()) {
                if (!packagingUnit.getCode().equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                return inventoryStockUnit.getConversionValue() * this.getBaseUnitQuantity(inventoryStockUnit.getUnit().getUniqueCode()) * this.getCost();
            }
        }
        return this.getCost();
    }

    public Double getCost(String string) {
        if (string == null) {
            return this.getCost();
        }
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit != null) {
            Object object;
            Object object2;
            InventoryUnitGroup inventoryUnitGroup = inventoryUnit.getUnitGroup();
            if (inventoryUnitGroup != null && inventoryUnitGroup.getUnits() != null) {
                object2 = inventoryUnitGroup.getUnits().iterator();
                while (object2.hasNext()) {
                    object = (InventoryUnit)object2.next();
                    if (!((BaseInventoryUnit)object).getCode().equals(string)) continue;
                    return this.getCost((IUnit)object);
                }
            }
            if ((object2 = this.getStockUnits()) != null && object2.size() > 0) {
                object = object2.iterator();
                while (object.hasNext()) {
                    InventoryStockUnit inventoryStockUnit = (InventoryStockUnit)object.next();
                    if (!string.equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                    return this.getCost(inventoryStockUnit.getPackagingUnit());
                }
            }
        }
        return this.getCost();
    }

    public double getUnitQuantity(IUnit iUnit, IUnit iUnit2) {
        if (iUnit2 instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)iUnit2;
            for (InventoryStockUnit inventoryStockUnit : this.getStockUnits()) {
                if (!packagingUnit.getCode().equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                return 1.0 / (inventoryStockUnit.getConversionValue() * this.getBaseUnitQuantity(inventoryStockUnit.getUnit().getUniqueCode()));
            }
        }
        if (iUnit != null && iUnit2 != null) {
            return iUnit2.getConversionRate() / iUnit.getConversionRate();
        }
        return 1.0;
    }

    public double getBaseUnitQuantity(String string) {
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit == null || inventoryUnit.getCode().equals(string)) {
            return 1.0;
        }
        if (this.getStockUnits() != null) {
            for (InventoryStockUnit timedModel : this.getStockUnits()) {
                if (!timedModel.getPackagingUnit().getCode().equals(string)) continue;
                return timedModel.getBaseUnitValue();
            }
        }
        for (InventoryUnit inventoryUnit2 : inventoryUnit.getUnitGroup().getUnits()) {
            if (!inventoryUnit2.getCode().equals(string)) continue;
            return inventoryUnit.getConversionRate() / inventoryUnit2.getConversionRate();
        }
        return 1.0;
    }

    @Override
    public Double getAverageUnitPurchasePrice() {
        Double d = super.getAverageUnitPurchasePrice();
        if (d == 0.0) {
            return this.getCost();
        }
        return d;
    }

    @Override
    public String getSku() {
        String string = super.getSku();
        if (StringUtils.isEmpty((String)string)) {
            return super.getBarcode();
        }
        return string;
    }

    public Double getAvailableUnit() {
        if (this.stockStatus != null) {
            return this.stockStatus.getAvailableUnit();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getAvailableUnit();
    }

    public Double getUnitOnHand() {
        if (this.stockStatus != null) {
            return this.stockStatus.getUnitOnHand();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getUnitOnHand();
    }

    public void setUnitOnHand(Double d) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setUnitOnHand(d);
    }

    public void setAvailableUnit(Double d) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setAvailableUnit(d);
    }

    public Double getRetailPrice() {
        return this.getPrice();
    }

    @JsonIgnoreProperties
    @XmlTransient
    @Deprecated
    public MenuGroup getParent() {
        String string = this.getMenuGroupId();
        if (StringUtils.isNotEmpty((String)string)) {
            return MenuGroupDAO.getInstance().get(string);
        }
        return null;
    }

    public void setParent(MenuGroup menuGroup) {
        this.setMenuGroup(menuGroup);
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null) {
            this.setMenuGroupId(null);
            this.setMenuGroupName(null);
            this.setMenuCategoryId(null);
            this.setMenuCategoryName(null);
        } else {
            this.setMenuGroupId(menuGroup.getId());
            this.setMenuGroupName(menuGroup.getDisplayName());
            this.setMenuCategoryId(menuGroup.getMenuCategoryId());
            this.setMenuCategoryName(menuGroup.getMenuCategoryName());
        }
    }

    @XmlTransient
    public PrinterGroup getPrinterGroup() {
        return DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String string = null;
        if (printerGroup != null) {
            string = printerGroup.getId();
        }
        super.setPrinterGroupId(string);
    }

    @XmlTransient
    public InventoryUnit getUnit() {
        return DataProvider.get().getInventoryUnitById(this.getUnitId());
    }

    public void setUnit(InventoryUnit inventoryUnit) {
        String string = null;
        if (inventoryUnit != null) {
            string = inventoryUnit.getId();
            this.setUnitName(inventoryUnit.getCode());
        }
        super.setUnitId(string);
    }

    @XmlTransient
    public ReportGroup getReportGroup() {
        return DataProvider.get().getReportGroupById(this.getReportGroupId());
    }

    public void setReportGroup(ReportGroup reportGroup) {
        String string = null;
        if (reportGroup != null) {
            string = reportGroup.getId();
        }
        super.setReportGroupId(string);
    }

    @XmlTransient
    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String string = null;
        if (taxGroup != null) {
            string = taxGroup.getId();
        }
        super.setTaxGroupId(string);
    }

    public void setOrderTypeList(List list) {
    }

    public MenuItem getParentMenuItem() {
        if (this.parentMenuItem != null) {
            return this.parentMenuItem;
        }
        String string = this.getParentMenuItemId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.parentMenuItem = MenuItemDAO.getInstance().get(string);
        return this.parentMenuItem;
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.parentMenuItem = menuItem;
        String string = null;
        if (menuItem != null) {
            string = menuItem.getId();
        }
        super.setParentMenuItemId(string);
    }

    @Override
    public String getParentMenuItemId() {
        if (this.parentMenuItem != null && StringUtils.isNotEmpty((String)this.parentMenuItem.getId())) {
            return this.parentMenuItem.getId();
        }
        return super.getParentMenuItemId();
    }

    public MenuItemInventoryStatus getStockStatus() {
        if (!this.isInventoryItem().booleanValue()) {
            return null;
        }
        if (this.stockStatus != null || this.getId() == null) {
            return this.stockStatus;
        }
        this.stockStatus = DataProvider.get().getMenuItemStockStatus(this);
        return this.stockStatus;
    }

    public void setStockStatus(MenuItemInventoryStatus menuItemInventoryStatus) {
        this.stockStatus = menuItemInventoryStatus;
    }

    @Override
    public void setPropertiesJson(String string) {
        super.setPropertiesJson(string);
        this.properties = StringUtils.isNotEmpty((String)string) ? new JSONObject(string) : new JSONObject();
    }

    private void buildPropertis() {
        if (this.properties != null) {
            return;
        }
        String string = this.getPropertiesJson();
        if (StringUtils.isEmpty((String)string)) {
            this.properties = new JSONObject();
            return;
        }
        this.properties = new JSONObject(string);
    }

    public void addProperty(String string, String string2) {
        this.buildPropertis();
        this.properties.put(string, (Object)string2);
        this.setPropertiesJson(this.properties.toString());
    }

    public String getProperty(String string) {
        this.buildPropertis();
        if (this.properties.has(string)) {
            return this.properties.getString(string);
        }
        return null;
    }

    public void removeProperty(String string) {
        this.buildPropertis();
        this.properties.remove(string);
    }

    @Deprecated
    public Course getCourse() {
        String string = this.getCourseId();
        if (StringUtils.isNotEmpty((String)string)) {
            return CourseDAO.getInstance().get(string);
        }
        return null;
    }

    public void setCourse(Course course) {
        this.setCourseId(course == null ? null : course.getId());
    }

    public MenuItem clone() {
        Serializable serializable;
        List<PizzaPrice> list;
        MenuItem menuItem = new MenuItem();
        menuItem = (MenuItem)SerializationUtils.clone((Serializable)this);
        String string = MenuItem.doDuplicateName(this.getName());
        menuItem.setName(string);
        menuItem.setId(null);
        List<InventoryStockUnit> list3 = menuItem.getStockUnits();
        if (list3 != null) {
            for (InventoryStockUnit list22 : list3) {
                list22.setId(null);
                list22.setMenuItemId(menuItem.getId());
            }
        }
        List<ComboItem> list4 = menuItem.getComboItems();
        menuItem.setComboItems(new ArrayList<ComboItem>());
        if (list4 != null) {
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                list = (ComboItem)iterator.next();
                ((BaseComboItem)((Object)list)).setId(null);
                menuItem.getComboItems().add((ComboItem)((Object)list));
            }
        }
        List<ComboGroup> list2 = menuItem.getComboGroups();
        menuItem.setComboGroups(new ArrayList<ComboGroup>());
        if (list2 != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                serializable = (ComboGroup)list.next();
                ((BaseComboGroup)serializable).setId(null);
                menuItem.getComboGroups().add((ComboGroup)serializable);
            }
        }
        MenuItem.copyModifierSpecsToMenuItem(menuItem, menuItem.getMenuItemModiferSpecs());
        if (menuItem.isPizzaType().booleanValue() && (list = menuItem.getPizzaPriceList()) != null) {
            serializable = new ArrayList();
            for (PizzaPrice pizzaPrice : list) {
                PizzaPrice pizzaPrice2 = (PizzaPrice)SerializationUtils.clone((Serializable)pizzaPrice);
                pizzaPrice2.setId(null);
                serializable.add(pizzaPrice2);
            }
            menuItem.setPizzaPriceList((List<PizzaPrice>)((Object)serializable));
        }
        menuItem.setVariants(null);
        return menuItem;
    }

    public static void copyModifierSpecsToMenuItem(MenuItem menuItem, List<MenuItemModifierSpec> list) {
        ArrayList<MenuItemModifierSpec> arrayList = new ArrayList<MenuItemModifierSpec>();
        if (list != null) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                menuItemModifierSpec.setId(null);
                Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
                HashSet<MenuItemModifierPage> hashSet = new HashSet<MenuItemModifierPage>();
                if (set != null) {
                    for (MenuItemModifierPage menuItemModifierPage : set) {
                        ArrayList<MenuItemModifierPageItem> arrayList2 = new ArrayList<MenuItemModifierPageItem>();
                        menuItemModifierPage.setId(null);
                        menuItemModifierPage.setModifierSpecId(menuItemModifierSpec.getId());
                        List<MenuItemModifierPageItem> list2 = menuItemModifierPage.getPageItems();
                        if (list2 != null) {
                            for (MenuItemModifierPageItem menuItemModifierPageItem : list2) {
                                menuItemModifierPageItem.setId(null);
                                menuItemModifierPageItem.setParentPage(menuItemModifierPage);
                                arrayList2.add(menuItemModifierPageItem);
                            }
                        }
                        menuItemModifierPage.setPageItems(arrayList2);
                        hashSet.add(menuItemModifierPage);
                    }
                }
                menuItemModifierSpec.setModifierPages(hashSet);
                arrayList.add(menuItemModifierSpec);
            }
        }
        menuItem.setMenuItemModiferSpecs(arrayList);
    }

    private static String doDuplicateName(String string) {
        String string2 = new String();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string2 = string + " 1";
        } else {
            String string3 = string.substring(n + 1, string.length());
            if (StringUtils.isNumeric((String)string3)) {
                Integer n2 = Integer.valueOf(string3);
                n2 = n2 + 1;
                string2 = string.replace(string3, String.valueOf(n2));
            } else {
                string2 = string + " 1";
            }
        }
        return string2;
    }

    public void setUnitSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitSelection() {
        String string = this.getProperty("menuitem.allow_unit_selection");
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public String getVendorNames() {
        return this.vendorNames;
    }

    public void setVendorNames(String string) {
        this.vendorNames = string;
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public double getTotalTaxRate() {
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup != null) {
            return taxGroup.getTotalTaxRate();
        }
        return 0.0;
    }

    public void setTotalTaxRate(double d) {
    }

    @Override
    public void addTomenuItemModiferSpecs(MenuItemModifierSpec menuItemModifierSpec) {
        List<MenuItemModifierSpec> list = this.getMenuItemModiferSpecs();
        if (list == null) {
            list = new ArrayList<MenuItemModifierSpec>(1);
            this.setMenuItemModiferSpecs(list);
        }
        for (MenuItemModifierSpec menuItemModifierSpec2 : list) {
            if (!menuItemModifierSpec2.getModifierGroupId().equals(menuItemModifierSpec.getModifierGroupId())) continue;
            return;
        }
        list.add(menuItemModifierSpec);
    }

    @Override
    public String getUnitName() {
        InventoryUnit inventoryUnit;
        String string = super.getUnitName();
        if (StringUtils.isNotEmpty((String)string)) {
            return string;
        }
        String string2 = this.getUnitId();
        if (StringUtils.isNotEmpty((String)string2) && (inventoryUnit = DataProvider.get().getInventoryUnitById(string2)) != null) {
            return inventoryUnit.getCode();
        }
        return string;
    }

    @XmlTransient
    public void setModifiablePriceForComboItem(boolean bl) {
        this.addProperty(JSON_PROP_MOD_PRICE_COMBO_ITEM, String.valueOf(bl));
    }

    public boolean isModifiablePriceForComboItem() {
        String string = this.getProperty(JSON_PROP_MOD_PRICE_COMBO_ITEM);
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.valueOf(string);
        }
        return false;
    }
}

