/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DateUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class GenericDAO
extends _RootDAO {
    private static final GenericDAO instance = new GenericDAO();

    public static GenericDAO getInstance() {
        return instance;
    }

    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    @Override
    public Serializable save(Object object, Session session) {
        return super.save(object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) {
        super.saveOrUpdate(object, session);
    }

    @Override
    public Session getSession(String string, boolean bl) {
        return super.getSession(string, bl);
    }

    public List findAll(Class clazz, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        return criteria.list();
    }

    public void saveAll(List list, Session session) {
        Transaction transaction = session.beginTransaction();
        for (Object e : list) {
            session.saveOrUpdate(e);
        }
        transaction.commit();
    }

    @Override
    public void closeSession(Session session) {
        try {
            super.closeSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllUnSyncItem(Class clazz) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(clazz);
            Criterion criterion = Restrictions.isNull((String)InventoryStock.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryStock.PROP_LAST_UPDATE_TIME, (String)InventoryStock.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        String string2;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string3 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string2 = transaction.next();
            string3 = string3 + "'" + string2 + "'";
            if (!transaction.hasNext()) continue;
            string3 = string3 + ",";
        }
        string3 = string3 + ")";
        transaction = null;
        string2 = null;
        try {
            string2 = this.getSession();
            transaction = string2.beginTransaction();
            String string4 = "update " + string + " set %s=:lastSyncTime where %s in %s";
            string4 = String.format(string4, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID, string3);
            Query query = string2.createQuery(string4);
            Date date = new Date();
            query.setParameter("lastSyncTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string2);
        }
    }

    public void updateItemsLastSyncTimeByInt(List<Integer> list, String string) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            int n = transaction.next();
            string2 = string2 + n;
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string3 = "update " + string + " set %s=:lastSyncTime where %s in" + string2;
            string3 = String.format(string3, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID);
            Query query = session.createQuery(string3);
            Date date = new Date();
            query.setParameter("lastSyncTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz) {
        if (StringUtils.isBlank((String)string2)) {
            throw new PosException("Name is empty");
        }
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)string2));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string));
            }
            if ((list = criteria.list()) != null && list.size() > 0) {
                throw new PosException(String.format("The name %s is not available.", string2));
            }
        }
    }

    public void updateLastUpdateTimeProperty(Class clazz, Date date) {
        Store store = StoreDAO.getRestaurant();
        store.addProperty(clazz.getSimpleName() + "." + Store.PROP_LAST_UPDATE_TIME, DateUtil.formatDateWithDefaultTimeAndSec(date));
        StoreDAO.getInstance().saveOrUpdate(store);
    }
}

