/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.BaseGratuityDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.StoreUtil;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GratuityDAO
extends BaseGratuityDAO {
    public List<Gratuity> findByUser(User user) throws PosException {
        return this.findByUser(user, false);
    }

    public List<Gratuity> findByUser(User user, boolean bl) throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_PAID, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            throw new PosException("" + user.getFirstName() + " " + user.getLastName());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void payGratuities(List<Gratuity> list, List<GratuityPaymentHistory> list2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Gratuity comparable : list) {
                session.saveOrUpdate((Object)comparable);
            }
            for (GratuityPaymentHistory gratuityPaymentHistory : list2) {
                session.saveOrUpdate((Object)gratuityPaymentHistory);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new PosException("");
        }
        finally {
            this.closeSession(session);
        }
    }

    public TipsCashoutReport createReport(Date date, Date date2, User user) {
        return this.createReport(date, date2, user, false);
    }

    public TipsCashoutReport createReport(Date date, Date date2, User user, boolean bl) {
        Session session = null;
        try {
            Object object;
            session = this.getSession();
            if (date != null) {
                date = DateUtil.startOfDay(date);
            }
            if (date2 != null) {
                date2 = DateUtil.endOfDay(date2);
            }
            Criteria criteria = session.createCriteria(Ticket.class);
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            TipsCashoutReport tipsCashoutReport = new TipsCashoutReport();
            StoreSession storeSession = StoreUtil.getCurrentStoreOperation().getCurrentData();
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_GRATUITY));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)new Double(0.0)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
                tipsCashoutReport.setFromDate(storeSession.getOpenTime());
                tipsCashoutReport.setToDate(new Date());
            } else if (date == null && date2 == null) {
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_PAID), (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_REFUNDED), (Object)Boolean.FALSE));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            List list = criteria.list();
            tipsCashoutReport.setServer(user == null ? "ALL" : user.getId() + "/" + user.toString());
            tipsCashoutReport.setReportTime(new Date());
            if (!bl) {
                tipsCashoutReport.setFromDate(date);
                tipsCashoutReport.setToDate(date2);
            }
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                Set<PosTransaction> set;
                object = (Ticket)object2.next();
                Gratuity gratuity = ((BaseTicket)object).getGratuity();
                TipsCashoutReportData tipsCashoutReportData = new TipsCashoutReportData();
                tipsCashoutReportData.setTicketId(String.valueOf(((BaseTicket)object).getTokenNo()));
                tipsCashoutReportData.setTicketTotal(((Ticket)object).getTotalAmountWithTips());
                if (gratuity != null) {
                    tipsCashoutReportData.setDeclareTipsAmount(gratuity.getDeclareTipsAmount());
                }
                if ((object = TicketDAO.getInstance().loadCouponsAndTransactions(((BaseTicket)object).getId())) != null && (set = ((Ticket)object).getTransactions()) != null && set.size() > 0) {
                    for (PosTransaction posTransaction : set) {
                        if (posTransaction instanceof CashTransaction) {
                            tipsCashoutReportData.setCashTips(tipsCashoutReportData.getCashTips() + posTransaction.getTipsAmount());
                            continue;
                        }
                        tipsCashoutReportData.setChargedTips(tipsCashoutReportData.getChargedTips() + posTransaction.getTipsAmount());
                    }
                }
                if (gratuity != null && !gratuity.isRefunded().booleanValue()) {
                    if (date == null && date2 == null && tipsCashoutReportData.getCashTips() + tipsCashoutReportData.getChargedTips() + tipsCashoutReportData.getDeclareTipsAmount() <= 0.0) {
                        object2.remove();
                        continue;
                    }
                    if (gratuity.getAmount() > 0.0) {
                        tipsCashoutReportData.setSaleType("");
                    }
                    tipsCashoutReportData.setPaid(gratuity.isPaid());
                    tipsCashoutReportData.setTipsPaidAmount(gratuity.getTipsPaidAmount());
                }
                tipsCashoutReport.addReportData(tipsCashoutReportData);
            }
            criteria = session.createCriteria(DeclaredTips.class);
            criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
            if (date == null && date2 == null) {
                criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)storeSession.getId()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date2));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((object2 = criteria.uniqueResult()) != null) {
                tipsCashoutReport.setDeclaredTipsAmount((Double)object2);
            }
            tipsCashoutReport.calculateOthers();
            object = tipsCashoutReport;
            return object;
        }
        catch (Exception exception) {
            if (user != null) {
                throw new PosException("" + user.getFirstName() + " " + user.getLastName(), exception);
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findTotalGratuityAmount(Date date, Date date2, User user) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)Gratuity.PROP_AMOUNT), Gratuity.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                double d = number.doubleValue();
                return d;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0.0;
    }
}

