/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ImageResourceDAO
extends BaseImageResourceDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginationSupport paginationSupport, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            if (iMAGE_CATEGORY != null) {
                criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)iMAGE_CATEGORY.getType()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)ImageResource.PROP_DESCRIPTION, (String)string, (MatchMode)MatchMode.START));
            }
            if (iMAGE_CATEGORY != ImageResource.IMAGE_CATEGORY.DELETED) {
                criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            }
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.desc((String)ImageResource.PROP_LAST_UPDATE_TIME).nulls(NullPrecedence.LAST));
            int n = paginationSupport.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        catch (Exception exception) {
            paginationSupport.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getDefaultFloorImage(InputStream inputStream) throws Exception {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType()));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_DESCRIPTION, (Object)"default_floor_image"));
            List list = criteria.list();
            if (list.size() > 0) {
                ImageResource imageResource = (ImageResource)list.get(0);
                return imageResource;
            }
            if (inputStream != null) {
                ImageResource imageResource = new ImageResource();
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                imageResource.setImageBytes(byArray);
                imageResource.setDescription("default_floor_image");
                imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.save(imageResource);
                ImageResource imageResource2 = imageResource;
                return imageResource2;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource findById(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_ID, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                ImageResource imageResource = null;
                return imageResource;
            }
            ImageResource imageResource = (ImageResource)list.get(0);
            return imageResource;
        }
    }

    public void saveOrUpdate(List<ImageResource> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                this.saveOrUpdate(imageResource, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateImageResourceList(List<ImageResource> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                ImageResource imageResource2;
                if (imageResource.getImageBytes() == null) {
                    imageResource.setImageBytes(new byte[0]);
                }
                if ((imageResource2 = this.get(imageResource.getId())) != null) {
                    if (!BaseDataServiceDao.get().shouldSave(imageResource.getLastUpdateTime(), imageResource2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), imageResource.getId() + " already updated");
                        continue;
                    }
                    long l = imageResource2.getVersion();
                    PropertyUtils.copyProperties((Object)imageResource2, (Object)imageResource);
                    imageResource2.setVersion(l);
                    imageResource2.setUpdateLastUpdateTime(bl);
                    imageResource2.setUpdateSyncTime(bl2);
                    this.update(imageResource2, session);
                    continue;
                }
                imageResource.setUpdateLastUpdateTime(bl);
                imageResource.setUpdateSyncTime(bl2);
                this.save(imageResource, session);
            }
            transaction.commit();
        }
    }
}

