/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.dao.BaseMenuItemSizeDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class MenuItemSizeDAO
extends BaseMenuItemSizeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)MenuItemSize.PROP_SORT_ORDER);
    }

    public void saveOrUpdateSizeList(List<MenuItemSize> list, Session session) {
        for (MenuItemSize menuItemSize : list) {
            session.saveOrUpdate((Object)menuItemSize);
        }
    }

    public void saveOrUpdateList(List<MenuItemSize> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdateSizeList(list, session);
            transaction.commit();
        }
    }

    public void saveOrUpdateMenuItemSize(List<MenuItemSize> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuItemSize menuItemSize : list) {
                MenuItemSize menuItemSize2 = this.get(menuItemSize.getId());
                if (menuItemSize2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(menuItemSize.getLastUpdateTime(), menuItemSize2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), menuItemSize.getName() + " already updated");
                        continue;
                    }
                    long l = menuItemSize2.getVersion();
                    PropertyUtils.copyProperties((Object)menuItemSize2, (Object)menuItemSize);
                    menuItemSize2.setVersion(l);
                    menuItemSize2.setUpdateLastUpdateTime(bl);
                    menuItemSize2.setUpdateSyncTime(bl2);
                    this.update(menuItemSize2, session);
                    continue;
                }
                menuItemSize.setUpdateLastUpdateTime(bl);
                menuItemSize.setUpdateSyncTime(bl2);
                this.save(menuItemSize, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

