/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseOutletDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class OutletDAO
extends BaseOutletDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime((Outlet)object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime((Outlet)object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime((Outlet)object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outlet initialize(Outlet outlet) {
        if (outlet == null || outlet.getId() == null) {
            return outlet;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)outlet);
            Hibernate.initialize(outlet.getDepartments());
            Outlet outlet2 = outlet;
            return outlet2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlets(List<Outlet> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Outlet outlet : list) {
                Outlet outlet2 = this.get(outlet.getId());
                if (outlet2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(outlet.getLastUpdateTime(), outlet2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), outlet.getName() + " already updated");
                        continue;
                    }
                    long l = outlet2.getVersion();
                    PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
                    outlet2.setVersion(l);
                    outlet2.setUpdateLastUpdateTime(bl);
                    outlet2.setUpdateSyncTime(bl2);
                    this.update(outlet2, session);
                    continue;
                }
                outlet.setVersion(0L);
                outlet.setUpdateLastUpdateTime(bl);
                outlet.setUpdateSyncTime(bl2);
                this.save(outlet, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutletSyncable(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)Outlet.PROP_ID, (Object)string));
            }
            Criterion criterion = Restrictions.isNull((String)Outlet.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)Outlet.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)Outlet.PROP_LAST_UPDATE_TIME, (String)Outlet.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            if (list.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

