/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.dao.BasePizzaPriceDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PizzaPriceDAO
extends BasePizzaPriceDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdatePizzaPriceList(List<PizzaPrice> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (PizzaPrice pizzaPrice : list) {
                PizzaPrice pizzaPrice2 = this.get(pizzaPrice.getId());
                if (pizzaPrice2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(pizzaPrice.getLastUpdateTime(), pizzaPrice2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), pizzaPrice.getId() + " already updated");
                        continue;
                    }
                    long l = pizzaPrice2.getVersion();
                    PropertyUtils.copyProperties((Object)pizzaPrice2, (Object)pizzaPrice);
                    pizzaPrice2.setVersion(l);
                    pizzaPrice2.setUpdateLastUpdateTime(bl);
                    pizzaPrice2.setUpdateSyncTime(bl2);
                    this.update(pizzaPrice2, session);
                    continue;
                }
                pizzaPrice.setUpdateLastUpdateTime(bl);
                pizzaPrice.setUpdateSyncTime(bl2);
                this.save(pizzaPrice, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

