/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.AwtReceiptPrinter;
import com.floreantpos.print.ITextPrinter;
import com.floreantpos.print.PrinterType;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import io.github.escposjava.PrinterService;
import io.github.escposjava.print.Commands;
import io.github.escposjava.print.NetworkPrinter;
import io.github.escposjava.print.SerialPortPrinter;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class EscPosPrintService
extends ReceiptPrintServiceProvider {
    public static final int COL_RIGHT_FIELD_LENGTH = 13;
    public int totalCharLength;
    public int colLeftFieldLength;

    @Override
    public void printTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap hashMap, PosTransaction posTransaction, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, posTransaction, new TicketDataSource(ticket, false));
    }

    @Override
    public void printRefundTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, Ticket ticket, String string, String string2) throws Exception {
        this.a(string2, (Map<String, Object>)hashMap, ticket, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, String string, String string2) throws Exception {
        this.a(string2, (Map<String, Object>)hashMap, null, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        ITextPrinter iTextPrinter = ITextPrinter.create();
        iTextPrinter.createReport(null, hashMap, new TicketDataSource(ticket));
        iTextPrinter.rendererReport(jPanel);
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction posTransaction, JPanel jPanel) throws Exception {
        try {
            Ticket ticket = posTransaction.getTicket();
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            if (posTransaction != null && posTransaction.isCard()) {
                CardReader cardReader = CardReader.fromString(posTransaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return;
                }
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
                ITextPrinter iTextPrinter = ITextPrinter.create();
                iTextPrinter.createReport(null, hashMap, new TicketDataSource(ticket));
                iTextPrinter.rendererReport(jPanel);
            } else {
                ITextPrinter iTextPrinter = ITextPrinter.create();
                iTextPrinter.createReport(null, hashMap, new TicketDataSource(ticket));
                iTextPrinter.rendererReport(jPanel);
            }
        }
        catch (Exception exception) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        block0: {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            KitchenTicket kitchenTicket = iterator.next();
            kitchenTicket.setParentTicket(ticket);
            HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, "", "", true);
            ITextPrinter iTextPrinter = ITextPrinter.create();
            iTextPrinter.createReport(null, hashMap, new KitchenTicketDataSource(kitchenTicket));
            iTextPrinter.rendererReport(jPanel);
        }
    }

    private void a(String string, Map<String, Object> map, Ticket ticket, AbstractReportDataSource abstractReportDataSource) throws Exception {
        this.a(string, map, ticket, null, abstractReportDataSource);
    }

    private void a(String string, Map<String, Object> map, Ticket ticket, PosTransaction posTransaction, AbstractReportDataSource abstractReportDataSource) throws Exception {
        this.a(map);
        PrinterService printerService = this.createPrintService(string, map);
        this.addBoldText(printerService, map, "headerLine1", Commands.TXT_ALIGN_CT);
        this.addText(printerService, map, "ticketHeader", Commands.TXT_ALIGN_CT);
        this.a(printerService);
        this.addText(printerService, map, "additionalOrderInfo", Commands.TXT_ALIGN_LT);
        this.b(printerService);
        Store store = DataProvider.get().getStore();
        List list = abstractReportDataSource.getRows();
        if (list != null) {
            AbstractReportDataSource abstractReportDataSource2;
            if (abstractReportDataSource instanceof TicketDataSource) {
                abstractReportDataSource2 = (TicketDataSource)abstractReportDataSource;
                for (Object object : list) {
                    String string2;
                    if (StringUtils.isEmpty((String)object.getNameDisplay())) continue;
                    this.a(printerService, ((TicketDataSource)abstractReportDataSource2).getColorCode(store, (ITicketItem)object));
                    String string3 = string2 = this.getText(object.getNameDisplay(), "left", this.colLeftFieldLength);
                    String string4 = object.getSubTotalAmountDisplay();
                    if (StringUtils.isNotEmpty((String)string4)) {
                        int n;
                        if (object instanceof ComboTicketItem && (n = string2.indexOf("\n")) != -1) {
                            printerService.printRight(this.a(this.getText(string2.substring(0, n), "left", this.colLeftFieldLength), this.colLeftFieldLength, string4));
                            this.a(printerService);
                            String[] stringArray = string2.substring(n).split("\n");
                            if (stringArray.length <= 0) continue;
                            for (String string5 : stringArray) {
                                if (StringUtils.isBlank((String)string5)) continue;
                                printerService.printRight(this.a(this.getText(string5, "left", this.colLeftFieldLength), this.colLeftFieldLength, " "));
                                this.a(printerService);
                            }
                            continue;
                        }
                        string3 = string2.length() > this.colLeftFieldLength ? this.a(string2, this.colLeftFieldLength, string4) : string3 + this.getText(string4, "right", 13);
                    } else {
                        string3 = string3 + this.getText(" ", "right", 13);
                    }
                    printerService.printRight(string3);
                    this.a(printerService);
                }
            } else if (abstractReportDataSource instanceof KitchenTicketDataSource) {
                printerService.write(new byte[]{27, 33, 22});
                abstractReportDataSource2 = (KitchenTicketDataSource)abstractReportDataSource;
                for (Object object : list) {
                    if (StringUtils.isEmpty((String)((KitchenTicketItem)object).getMenuItemNameDisplay())) continue;
                    this.a(printerService, ((KitchenTicketDataSource)abstractReportDataSource2).getColorCode((KitchenTicketItem)object, ((BaseKitchenTicketItem)object).getKitchenTicket().getOrderTypeId()));
                    printerService.printLeft(((KitchenTicketItem)object).getMenuItemNameDisplay());
                    this.a(printerService);
                }
            }
        }
        printerService.setTextColor(Commands.COLOR_BLACK);
        printerService.setTextNormal();
        this.b(printerService);
        if (abstractReportDataSource instanceof TicketDataSource) {
            boolean bl;
            this.a(printerService, map, "totalText", "grandSubtotal", false);
            this.a(printerService, map, "discountText", "discountAmount");
            boolean bl2 = Boolean.parseBoolean(String.valueOf(map.get("isShowTaxBreakdown")));
            if (!bl2) {
                this.a(printerService, map, "taxText", "taxAmount");
            } else {
                map.put("taxBreakdownText", ReceiptPrintService.getTaxBreakdown(ticket, this.colLeftFieldLength, 13, true));
                this.addText(printerService, map, "taxBreakdownText", Commands.TXT_ALIGN_RT);
            }
            this.a(printerService, map, "serviceChargeText", "serviceCharge");
            this.a(printerService, map, "deliveryChargeText", "deliveryCharge");
            this.b(printerService);
            this.a(printerService, map, "netAmountText", "netAmount", false);
            this.a(printerService, map, "paidAmountText", "paidAmount", false);
            this.a(printerService, map, "refundAmountText", "refundAmount");
            this.a(printerService, map, "tenderAmountText", "tenderAmount");
            this.a(printerService, map, "dueAmountText", "dueAmount", false);
            if (map.get("tenderAmount") != null) {
                this.a(printerService, map, "changeAmountText", "changedAmount");
            }
            this.a(printerService, map, "tipsText", "tipAmount");
            if (map.get("showTips") != null) {
                this.a(printerService);
                this.addText(printerService, map, "showTips", Commands.TXT_ALIGN_CT);
            }
            this.a(printerService, map, "feeAmountText", "feeAmount");
            if (map.get("additionalPaymentProperties") != null) {
                map.put("additionalPaymentProperties", ReceiptPrintService.buildPayments(ticket, true));
            }
            this.addText(printerService, map, "additionalPaymentProperties", Commands.TXT_ALIGN_RT);
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                StringBuilder stringBuilder = ReceiptPrintService.buildMultiCurrency(ticket, posTransaction, null, true);
                if (stringBuilder != null) {
                    map.put("additionalProperties", stringBuilder.toString());
                } else {
                    Object object;
                    object = ReceiptPrintService.buildMulticurrencyBreakdown(ticket, null, true);
                    if (object != null) {
                        map.put("additionalProperties", ((StringBuilder)object).toString());
                    }
                }
            }
            this.addText(printerService, map, "additionalProperties", Commands.TXT_ALIGN_RT);
            boolean bl3 = Boolean.parseBoolean(String.valueOf(map.get("cardPayment")));
            boolean bl4 = bl = bl3 && Boolean.parseBoolean(String.valueOf(map.get("showTipsBlock")));
            if (bl) {
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.4"), "left", this.colLeftFieldLength));
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.5"), "left", this.colLeftFieldLength));
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.6"), "left", this.colLeftFieldLength));
            }
            if (bl3) {
                this.addText(printerService, map, "approvalCode", Commands.TXT_ALIGN_LT);
            }
            this.addText(printerService, map, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.a(printerService);
            this.addText(printerService, map, "copyType", Commands.TXT_ALIGN_CT);
            this.addText(printerService, map, "footerMessage", Commands.TXT_ALIGN_CT);
        } else {
            this.addText(printerService, map, "printerName", Commands.TXT_ALIGN_LT);
            this.addText(printerService, map, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.addText(printerService, map, "footerMessage", Commands.TXT_ALIGN_CT);
        }
        printerService.lineBreak(3);
        this.close(printerService);
    }

    public PrinterService createPrintService(String string, Map<String, Object> map) {
        String string2 = EscPosPrintService.valueOf(map.get("printerType"));
        PrinterService printerService = null;
        printerService = string2.equals(PrinterType.NETWORK.getName()) ? new PrinterService(EscPosPrintService.getNetworkPrinter(map)) : (string2.equals(PrinterType.SERIAL.getName()) ? new PrinterService(new SerialPortPrinter(String.valueOf(map.get("serialPort")))) : new PrinterService(new AwtReceiptPrinter(string)));
        printerService.open();
        printerService.init();
        return printerService;
    }

    public static NetworkPrinter getNetworkPrinter(Map map) {
        String string = EscPosPrintService.valueOf(map.get("ipAddress"));
        int n = POSUtil.parseInteger(String.valueOf(map.get("ipPort")));
        return new NetworkPrinter(string, n);
    }

    public void close(PrinterService printerService) throws Exception {
        printerService.cutPart();
        printerService.close();
    }

    private void a(PrinterService printerService, String string) {
        if (StringUtils.isEmpty((String)string)) {
            printerService.setTextColor(Commands.COLOR_BLACK);
            return;
        }
        if (string.equalsIgnoreCase("#ff0000")) {
            printerService.setTextColor(Commands.COLOR_RED);
        } else {
            printerService.setTextColor(Commands.COLOR_BLACK);
        }
    }

    private String a(String string, int n, String string2) {
        String string3 = "\n";
        if (string.length() == 0) {
            return "";
        }
        if (string.length() <= n) {
            return string + this.getText(string2, "right", 13);
        }
        String[] stringArray = string.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string4 : stringArray) {
            if (stringBuilder2.length() + 1 + string4.length() <= n) {
                stringBuilder2.append(string4).append(" ");
                continue;
            }
            stringBuilder.append(this.getText(stringBuilder2.toString(), "left", this.colLeftFieldLength) + this.getText(string2, "right", 13)).append(string3);
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append(string4).append(" ");
            string2 = " ";
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(this.getText(stringBuilder2.toString(), "left", this.colLeftFieldLength) + this.getText(string2, "right", 13));
        }
        return stringBuilder.toString();
    }

    private void a(Map<String, Object> map) {
        this.totalCharLength = POSUtil.getInteger(map.get("textLength"));
        if (this.totalCharLength <= 0) {
            this.totalCharLength = 42;
        }
        this.colLeftFieldLength = this.totalCharLength - 13;
    }

    private void a(PrinterService printerService) {
        printerService.lineBreak();
    }

    private void a(Map<String, Object> map, PrinterService printerService) {
        Image image = (Image)map.get("storeLogoIcon");
        if (image != null) {
            try {
                printerService.printImage(POSUtil.convertBlackAndWhiteImage(image));
            }
            catch (Exception exception) {
                PosLog.error(ReceiptPrintService.class, exception);
            }
        }
    }

    private void b(Map<String, Object> map, PrinterService printerService) {
        Object object = map.get(ReceiptParam.BARCODE.getParamName());
        if (object != null) {
            try {
                printerService.printBarcode(object.toString(), "CODE128", 255, 2, "OFF", "A");
            }
            catch (Exception exception) {
                PosLog.error(ReceiptPrintService.class, exception);
            }
        }
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string, String string2) {
        this.a(printerService, map, string, string2, true);
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string, String string2, boolean bl) {
        Object object = map.get(string2);
        if (bl && (object == null || object.equals("null") || object.equals("0.00"))) {
            return;
        }
        printerService.printRight(map.get(string) + this.getText(String.valueOf(map.get(string2)), "right", 13));
        this.a(printerService);
    }

    public String getText(String string, String string2, int n) {
        if (string == null) {
            string = "";
        }
        if (string2.equals("center")) {
            int n2 = (n - string.length()) / 2;
            for (int i = 1; i <= n2; ++i) {
                string = " " + string + " ";
            }
            return string;
        }
        if (string2.equals("right")) {
            int n3 = n - string.length();
            for (int i = 1; i <= n3; ++i) {
                string = " " + string;
            }
            return string;
        }
        if (string2.equals("left")) {
            int n4 = n - string.length();
            for (int i = 1; i <= n4; ++i) {
                string = string + " ";
            }
            return string;
        }
        return null;
    }

    private void b(PrinterService printerService) {
        String string = "";
        for (int i = 0; i < this.totalCharLength; ++i) {
            string = string + "-";
        }
        printerService.printLn(Commands.TXT_ALIGN_RT, string);
    }

    public void addBoldText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray) {
        printerService.setTextTypeBold();
        this.addText(printerService, map, string, byArray, true);
        printerService.setTextTypeNormal();
        this.a(printerService);
    }

    public void addText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray) {
        this.addText(printerService, map, string, byArray, false);
    }

    public void addText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray, boolean bl) {
        String[] stringArray;
        String string2 = String.valueOf(map.get(string));
        if (StringUtils.isEmpty((String)string2) || string2.equals("null")) {
            return;
        }
        if (string2.contains("<strike>")) {
            string2 = string2.replaceAll("<div><span><strike>", Messages.getString("EscPosPrintService.25"));
        }
        if ((stringArray = string2.split("<br>")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (StringUtils.isEmpty((String)string3)) {
                    printerService.print("\n");
                    continue;
                }
                if (string3.contains("<storeLogo")) {
                    this.a(map, printerService);
                    continue;
                }
                if (string3.contains("<barcode>")) {
                    this.a(printerService, byArray, bl, string3, false);
                    this.b(map, printerService);
                    continue;
                }
                this.a(printerService, byArray, bl, string3);
            }
        }
    }

    private void a(PrinterService printerService, byte[] byArray, boolean bl, String string) {
        this.a(printerService, byArray, bl, string, true);
    }

    private void a(PrinterService printerService, byte[] byArray, boolean bl, String string, boolean bl2) {
        String string2;
        if (string.contains("<b>") || bl) {
            printerService.setTextTypeBold();
        }
        if (StringUtils.isBlank((String)(string2 = string.replaceAll("<.*?>", "").replaceAll("</", "").replaceAll("&nbsp;", " ")))) {
            return;
        }
        if (bl2) {
            printerService.printLn(byArray, string2);
        } else {
            printerService.print(byArray, string2);
        }
        if (string.contains("</b>")) {
            printerService.setTextTypeNormal();
        }
    }

    private void b(PrinterService printerService, String string) {
        this.a(printerService);
        printerService.setTextTypeUnderline();
        printerService.printLn(Commands.TXT_ALIGN_RT, string);
        printerService.setTextTypeNormal();
        this.a(printerService);
    }

    public void addLine(Document document, int n) throws DocumentException {
        for (int i = 0; i < n; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    @Override
    public void testPrinter(HashMap<String, Object> hashMap, String string) throws Exception {
        PrinterService printerService = this.createPrintService(string, hashMap);
        this.addBoldText(printerService, hashMap, "title", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "data", Commands.TXT_ALIGN_LT);
        this.close(printerService);
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

