/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardSummaryReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class GiftCardSummaryReportView
extends TransparentPanel {
    private JButton a;
    private JPanel b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JCheckBox e;
    private JComboBox<String> f;

    public GiftCardSummaryReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        Date date = this.c.getDate();
        Date date2 = this.d.getDate();
        String string = (String)this.f.getSelectedItem();
        if (date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            this.b.removeAll();
            return;
        }
        List<GiftCard> list = GiftCardDAO.getInstance().findGiftCards(date, date2, this.e.isSelected(), string);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_summary_report"));
        HashMap hashMap = new HashMap();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap, date, date2);
        GiftCardSummaryReportModel giftCardSummaryReportModel = new GiftCardSummaryReportModel(list);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)giftCardSummaryReportModel));
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.b.removeAll();
        this.b.add((Component)jRViewer);
        this.b.revalidate();
    }

    private void a(HashMap hashMap, Date date, Date date2) {
        hashMap.put("reportTitle", Messages.getString("GiftCardSummaryReport"));
        hashMap.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + ReportService.formatFullDate(new Date()));
        hashMap.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + ReportService.formatShortDate(date));
        hashMap.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + ReportService.formatShortDate(date2));
        hashMap.put("colCNumber", Messages.getString("CardNumber"));
        hashMap.put("colOName", Messages.getString("GiftCardExplorer.44"));
        hashMap.put("colBatch", Messages.getString("GiftCardExplorer.48"));
        hashMap.put("colADate", Messages.getString("GiftCardSummaryReportView.2"));
        hashMap.put("colDDate", Messages.getString("GiftCardExplorer.56"));
        hashMap.put("colEDate", Messages.getString("EXpirationDate"));
        hashMap.put("colBalance", Messages.getString("CustomerExplorer.13") + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    private void b() {
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.e = new JCheckBox(Messages.getString("GiftCardSummaryReportView.1"));
        this.f = new JComboBox();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement(Messages.getString("GiftCardSummaryReportView.2"));
        comboBoxModel.addElement(Messages.getString("GiftCardSummaryReportView.3"));
        this.f.setModel(comboBoxModel);
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GiftCardSummaryReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel("Activated between "));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel("and "));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add((Component)new JLabel(Messages.getString("GiftCardSummaryReportView.6")), "gapLeft 20");
        jPanel.add(this.f);
        jPanel.add((Component)this.e, "gapLeft 20");
        jPanel.add((Component)this.a, "width 60!,gapLeft 20");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.b = new JPanel(new BorderLayout());
        jPanel2.add(this.b);
        this.add(jPanel2);
    }
}

