/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.BaseShiftDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.HourlySalesReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class HourlySalesReportView
extends TransparentPanel {
    private JButton a;
    private JComboBox b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JPanel e;
    private JPanel f;
    private JComboBox g;

    public HourlySalesReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        Object object;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        List<Comparable> list;
        Object object2;
        Date date;
        Date date2 = this.c.getDate();
        if (date2.after(date = this.d.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Terminal terminal = null;
        if (this.b.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.b.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        date2 = calendar.getTime();
        calendar.clear();
        calendar2.setTime(date);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        date = calendar.getTime();
        TicketDAO ticketDAO = TicketDAO.getInstance();
        AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        for (int i = 0; i < 24; ++i) {
            object2 = ticketDAO.findTicketsForLaborHour(date2, date, i, terminal);
            list = attendenceHistoryDAO.findNumberOfClockedInUserAtHour(date2, date, i, terminal);
            double d7 = list.size();
            double d8 = 0.0;
            d6 = 0.0;
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            if (object2 == null || object2.size() <= 0) continue;
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                Ticket ticket = (Ticket)object4.next();
                d8 += 1.0;
                d6 += (double)ticket.getNumberOfGuests().intValue();
                if (this.g.getSelectedIndex() == 0) {
                    d5 += ticket.getSubtotalAmount().doubleValue();
                    continue;
                }
                if (this.g.getSelectedIndex() == 1) {
                    d5 += ticket.getTotalAmountWithTips().doubleValue();
                    continue;
                }
                if (this.g.getSelectedIndex() != 2) continue;
                d5 += ticket.getPaidAmount().doubleValue();
            }
            for (User user : list) {
                d4 += user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
            }
            if (d7 > 0.0) {
                d4 /= d7;
                d3 = d5 / d7;
                d2 = d6 / d7;
                d = d8 / d7;
            }
            object4 = new LaborReportData();
            String object32 = "AM";
            String string = "PM";
            if (i >= 0 && i <= 11) {
                ((LaborReportData)object4).setPeriod(decimalFormat.format(i) + " " + object32);
            } else {
                ((LaborReportData)object4).setPeriod(decimalFormat.format(i) + " " + string);
            }
            ((LaborReportData)object4).setManHour(d7);
            ((LaborReportData)object4).setNoOfChecks(d8);
            ((LaborReportData)object4).setSales(d5);
            ((LaborReportData)object4).setNoOfGuests(d6);
            ((LaborReportData)object4).setLabor(d4);
            ((LaborReportData)object4).setSalesPerMHr(d3);
            ((LaborReportData)object4).setGuestsPerMHr(d2);
            ((LaborReportData)object4).setCheckPerMHr(d);
            double d9 = d4 != 0.0 ? (d5 != 0.0 ? d4 * 100.0 / d5 : 100.0) : 0.0;
            ((LaborReportData)object4).setLaborCost(d9);
            arrayList.add(object4);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        object2 = new ShiftDAO();
        list = ((BaseShiftDAO)object2).findAll();
        for (Shift shift : list) {
            List<Ticket> list2 = ticketDAO.findTicketsForShift(date2, date, shift, terminal);
            object = attendenceHistoryDAO.findNumberOfClockedInUserAtShift(date2, date, shift, terminal);
            d6 = object.size();
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            if (list2 == null || list2.size() <= 0) continue;
            for (Ticket ticket : list2) {
                d5 += 1.0;
                d4 += (double)ticket.getNumberOfGuests().intValue();
                if (this.g.getSelectedIndex() == 0) {
                    d3 += ticket.getSubtotalAmount().doubleValue();
                    continue;
                }
                if (this.g.getSelectedIndex() == 1) {
                    d3 += ticket.getTotalAmountWithTips().doubleValue();
                    continue;
                }
                if (this.g.getSelectedIndex() != 2) continue;
                d3 += ticket.getPaidAmount().doubleValue();
            }
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                User user = (User)((Object)object3.next());
                d2 += user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
            }
            if (d6 > 0.0) {
                d2 /= d6;
                d = d3 / d6;
                d10 = d4 / d6;
                d11 = d5 / d6;
            }
            object3 = new LaborReportData();
            ((LaborReportData)object3).setPeriod(shift.getName());
            ((LaborReportData)object3).setManHour(d6);
            ((LaborReportData)object3).setNoOfChecks(d5);
            ((LaborReportData)object3).setSales(d3);
            ((LaborReportData)object3).setNoOfGuests(d4);
            ((LaborReportData)object3).setLabor(d2);
            ((LaborReportData)object3).setSalesPerMHr(d);
            ((LaborReportData)object3).setGuestsPerMHr(d10);
            ((LaborReportData)object3).setCheckPerMHr(d11);
            ((LaborReportData)object3).setLaborCost(d2 * 100.0 / d3);
            arrayList2.add(object3);
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_subreport"));
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_shift_subreport"));
        JasperReport jasperReport22 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_report"));
        object = terminal == null ? POSConstants.ALL : terminal.getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportTime(hashMap, date2, date);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("reportTitle", Messages.getString("HourlySalesReportView.5"));
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("salesType", ReportUtil.reportLabelWithBoldTag(Messages.getString("salesType")) + this.g.getSelectedItem());
        hashMap.put("incr", ReportUtil.reportLabelWithBoldTag(Messages.getString("incr")) + Messages.getString("HourlyLaborReportView.0"));
        hashMap.put("cntr", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + (String)object);
        hashMap.put("hourlyReport", (String)jasperReport);
        hashMap.put("hourlyReportDatasource", (String)new JRTableModelDataSource((TableModel)new HourlySalesReportModel(arrayList)));
        hashMap.put("shiftReport", (String)jasperReport2);
        hashMap.put("shiftReportDatasource", (String)new JRTableModelDataSource((TableModel)new HourlySalesReportModel(arrayList2)));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport22, hashMap, (JRDataSource)new JREmptyDataSource());
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.e.removeAll();
        this.e.add((Component)jRViewer);
        this.e.revalidate();
    }

    private void a(HashMap hashMap) {
        hashMap.put("SWRTitle", Messages.getString("ShiftWiseR"));
        hashMap.put("SRGTotal", POSConstants.GRAND_TOTAL);
        hashMap.put("SRPeriod", Messages.getString("PERIOD"));
        hashMap.put("SRChecks", Messages.getString("CHECKS"));
        hashMap.put("SRGuests", Messages.getString("GUESTS"));
        hashMap.put("SRSales", POSConstants.SALES);
        hashMap.put("SRMHour", Messages.getString("ManHour"));
        hashMap.put("SRSMH", Messages.getString("SManHour"));
        hashMap.put("SRGMH", Messages.getString("GManHour"));
        hashMap.put("SRCMH", Messages.getString("CManHour"));
        hashMap.put("SRLCost", Messages.getString("LaborCost"));
        hashMap.put("SRLCostP", Messages.getString("LaborCostP"));
    }

    private void b() {
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HourlySalesReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.b = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list = terminalDAO.findAll();
        list.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list));
        this.g = new JComboBox();
        this.g.addItem(Messages.getString("HourlySalesReportView.7"));
        this.g.addItem(Messages.getString("HourlySalesReportView.8"));
        this.g.addItem(Messages.getString("HourlySalesReportView.9"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][][][][][]"));
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        jPanel.add(this.b);
        jPanel.add(new JLabel(Messages.getString("HourlySalesReportView.15") + ":"));
        jPanel.add(this.g);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.e = new JPanel(new BorderLayout());
        jPanel2.add(this.e);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.f;
    }

    public static class LaborReportData {
        private String a;
        private double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;

        public double getCheckPerMHr() {
            return this.i;
        }

        public void setCheckPerMHr(double d) {
            this.i = d;
        }

        public double getGuestsPerMHr() {
            return this.h;
        }

        public void setGuestsPerMHr(double d) {
            this.h = d;
        }

        public double getLabor() {
            return this.f;
        }

        public void setLabor(double d) {
            this.f = d;
        }

        public double getLaborCost() {
            return this.j;
        }

        public void setLaborCost(double d) {
            this.j = d;
        }

        public double getManHour() {
            return this.e;
        }

        public void setManHour(double d) {
            this.e = d;
        }

        public double getNoOfChecks() {
            return this.b;
        }

        public void setNoOfChecks(double d) {
            this.b = d;
        }

        public double getNoOfGuests() {
            return this.c;
        }

        public void setNoOfGuests(double d) {
            this.c = d;
        }

        public String getPeriod() {
            return this.a;
        }

        public void setPeriod(String string) {
            this.a = string;
        }

        public double getSales() {
            return this.d;
        }

        public void setSales(double d) {
            this.d = d;
        }

        public double getSalesPerMHr() {
            return this.g;
        }

        public void setSalesPerMHr(double d) {
            this.g = d;
        }
    }

    public static enum SalesType {
        GROSS_SALES,
        NET_SALES;

    }
}

