/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesDetailReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public SalesDetailReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SalesDetailReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(SalesDetailReportView.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void a() throws Exception {
        Date date;
        Date date2 = this.a.getDate();
        if (date2.after(date = this.b.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        date2 = DateUtil.startOfDay(date2);
        date = DateUtil.endOfDay(date);
        ReportService reportService = new ReportService();
        SalesDetailedReport salesDetailedReport = reportService.getSalesDetailedReport(date2, date);
        JasperReport jasperReport = ReportUtil.getReport("sales_summary_balance_detailed__1");
        JasperReport jasperReport2 = ReportUtil.getReport("sales_summary_balance_detailed_2");
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, null, date2, date, null);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("giftCertReturnCount", salesDetailedReport.getGiftCertReturnCount());
        hashMap.put("giftCertReturnAmount", salesDetailedReport.getGiftCertReturnAmount());
        hashMap.put("giftCertChangeCount", salesDetailedReport.getGiftCertChangeCount());
        hashMap.put("giftCertChangeAmount", salesDetailedReport.getGiftCertChangeAmount());
        hashMap.put("tipsCount", salesDetailedReport.getTipsCount());
        hashMap.put("tipsAmount", salesDetailedReport.getChargedTips());
        hashMap.put("tipsPaidAmount", salesDetailedReport.getTipsPaid());
        hashMap.put("drawerPullReport", (Number)jasperReport);
        hashMap.put("drawerPullDatasource", (Number)new JRTableModelDataSource((TableModel)salesDetailedReport.getDrawerPullDataTableModel()));
        hashMap.put("creditCardReport", (Number)jasperReport2);
        hashMap.put("creditCardReportDatasource", (Number)new JRTableModelDataSource((TableModel)salesDetailedReport.getCreditCardDataTableModel()));
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_detail_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.d.removeAll();
        this.d.add((Component)jRViewer);
        this.d.revalidate();
    }

    private void a(HashMap hashMap) {
        hashMap.put("SDRTitle", Messages.getString("PosMessage.237"));
        hashMap.put("MRGCR", Messages.getString("MRGCR"));
        hashMap.put("MRGCC", Messages.getString("MRGCC"));
        hashMap.put("MRTCT", Messages.getString("MRTCT"));
        hashMap.put("MRTP", Messages.getString("DrawerPullReportExplorer.26"));
        hashMap.put("MRCount", Messages.getString("MRCount"));
        hashMap.put("MRAmount", Messages.getString("MRAmount"));
        hashMap.put("SRDPRTitle", Messages.getString("SRDPRTitle"));
        hashMap.put("SRDPRCount", POSConstants.COUNT);
        hashMap.put("SRDPRIdeal", Messages.getString("SRDPRIdeal"));
        hashMap.put("SRDPRActual", Messages.getString("SRDPRActual"));
        hashMap.put("SRDPRVariant", Messages.getString("MenuItemForm.112"));
        hashMap.put("SRDPRTDP", Messages.getString("SRDPRTDP"));
        hashMap.put("SRCCard", Messages.getString("PaymentTypeSelectionDialog.4"));
        hashMap.put("SRSCount", Messages.getString("SalesCount"));
        hashMap.put("SRSAmount", Messages.getString("SalesAmount"));
        hashMap.put("SRRCount", Messages.getString("SRRCount"));
        hashMap.put("SRRAmount", Messages.getString("SRRAmount"));
        hashMap.put("SRNAmount", Messages.getString("SRNAmount"));
        hashMap.put("SRNTips", Messages.getString("SRNTips"));
        hashMap.put("SRTotal", POSConstants.TOTAL);
    }
}

