/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class SplitTicketService {
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    public static final int maxSplitQuantity = 100;

    static List<Double> a(double d, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = d - d2;
            double d4 = n - i;
            double d5 = d3 > 0.0 ? Math.max(NumberUtil.roundToTwoDigit(d3 / d4), 0.01) : 0.0;
            arrayList.add(d5);
            d2 += d5;
        }
        Double d6 = (Double)arrayList.get(n - 1);
        if (d2 < d) {
            d6 = d6 + (d - d2);
            arrayList.set(n - 1, d6);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Ticket> doEquallySplit(Ticket ticket, int n) throws Exception {
        HashMap<Integer, Ticket> hashMap = new HashMap<Integer, Ticket>();
        hashMap.put(1, ticket);
        SplitTicketService.a("=====Split value per ticket=====");
        double d = ticket.getTotalAmount();
        HashMap<Integer, Double> hashMap2 = new HashMap<Integer, Double>();
        if (ticket.getTicketItems().size() > 0) {
            int n2 = 0;
            if (ticket.getTicketItems().get(0).getTableRowNum() == 0) {
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    ticketItem.setTableRowNum(n2++);
                }
            }
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                double d2 = ticketItem.getSubtotalAmount() / (double)n;
                hashMap2.put(ticketItem.getTableRowNum(), d2);
                SplitTicketService.a(ticketItem.getQuantity() / (double)n + "x" + ticketItem.getName() + " :" + d2);
            }
        }
        double d3 = ticket.getSubtotalAmount() / (double)n;
        SplitTicketService.a("Subtotal.....................:" + d3);
        SplitTicketService.a("Tax..........................:" + ticket.getTaxAmount() / (double)n);
        SplitTicketService.a("Total........................:" + ticket.getTotalAmount() / (double)n);
        double d4 = 0.0;
        HashMap<Integer, Double> hashMap3 = new HashMap<Integer, Double>();
        for (int i = 1; i < n; ++i) {
            Ticket comparable = SplitTicketService.a(ticket, n);
            comparable.setSplitOrder(i + 1);
            SplitTicketService.a("=====Split " + (i + 1) + "=====");
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                TicketItem ticketItem2 = SplitTicketService.transferTicketItem(ticketItem, comparable, n);
                Double d2 = ticketItem2.getSubtotalAmount();
                if (i == 1) {
                    Double d5 = (Double)hashMap2.get(ticketItem.getTableRowNum());
                    if (d5 == null) {
                        d5 = 0.0;
                    }
                    Double d6 = d5 - d2;
                    hashMap3.put(ticketItem.getTableRowNum(), d6);
                }
                SplitTicketService.a(ticketItem2.getQuantity() + "x" + ticketItem2.getName() + " :" + d2);
            }
            comparable.addProperty("split", String.valueOf(Boolean.TRUE));
            comparable.addProperty(SPLIT_TYPE, String.valueOf(0));
            comparable.addProperty("split_ticket_id", ticket.getId());
            comparable.calculatePrice();
            d4 += comparable.getTotalAmount().doubleValue();
            hashMap.put(i + 1, comparable);
        }
        SplitTicketService.a(ticket, null, 0, n);
        SplitTicketService.a("=====Split Original ticket=====");
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            void var14_23;
            Double d7 = ticketItem.getSubtotalAmount();
            Double d8 = (Double)hashMap3.get(ticketItem.getTableRowNum());
            if (d8 == null) {
                Double d9 = 0.0;
            }
            double d10 = ticketItem.getQuantity() == 0.0 ? 0.0 : var14_23.doubleValue() / ticketItem.getQuantity();
            ticketItem.setUnitPrice(ticketItem.getUnitPrice() + d10);
            SplitTicketService.a(ticketItem.getQuantity() + "x" + ticketItem.getName() + " :" + d7);
        }
        ticket.addProperty("split", String.valueOf(Boolean.TRUE));
        ticket.addProperty(SPLIT_TYPE, String.valueOf(0));
        ticket.addProperty("split_ticket_id", ticket.getId());
        ticket.calculatePrice();
        double d10 = d - (d4 += ticket.getTotalAmount().doubleValue());
        SplitTicketService.adjustTicketTotalVariance(ticket, d10);
        SplitTicketService.a("Subtotal.....................:" + ticket.getSubtotalAmount());
        return new ArrayList<Ticket>(hashMap.values());
    }

    public static void adjustTicketTotalVariance(Ticket ticket, double d) {
        if (d != 0.0) {
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                double d2 = ticketItem.getSubtotalAmount();
                if (d2 == 0.0 || d2 < Math.abs(d)) continue;
                double d3 = ticketItem.getUnitPrice();
                double d4 = d3 * (d + d2) / d2;
                ticketItem.setUnitPrice(d4);
                break;
            }
            ticket.calculatePrice();
        }
    }

    private static void a(String string) {
    }

    public static List<Ticket> doSplitBySeatNumber(Ticket ticket) throws Exception {
        List<TicketItem> list;
        Integer n;
        double d = ticket.getTotalAmount();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        List<TicketItem> list2 = ticket.getTicketItems();
        ArrayList<TicketItem> arrayList2 = new ArrayList<TicketItem>();
        HashMap<Integer, Customer> hashMap = new HashMap<Integer, Customer>();
        HashMap<Integer, List<TicketItem>> hashMap2 = new HashMap<Integer, List<TicketItem>>();
        SplitTicketService.populateTicketItemMap(list2, arrayList2, hashMap, hashMap2);
        if (hashMap2.size() > 100) {
            throw new PosException(String.format(Messages.getString("SplitTicketService.16"), 100));
        }
        if (hashMap2.size() <= 1) {
            return null;
        }
        int n2 = 1;
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            list = (List<TicketItem>)hashMap2.get(n);
            if (list == null || list.size() != 1 || !list.get(0).isTreatAsSeat().booleanValue()) continue;
            iterator.remove();
        }
        int n3 = 0;
        if (hashMap2.keySet().size() > 1) {
            n3 = hashMap2.keySet().size();
        }
        n = (Integer)hashMap2.keySet().iterator().next();
        list = ticket.getTicketItems();
        List list3 = (List)hashMap2.get(n);
        list.clear();
        list.addAll(list3);
        ticket.addProperty("split", String.valueOf(Boolean.TRUE));
        ticket.addProperty(SPLIT_TYPE, String.valueOf(1));
        ticket.addProperty("split_seat_number", String.valueOf(n));
        ticket.addProperty("split_ticket_id", ticket.getId());
        arrayList.add(ticket);
        for (Integer n4 : hashMap2.keySet()) {
            if (n4.intValue() == n.intValue()) continue;
            List list4 = (List)hashMap2.get(n4);
            Ticket ticket2 = SplitTicketService.a(ticket, list4, arrayList2, n2, n3, 1);
            ticket2.addProperty("split", String.valueOf(Boolean.TRUE));
            ticket2.addProperty(SPLIT_TYPE, String.valueOf(1));
            ticket2.addProperty("split_seat_number", String.valueOf(n4));
            ticket2.addProperty("split_ticket_id", ticket.getId());
            Comparable comparable = (Customer)hashMap.get(n4);
            if (comparable != null) {
                ticket2.setCustomer((Customer)comparable);
            }
            arrayList.add(ticket2);
            ++n2;
        }
        SplitTicketService.a(ticket, arrayList2, n2, n3, 1);
        Customer customer = (Customer)hashMap.get(n);
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        if (arrayList2.size() > 0) {
            double d2 = 0.0;
            for (Comparable comparable : arrayList) {
                d2 += comparable.getTotalAmount().doubleValue();
            }
            double d3 = d - d2;
            SplitTicketService.adjustTicketTotalVariance(ticket, d3);
        }
        return arrayList;
    }

    public static void populateTicketItemMap(List<TicketItem> list, List<TicketItem> list2, Map<Integer, Customer> map, Map<Integer, List<TicketItem>> map2) {
        for (TicketItem ticketItem : list) {
            TicketItemSeat ticketItemSeat = ticketItem.getSeat();
            Integer n = ticketItemSeat == null ? ticketItem.getSeatNumber() : ticketItemSeat.getSeatNumber();
            List<TicketItem> list3 = map2.get(n);
            if (n == 0 && !ticketItem.isTreatAsSeat().booleanValue()) {
                list2.add(ticketItem);
                continue;
            }
            if (list3 == null) {
                list3 = new ArrayList<TicketItem>();
                list3.add(ticketItem);
                if (ticketItemSeat != null) {
                    map.put(n, ticketItemSeat.getMember());
                }
                map2.put(n, list3);
                continue;
            }
            list3.add(ticketItem);
        }
    }

    private static Ticket a(Ticket ticket, List<TicketItem> list, List<TicketItem> list2, int n, int n2, int n3) throws Exception {
        TicketItem ticketItem;
        Ticket ticket2 = SplitTicketService.a(ticket, n3);
        ticket2.setSplitOrder(n + 1);
        for (TicketItem ticketItem2 : list) {
            ticketItem = SplitTicketService.a(ticketItem2, 1);
            ticketItem.setTicket(ticket2);
            ticketItem.setPrintedToKitchen(ticketItem2.isPrintedToKitchen());
            ticket2.addToticketItems(ticketItem);
        }
        if (list2 != null && n2 > 1) {
            for (TicketItem ticketItem2 : list2) {
                ticketItem = SplitTicketService.a(ticketItem2, n2);
                ticketItem.setFractionalUnit(true);
                ticketItem.setPrintedToKitchen(ticketItem2.isPrintedToKitchen());
                ticket2.addToticketItems(ticketItem);
                ticketItem.setTicket(ticket2);
            }
        }
        ticket2.calculatePrice();
        return ticket2;
    }

    private static List<TicketDiscount> a(List<TicketDiscount> list, int n) throws Exception {
        ArrayList<TicketDiscount> arrayList = new ArrayList<TicketDiscount>();
        if (list != null && !list.isEmpty()) {
            for (TicketDiscount ticketDiscount : list) {
                TicketDiscount ticketDiscount2 = new TicketDiscount();
                PropertyUtils.copyProperties((Object)ticketDiscount2, (Object)ticketDiscount);
                ticketDiscount2.setId(null);
                if (ticketDiscount.getType() != 1) {
                    ticketDiscount2.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)n);
                }
                arrayList.add(ticketDiscount2);
            }
        }
        return arrayList;
    }

    public static TicketItem transferTicketItem(TicketItem ticketItem, Ticket ticket, int n) {
        TicketItem ticketItem2 = SplitTicketService.a(ticketItem, n);
        if (Double.isInfinite(n)) {
            return null;
        }
        if (n % 1 != 0) {
            ticketItem2.setFractionalUnit(true);
        }
        ticketItem2.setMenuItemId(ticketItem.getMenuItemId());
        ticketItem2.setTicket(ticket);
        ticketItem2.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
        ticket.addToticketItems(ticketItem2);
        return ticketItem2;
    }

    private static TicketItem a(TicketItem ticketItem, int n) {
        try {
            TicketItem ticketItem2 = ticketItem.cloneAsNew();
            ticketItem2.setQuantity(ticketItem.getQuantity() / (double)n);
            List<TicketItemDiscount> list = ticketItem2.getDiscounts();
            ticketItem2.calculatePrice();
            SplitTicketService.d(list, n);
            return ticketItem2;
        }
        catch (Exception exception) {
            return ticketItem;
        }
    }

    private static Ticket a(Ticket ticket, int n) throws Exception {
        Ticket ticket2 = new Ticket(true);
        PropertyUtils.copyProperties((Object)ticket2, (Object)ticket);
        ticket2.setProperties(null);
        ticket2.setTransactions(null);
        ticket2.setId(null);
        ticket2.setTokenNo(null);
        ticket2.setShortId(null);
        ticket2.setTicketItems(null);
        ticket2.setDiscounts(SplitTicketService.a(ticket.getDiscounts(), n));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<Integer> list = ticket.getTableNumbers();
        if (list != null) {
            arrayList.addAll(list);
        }
        ticket2.setTableNumbers(arrayList);
        ticket2.setCustomer(ticket.getCustomer());
        return ticket2;
    }

    private static void a(Ticket ticket, List<TicketItem> list, int n, int n2) throws Exception {
        SplitTicketService.a(ticket, list, n, n2, n2);
    }

    private static void a(Ticket ticket, List<TicketItem> list, int n, int n2, int n3) throws Exception {
        ticket.setSplitOrder(n + 1);
        SplitTicketService.b(ticket.getTicketItems(), n3);
        if (list != null && n2 > 1) {
            ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
            for (TicketItem ticketItem : list) {
                TicketItem ticketItem2 = SplitTicketService.a(ticketItem, n2);
                ticketItem2.setFractionalUnit(true);
                arrayList.add(ticketItem2);
                ticketItem2.setTicket(ticket);
            }
            for (TicketItem ticketItem : arrayList) {
                ticket.addToticketItems(ticketItem);
            }
        }
        SplitTicketService.c(ticket.getDiscounts(), n2);
        ticket.calculatePrice();
    }

    private static void b(List<TicketItem> list, int n) throws Exception {
        for (TicketItem ticketItem : list) {
            ticketItem.setQuantity(ticketItem.getQuantity() / (double)n);
            ticketItem.setFractionalUnit(true);
            ticketItem.calculatePrice();
            SplitTicketService.d(ticketItem.getDiscounts(), n);
        }
    }

    private static void c(List<TicketDiscount> list, int n) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (TicketDiscount ticketDiscount : list) {
                if (ticketDiscount.getType() == 1) continue;
                ticketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)n);
            }
        }
    }

    private static void d(List<TicketItemDiscount> list, int n) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() != 1) {
                    ticketItemDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity() / (double)n);
                }
                ticketItemDiscount.calculateDiscount(ticketItemDiscount.getTicketItem().getSubtotalAmount());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = AESencrp.decrypt("ICniG0w+rKbFnd+T2TUDUA==");
        System.out.println(string);
    }
}

