/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.teminaltype;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.teminaltype.TerminalCategory;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleObjectStateException;

public class TerminalTypeForm
extends BeanEditor<TerminalType> {
    private FixedLengthTextField a;
    private CheckBoxList b;
    private CheckBoxList c;
    private String d;
    private TerminalCategoryPanel e;

    public TerminalTypeForm() {
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        this.setBorder(BorderFactory.createTitledBorder("Terminal Type"));
        this.b = new CheckBoxList();
        this.b.setModel(OrderTypeDAO.getInstance().findAll());
        this.c = new CheckBoxList();
        this.c.setModel(MenuCategoryDAO.getInstance().findAll());
        JLabel jLabel = new JLabel("Name");
        this.add((Component)jLabel, "alignx right,aligny center");
        this.a = new FixedLengthTextField();
        this.add((Component)this.a, "alignx left,growx,split 2");
        this.e = new TerminalCategoryPanel();
        this.add((Component)this.e, "wrap");
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.1")));
        this.add((Component)jScrollPane, "skip 1,split 2,grow");
        JScrollPane jScrollPane2 = new JScrollPane(this.c);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.2")));
        this.add((Component)jScrollPane2, "grow");
    }

    @Override
    public void createNew() {
        TerminalType terminalType = new TerminalType();
        this.setBean(terminalType);
        this.a.setText("");
        this.b.unCheckAll();
        this.c.unCheckAll();
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.0")));
    }

    @Override
    public void cancel() {
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.4")));
    }

    @Override
    public void clearFields() {
        this.a.setText("");
        this.b.unCheckAll();
        this.c.unCheckAll();
        this.e.setSelectedTerminalCategory(0);
    }

    @Override
    public boolean delete() {
        try {
            TerminalType terminalType = (TerminalType)this.getBean();
            if (terminalType == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalTypeForm.5"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return false;
            }
            TerminalTypeDAO.getInstance().delete(terminalType);
            this.a.setText("");
            this.b.unCheckAll();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    public boolean deleteAllTables() {
        List<TerminalType> list = TerminalTypeDAO.getInstance().findAll();
        if (list.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Empty");
            return false;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalTypeForm.7"), Messages.getString("CONFIRM"));
        if (n != 0) {
            return false;
        }
        for (TerminalType terminalType : list) {
            TerminalTypeDAO.getInstance().delete(terminalType);
        }
        this.a.setText("");
        this.b.unCheckAll();
        return true;
    }

    public void setFieldsEditerminalType(boolean bl) {
        this.a.setEditable(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.b.setEnabled(bl);
        this.b.clearSelection();
        this.c.setEnabled(bl);
        this.c.clearSelection();
        this.a.setEnabled(bl);
        this.e.setEnableButtons(bl);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalType terminalType = (TerminalType)this.getBean();
            TerminalTypeDAO.getInstance().saveOrUpdate(terminalType);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("MessageDialog.0"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        TerminalType terminalType = (TerminalType)this.getBean();
        if (terminalType == null) {
            return;
        }
        TerminalTypeDAO.getInstance().initialize(terminalType);
        this.b.unCheckAll();
        this.c.unCheckAll();
        this.b.selectItems(terminalType.getOrderTypes());
        this.c.selectItems(terminalType.getCategories());
        this.a.setText(terminalType.getName());
        this.e.setSelectedTerminalCategory(terminalType.getType());
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.4")));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        TerminalType terminalType = (TerminalType)this.getBean();
        if (terminalType == null) {
            terminalType = new TerminalType();
            this.setBean(terminalType, false);
        }
        if (TerminalTypeDAO.getInstance().nameExists(terminalType, this.a.getText())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalTypeForm.3"));
            return false;
        }
        terminalType.setName(this.a.getText());
        List<OrderType> list = this.b.getCheckedValues();
        terminalType.setOrderTypes(list);
        List<MenuCategory> list2 = this.c.getCheckedValues();
        terminalType.setCategories(list2);
        terminalType.setType(this.e.getSelectedTerminalCategory());
        this.d = terminalType.getName();
        return true;
    }

    @Override
    public void edit() {
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.11")));
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("TerminalTypeForm.4");
    }

    public void setTableTypeCBoxListEnable(boolean bl) {
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
    }

    public String getNewlyAddedRow() {
        return this.d;
    }

    private class TerminalCategoryPanel
    extends JPanel {
        public TerminalCategoryPanel() {
            this.setLayout((LayoutManager)new MigLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            for (TerminalCategory terminalCategory : TerminalCategory.values()) {
                JRadioButton jRadioButton = new JRadioButton(terminalCategory.toString());
                jRadioButton.putClientProperty("terminalType", terminalCategory.getType());
                buttonGroup.add(jRadioButton);
                this.add(jRadioButton);
            }
        }

        public void setSelectedTerminalCategory(Integer n) {
            for (Component component : this.getComponents()) {
                JRadioButton jRadioButton = (JRadioButton)component;
                int n2 = (Integer)jRadioButton.getClientProperty("terminalType");
                if (n2 != n) continue;
                jRadioButton.setSelected(true);
                break;
            }
        }

        public void setEnableButtons(boolean bl) {
            for (Component component : this.getComponents()) {
                JRadioButton jRadioButton = (JRadioButton)component;
                jRadioButton.setEnabled(bl);
            }
        }

        public int getSelectedTerminalCategory() {
            for (Component component : this.getComponents()) {
                JRadioButton jRadioButton = (JRadioButton)component;
                if (!jRadioButton.isSelected()) continue;
                return (Integer)jRadioButton.getClientProperty("terminalType");
            }
            return 0;
        }
    }
}

