/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StoreSessionReportAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseStoreSession;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportHistoryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class DrawerAndStaffBankReportDialog
extends POSDialog {
    private TitlePanel a;
    private JTable b;
    private DrawerReportTableModel c;
    private List<CashDrawer> d;
    private DefaultListSelectionModel e;
    private PosButton f;
    private PosButton g;
    private User h;
    private Terminal i;

    public DrawerAndStaffBankReportDialog(User user) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(Messages.getString("DrawerAndStaffBankReportDialog.0"));
        this.h = user;
        this.c();
        this.initData();
    }

    public void initData() {
        this.i = Application.getInstance().getTerminal();
        this.e = new DefaultListSelectionModel();
        this.e.setSelectionMode(0);
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setDefaultRenderer(Object.class, new TableRenderer());
        this.c = new DrawerReportTableModel();
        this.b.setModel(this.c);
        this.a();
        boolean bl = StoreUtil.isStoreOpen() && this.h.hasPermission(UserPermission.OPEN_CLOSE_STORE);
        this.g.setVisible(bl);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportDialog.this.a(Integer.parseInt(actionEvent.getActionCommand()));
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.b, abstractAction, 3){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(5, 15, 5, 15, this.b.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(5, 15, 5, 15, this.b.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.g.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.g.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
        this.b();
    }

    private void a() {
        StoreSession storeSession = StoreUtil.getCurrentStoreOperation().getCurrentData();
        if (storeSession == null) {
            return;
        }
        this.d = new ArrayList<CashDrawer>();
        List<Terminal> list = TerminalDAO.getInstance().findCashDrawerTerminals();
        List<CashDrawer> list2 = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, true);
        for (CashDrawer comparable : list2) {
            if (comparable.getReportTime() != null) continue;
            this.d.add(comparable);
        }
        for (Terminal terminal : list) {
            if (terminal.getCurrentCashDrawer() != null) continue;
            CashDrawer cashDrawer = new CashDrawer();
            cashDrawer.setTerminal(terminal);
            cashDrawer.setAssignedUser(this.h);
            this.d.add(cashDrawer);
        }
        this.c.setRows(this.d);
        this.c.fireTableDataChanged();
    }

    private void b() {
        this.b.setAutoResizeMode(4);
        this.a(1, PosUIManager.getSize(100));
        this.a(2, PosUIManager.getSize(150));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void c() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a = new TitlePanel();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator = new JSeparator();
        PosButton posButton = new PosButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.b = new JTable();
        this.b.setRowHeight(PosUIManager.getSize(40));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        transparentPanel.setLayout(new BorderLayout(5, 5));
        transparentPanel.add((Component)jSeparator, "North");
        PosButton posButton2 = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.2"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionReportAction storeSessionReportAction = new StoreSessionReportAction(StoreUtil.getCurrentStoreOperation().getCurrentData());
                storeSessionReportAction.execute();
            }
        });
        this.f = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.3"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportHistoryDialog drawerAndStaffBankReportHistoryDialog = new DrawerAndStaffBankReportHistoryDialog(Application.getPosWindow(), DrawerAndStaffBankReportDialog.this.h, StoreUtil.getCurrentStoreOperation().getCurrentData());
                drawerAndStaffBankReportHistoryDialog.setInfo(Messages.getString("DrawerAndStaffBankReportDialog.4"));
                drawerAndStaffBankReportHistoryDialog.setSize(PosUIManager.getSize(880, 580));
                drawerAndStaffBankReportHistoryDialog.open();
            }
        });
        this.g = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.5"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportDialog.this.d();
            }
        });
        transparentPanel3.add(posButton2);
        transparentPanel3.add(this.f);
        transparentPanel3.add(this.g);
        posButton.setText(POSConstants.SAVE_BUTTON_TEXT);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportDialog.this.a(actionEvent);
            }
        });
        transparentPanel3.add(posButton);
        transparentPanel.add((Component)transparentPanel3, "Center");
        this.getContentPane().add((Component)transparentPanel, "South");
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel2.add((Component)this.a, "North");
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 15, 10, 15), jScrollPane.getBorder()));
        jScrollPane.setViewportView(this.b);
        transparentPanel2.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)transparentPanel2, "Center");
        this.setSize(PosUIManager.getSize(830, 550));
    }

    private void a(CashDrawer cashDrawer) {
        if (cashDrawer == null) {
            return;
        }
        if (cashDrawer.getDrawerType() == DrawerType.STAFF_BANK) {
            this.b(cashDrawer);
        } else {
            this.c(cashDrawer);
        }
    }

    private void d() {
        try {
            boolean bl;
            Object object;
            Object object2;
            int n;
            if (PosTransactionDAO.getInstance().hasUnauthorizedTransactions(null).booleanValue() && (n = POSMessageDialog.showYesNoQuestionDialog(this, (String)(object2 = Messages.getString("DrawerAndStaffBankReportDialog.6")), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            object2 = StoreUtil.getCurrentStoreOperation().getCurrentData();
            List<CashDrawer> list = CashDrawerDAO.getInstance().findByStoreOperationData((StoreSession)object2, true);
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    CashDrawer cashDrawer = (CashDrawer)object.next();
                    if (cashDrawer.getReportTime() != null) continue;
                    String string = Messages.getString("DrawerAndStaffBankReportDialog.8");
                    POSMessageDialog.showMessage(this, string);
                    return;
                }
            }
            boolean bl2 = bl = (object = UserDAO.getInstance().findClockedInUsers()) != null && object.size() > 0;
            if (bl && object.size() == 1) {
                boolean bl3 = bl = !((User)object.get(0)).getId().equals(this.h.getId());
            }
            if (bl) {
                String string = Messages.getString("DrawerAndStaffBankReportDialog.9");
                POSMessageDialog.showMessage(this, string);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DrawerAndStaffBankReportDialog.10"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DrawerAndStaffBankReportDialog.12"), Messages.getString("CONFIRM")) == 0) {
                this.e();
            }
            if (this.h.isClockedIn().booleanValue()) {
                this.a(this.h);
            }
            ((BaseStoreSession)object2).setCloseTime(new Date());
            ((StoreSession)object2).setClosedBy(this.h);
            StoreUtil.closeStore(this.h);
            try {
                PosPrintService.printCashDrawerReportSummary((StoreSession)object2);
            }
            catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
                POSMessageDialog.showError(this, Messages.getString("DrawerAndStaffBankReportDialog.14") + printerIsNotConfiguredException.getMessage());
            }
            String string = Messages.getString("DrawerAndStaffBankReportDialog.15");
            if (POSMessageDialog.showMessageAndPromtToPrint(string)) {
                try {
                    PosPrintService.printCashDrawerReportSummary((StoreSession)object2);
                }
                catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
                    POSMessageDialog.showError(this, Messages.getString("DrawerAndStaffBankReportDialog.16") + printerIsNotConfiguredException.getMessage());
                }
            }
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void e() {
        try {
            List<Terminal> list = TerminalDAO.getInstance().findAll();
            for (Terminal terminal : list) {
                List<String> list2 = PosTransactionDAO.getInstance().getDistinctCardMmerchantGateway(null, terminal.getId());
                if (list2.isEmpty()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("NoBatchClosed"));
                    return;
                }
                list2.forEach(string -> {
                    PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGatewayByName(string);
                    if (paymentGatewayPlugin != null) {
                        paymentGatewayPlugin.getProcessor().closeBatch(terminal, this.h);
                    }
                });
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerAndStaffBankReportDialog.17") + exception.getMessage(), exception);
        }
    }

    private void a(User user) {
        Calendar calendar;
        Comparable comparable;
        UserDAO.getInstance().refresh(user);
        AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
        AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
        if (attendenceHistory == null) {
            attendenceHistory = new AttendenceHistory();
            comparable = user.getLastClockInTime();
            calendar = Calendar.getInstance();
            calendar.setTime((Date)comparable);
            attendenceHistory.setClockInTime((Date)comparable);
            attendenceHistory.setClockInHour((short)calendar.get(10));
            attendenceHistory.setUser(user);
            attendenceHistory.setTerminal(Application.getInstance().getTerminal());
            attendenceHistory.setShift(user.getCurrentShift());
        }
        comparable = user.getCurrentShift();
        calendar = Calendar.getInstance();
        user.doClockOut(attendenceHistory, (Shift)comparable, calendar);
        String string = user.getFirstName();
        String string2 = user.getLastName();
        POSMessageDialog.showMessage(Messages.getString("USER") + " " + string + " " + string2 + Messages.getString("ClockInOutAction.10"));
    }

    private void b(CashDrawer cashDrawer) {
        try {
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.h, cashDrawer);
            cashDrawerReportDialog.setTitle(cashDrawer.getDrawerType() == DrawerType.STAFF_BANK ? Messages.getString("DrawerAndStaffBankReportDialog.19") : POSConstants.DRAWER_PULL_BUTTON_TEXT);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.openFullScreen();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void c(CashDrawer cashDrawer) {
        try {
            if (cashDrawer.getTerminal() == null) {
                return;
            }
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.h, cashDrawer);
            cashDrawerReportDialog.setTitle(POSConstants.DRAWER_PULL_BUTTON_TEXT);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.openFullScreen();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void setInfo(String string) {
        this.a.setTitle(string);
    }

    private void a(ActionEvent actionEvent) {
        this.dispose();
    }

    private void a(int n) {
        try {
            CashDrawer cashDrawer = (CashDrawer)this.c.getRowData(n);
            if (cashDrawer.getId() != null) {
                this.a(cashDrawer);
            } else {
                if (!this.h.isClockedIn().booleanValue()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DrawerAndStaffBankReportDialog.1"));
                    return;
                }
                DrawerAssignmentAction drawerAssignmentAction = new DrawerAssignmentAction(cashDrawer.getTerminal(), this.h);
                drawerAssignmentAction.execute();
            }
            this.a();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat b = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Terminal terminal;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if (n2 == 0 && (terminal = ((CashDrawer)(object2 = (CashDrawer)DrawerAndStaffBankReportDialog.this.d.get(n))).getTerminal()) != null) {
                if (((CashDrawer)object2).getDrawerType() != DrawerType.STAFF_BANK && terminal.getId().intValue() == DrawerAndStaffBankReportDialog.this.i.getId().intValue()) {
                    jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                } else if (terminal.getDeviceType() == 1) {
                    jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "mobile_32px.png"));
                }
            }
            if (object instanceof Date) {
                object2 = this.b.format(object);
                jLabel.setText((String)object2);
                jLabel.setHorizontalAlignment(4);
            }
            if (object instanceof Double) {
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            if (n2 == 1 || n2 == 2) {
                jLabel.setHorizontalAlignment(0);
            }
            return jLabel;
        }
    }

    class DrawerReportTableModel
    extends ListTableModel<CashDrawer> {
        public DrawerReportTableModel() {
            super(new String[]{Messages.getString("DrawerAndStaffBankReportDialog.20"), Messages.getString("Type"), Messages.getString("DrawerAndStaffBankReportDialog.22"), ""});
        }

        @Override
        public int getRowCount() {
            if (DrawerAndStaffBankReportDialog.this.d == null) {
                return 0;
            }
            int n = DrawerAndStaffBankReportDialog.this.d.size();
            return n;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3;
        }

        public CashDrawer getSelectedRow() {
            int n = DrawerAndStaffBankReportDialog.this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            n = DrawerAndStaffBankReportDialog.this.b.convertRowIndexToModel(n);
            return (CashDrawer)DrawerAndStaffBankReportDialog.this.c.getRowData(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (DrawerAndStaffBankReportDialog.this.d == null) {
                return "";
            }
            CashDrawer cashDrawer = (CashDrawer)DrawerAndStaffBankReportDialog.this.d.get(n);
            User user = cashDrawer.getAssignedUser();
            switch (n2) {
                case 0: {
                    if (cashDrawer.getDrawerType() == DrawerType.DRAWER) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.24") + cashDrawer.getTerminal();
                    }
                    return cashDrawer.getAssignedUser();
                }
                case 1: {
                    return cashDrawer.getDrawerType().toString();
                }
                case 2: {
                    if (cashDrawer.getId() == null) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.25");
                    }
                    if (user != null) {
                        return cashDrawer.getReportTime() == null ? Messages.getString("DrawerAndStaffBankReportDialog.26") : Messages.getString("DrawerAndStaffBankReportDialog.27");
                    }
                }
                case 3: {
                    if (cashDrawer.getId() == null) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.28");
                    }
                    return Messages.getString("DrawerAndStaffBankReportDialog.29");
                }
            }
            return "";
        }
    }
}

