/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.order.CashierModeNextActionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class OpenTicketsListDialog
extends POSDialog {
    private List<Ticket> a;
    private OpenTicketListTableModel b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private JScrollPane h;
    private JTable i;
    private TitlePanel j;
    private TransparentPanel k;
    private TransparentPanel l;
    private TransparentPanel m;
    private TransparentPanel n;
    private DefaultListSelectionModel o;

    public OpenTicketsListDialog() {
        this.a();
    }

    private void a() {
        this.b();
        this.setTitle(POSConstants.ACTIVE_TICKETS);
        this.j.setTitle(POSConstants.ACTIVE_TICKETS_BEFORE_DRAWER_RESET);
        TicketDAO ticketDAO = new TicketDAO();
        this.a = TerminalConfig.isCashierMode() ? ticketDAO.findOpenTicketsForUser(Application.getCurrentUser()) : ticketDAO.findOpenTickets();
        this.b = new OpenTicketListTableModel();
        this.i.setModel(this.b);
        this.i.setDefaultRenderer(Object.class, new TicketTableCellRenderer());
        this.i.setRowHeight(40);
        this.o = new DefaultListSelectionModel();
        this.o.setSelectionMode(0);
        this.i.setSelectionModel(this.o);
        if (TerminalConfig.isCashierMode()) {
            this.o.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Ticket ticket = (Ticket)OpenTicketsListDialog.this.a.get(OpenTicketsListDialog.this.i.getSelectedRow());
                    ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                    OrderView.getInstance().setCurrentTicket(ticket);
                    OpenTicketsListDialog.this.dispose();
                }
            });
        }
    }

    private void b() {
        this.j = new TitlePanel();
        this.k = new TransparentPanel();
        this.m = new TransparentPanel();
        this.c = new PosButton();
        this.n = new TransparentPanel();
        this.e = new PosButton();
        this.d = new PosButton();
        this.l = new TransparentPanel();
        this.h = new JScrollPane();
        this.i = new JTable();
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.j, "North");
        this.k.setLayout(new BorderLayout());
        this.m.setLayout(new FlowLayout(2));
        this.m.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        if (!TerminalConfig.isCashierMode()) {
            this.g = new PosButton();
            this.g.setText(POSConstants.VOID);
            this.g.setPreferredSize(new Dimension(100, 50));
            this.g.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenTicketsListDialog.this.e(actionEvent);
                }
            });
            this.m.add(this.g);
            this.f = new PosButton();
            this.f.setText("<html><body><center>TRANSFER<br>SERVER</center></body></html>");
            this.f.setPreferredSize(new Dimension(100, 50));
            this.f.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenTicketsListDialog.this.d(actionEvent);
                }
            });
            this.m.add(this.f);
        }
        this.c.setText(POSConstants.CLOSE);
        this.c.setPreferredSize(new Dimension(100, 50));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenTicketsListDialog.this.c(actionEvent);
            }
        });
        this.m.add(this.c);
        this.k.add((Component)this.m, "Center");
        this.n.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.e.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.e.setPreferredSize(new Dimension(80, 50));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenTicketsListDialog.this.a(actionEvent);
            }
        });
        this.n.add(this.e);
        this.d.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.d.setPreferredSize(new Dimension(80, 50));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenTicketsListDialog.this.b(actionEvent);
            }
        });
        this.n.add(this.d);
        this.k.add((Component)this.n, "West");
        this.getContentPane().add((Component)this.k, "South");
        this.l.setLayout(new BorderLayout(0, 5));
        this.l.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.i.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.h.setViewportView(this.i);
        this.l.add((Component)this.h, "Center");
        this.getContentPane().add((Component)this.l, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 646) / 2, (dimension.height - 435) / 2, 646, 435);
    }

    private void a(ActionEvent actionEvent) {
        int n = this.i.getSelectedRow();
        int n2 = this.b.getRowCount();
        n = n <= 0 ? n2 - 1 : (n > n2 - 1 ? n2 - 1 : --n);
        this.i.transferFocus();
        this.o.setLeadSelectionIndex(n);
        Rectangle rectangle = this.i.getCellRect(n, 0, false);
        this.i.scrollRectToVisible(rectangle);
    }

    private void b(ActionEvent actionEvent) {
        int n = this.i.getSelectedRow();
        int n2 = this.b.getRowCount();
        n = n < 0 ? 0 : (n >= n2 - 1 ? 0 : ++n);
        this.i.transferFocus();
        this.o.setLeadSelectionIndex(n);
        Rectangle rectangle = this.i.getCellRect(n, 0, false);
        this.i.scrollRectToVisible(rectangle);
    }

    private Ticket c() {
        int n = this.i.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, POSConstants.SELECT_TICKET);
            return null;
        }
        return this.a.get(n);
    }

    private void c(ActionEvent actionEvent) {
        this.canceled = false;
        this.dispose();
        if (TerminalConfig.isCashierMode()) {
            String string = Messages.getString("OpenTicketsListDialog.0");
            CashierModeNextActionDialog cashierModeNextActionDialog = new CashierModeNextActionDialog(string);
            cashierModeNextActionDialog.open();
        }
    }

    private void d(ActionEvent actionEvent) {
        try {
            Ticket ticket = this.c();
            if (ticket != null) {
                UserListDialog userListDialog = new UserListDialog();
                userListDialog.open();
                if (!userListDialog.isCanceled()) {
                    User user = userListDialog.getSelectedUser();
                    if (!ticket.getOwner().equals(user)) {
                        ticket.setOwner(user);
                        TicketDAO.getInstance().update(ticket);
                        this.i.repaint();
                    }
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE);
        }
    }

    private void e(ActionEvent actionEvent) {
        Ticket ticket = this.c();
        if (ticket == null) {
            return;
        }
        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        VoidTicketDialog voidTicketDialog = new VoidTicketDialog();
        voidTicketDialog.setTicket(ticket2);
        voidTicketDialog.open();
        if (!voidTicketDialog.isCanceled()) {
            this.b.a(ticket2);
        }
    }

    class TicketTableCellRenderer
    extends DefaultTableCellRenderer {
        Font a = this.getFont().deriveFont(1, 12.0f);
        SimpleDateFormat b = new SimpleDateFormat("MMM-dd-yy hh:mm a");
        String c = CurrencyUtil.getCurrencySymbol();

        TicketTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setFont(this.a);
            if (object instanceof Date) {
                jLabel.setText(this.b.format(object));
                jLabel.setHorizontalAlignment(0);
            } else if (object instanceof Double) {
                jLabel.setText(this.c + NumberUtil.formatNumber((double)((Double)object)));
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            return jLabel;
        }
    }

    class OpenTicketListTableModel
    extends AbstractTableModel {
        OpenTicketListTableModel() {
        }

        @Override
        public int getRowCount() {
            if (OpenTicketsListDialog.this.a == null) {
                return 0;
            }
            return OpenTicketsListDialog.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return POSConstants.TICKET_ID;
                }
                case 1: {
                    return POSConstants.SERVER;
                }
                case 2: {
                    return POSConstants.DATE_TIME;
                }
                case 3: {
                    return POSConstants.TOTAL;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (OpenTicketsListDialog.this.a == null) {
                return null;
            }
            Ticket ticket = (Ticket)OpenTicketsListDialog.this.a.get(n);
            switch (n2) {
                case 0: {
                    return Long.valueOf(ticket.getId());
                }
                case 1: {
                    return ticket.getOwner().toString();
                }
                case 2: {
                    return ticket.getCreateDate();
                }
                case 3: {
                    return (double)ticket.getTotalAmountWithTips();
                }
            }
            return null;
        }

        void a(Ticket ticket) {
            OpenTicketsListDialog.this.a.remove(ticket);
            this.fireTableDataChanged();
        }
    }
}

