/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleDocument;
import com.floreantpos.swing.IntegerDocument;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VoidItemFormDialog
extends OkCancelOptionDialog {
    private POSTextField a = new POSTextField(10);
    private TicketItem b;
    private VoidItem c;
    private POSComboBox d;
    private POSToggleButton e;
    private VoidReason f;
    private PosButton g;
    private PosButton h;
    private ComboBoxModel i;

    public VoidItemFormDialog(TicketItem ticketItem) {
        super(POSUtil.getFocusedWindow(), Messages.getString("VoidItemFormDialog.0"));
        this.b = ticketItem;
        this.c = new VoidItem();
        this.inItComponents();
        this.a();
    }

    public void inItComponents() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("VOID_TICKET_BUTTON_TEXT") + " " + this.b.getName());
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center", "[][]", ""));
        JPanel jPanel2 = new JPanel(new BorderLayout(7, 0));
        JLabel jLabel = new JLabel("How Many Unit :");
        this.g = new PosButton("+");
        this.h = new PosButton("-");
        if (this.b.isFractionalUnit().booleanValue()) {
            this.a.setDocument(new DoubleDocument());
        } else {
            this.a.setDocument(new IntegerDocument());
        }
        jPanel2.add((Component)this.h, "West");
        jPanel2.add((Component)this.a, "Center");
        jPanel2.add((Component)this.g, "East");
        JLabel jLabel2 = new JLabel(Messages.getString("VoidItemViewerTableModel.1"));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
        this.i = new ComboBoxModel();
        this.d = new POSComboBox();
        this.d.setModel(this.i);
        this.d.setSelectedIndex(-1);
        PosButton posButton = new PosButton("+");
        jPanel3.add((Component)this.d, "Center");
        jPanel3.add((Component)posButton, "East");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VoidItemFormDialog.this.c();
            }
        });
        jPanel.add((Component)jLabel, "");
        jPanel.add(jPanel2);
        this.e = new POSToggleButton(Messages.getString("VoidItemFormDialog.5"));
        jPanel.add((Component)this.e, "right, wrap");
        jPanel.add((Component)jLabel2, "alignx right");
        jPanel.add((Component)jPanel3, "growx,span");
        this.add((Component)jPanel, "Center");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jPanel.add((Component)((Object)qwertyKeyPad), "gaptop 50, newline,span");
        this.buttonAction();
    }

    private void a() {
        this.i.setDataList(VoidReasonDAO.getInstance().findAll());
        if (this.d.getMaximumRowCount() > 5) {
            this.d.setMaximumRowCount(5);
        }
        this.a.setText(this.b.getItemQuantityDisplay());
    }

    private boolean b() {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.a.getText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = this.e.isSelected();
        this.f = (VoidReason)this.d.getSelectedItem();
        if (this.f != null) {
            this.c.setVoidReason(this.f.getReasonText());
        }
        this.c.setMenuItemId(this.b.getMenuItemId());
        this.c.setMenuItemName(this.b.getName());
        this.c.setUnitPrice(this.b.getUnitPrice());
        this.c.setQuantity(d);
        this.c.setItemWasted(bl);
        this.c.setVoidDate(new Date());
        this.c.setModifier(false);
        this.c.setPrinterGroup(this.b.getPrinterGroup());
        this.c.setVoidByUser(Application.getCurrentUser());
        this.c.setTerminal(Application.getInstance().getTerminal());
        double d2 = this.b.getUnitPrice() * this.c.getQuantity();
        double d3 = d2 * (this.b.getTotalTaxRate() / 100.0);
        this.c.setTaxAmount(d3);
        this.c.setTotalPrice(d2 + d3);
        return true;
    }

    public VoidItem getVoidItem() {
        return this.c;
    }

    @Override
    public void doOk() {
        this.b();
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        try {
            NotesDialog notesDialog = new NotesDialog();
            notesDialog.setTitle(Messages.getString("VoidItemFormDialog.7"));
            notesDialog.open();
            if (notesDialog.isCanceled()) {
                return;
            }
            String string = notesDialog.getNote();
            for (VoidReason voidReason : this.i.getDataList()) {
                if (!voidReason.getReasonText().equalsIgnoreCase(string)) continue;
                this.i.setSelectedItem(voidReason);
                return;
            }
            this.f = new VoidReason();
            this.f.setReasonText(string);
            VoidReasonDAO.getInstance().saveOrUpdate(this.f);
            this.i.addElement(this.f);
            this.i.setSelectedItem(this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("VoidItemFormDialog.8"), exception);
        }
    }

    public void buttonAction() {
        try {
            this.h.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = 0.0;
                    try {
                        d = Double.parseDouble(VoidItemFormDialog.this.a.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    d -= 1.0;
                    if (d < 0.0) {
                        POSMessageDialog.showMessage(Messages.getString("VoidItemFormDialog.9"));
                    } else {
                        VoidItemFormDialog.this.a.setText(NumberUtil.trimDecilamIfNotNeeded(d));
                    }
                }
            });
            this.g.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = 0.0;
                    try {
                        d = Double.parseDouble(VoidItemFormDialog.this.a.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    VoidItemFormDialog.this.a.setText(NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }
}

