/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.model.dao.GenericDAO;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class NameBaseIdGenerator
implements IdentifierGenerator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        Class<?> clazz = object.getClass();
        try {
            Object object2;
            Method method = clazz.getMethod("getId", null);
            if (method != null && (object2 = method.invoke(object, (Object[])null)) != null) {
                return (Serializable)object2;
            }
            method = clazz.getMethod("getName", null);
            if (method == null) {
                throw new HibernateException(clazz.getName() + Messages.getString("NameBaseIdGenerator.2"));
            }
            object2 = (String)method.invoke(object, (Object[])null);
            if (object2 == null) {
                throw new HibernateException(Messages.getString("NameBaseIdGenerator.3") + clazz.getName());
            }
            try (Session session = GenericDAO.getInstance().createNewSession();){
                String string = NameBaseIdGenerator.generateId((String)object2, clazz, 0, session);
                return string;
            }
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
    }

    public static String generateId(String string, Class<? extends Object> clazz, int n, Session session) {
        Object object;
        String string2 = String.valueOf(Math.abs(string.hashCode()));
        if (n > 0) {
            string2 = string2 + "_" + n;
        }
        if ((object = session.get(clazz, (Serializable)((Object)string2))) == null) {
            return string2;
        }
        return NameBaseIdGenerator.generateId(string, clazz, ++n, session);
    }

    public static String generateId(String string) {
        return String.valueOf(Math.abs(string.hashCode()));
    }
}

