/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.NumberBound;
import com.floreantpos.util.CurrencyUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NumberUtil {
    private static final NumberFormat a = NumberFormat.getNumberInstance();
    private static final NumberFormat b = NumberFormat.getNumberInstance();
    private static final DecimalFormat c = new DecimalFormat("#.##");
    private static final DecimalFormat d = new DecimalFormat("0.00");
    private static final NumberFormat e = new DecimalFormat("0");
    private static final NumberFormat f = new DecimalFormat("0.00##");
    private static final NumberFormat g = new DecimalFormat("0.######");
    private static Map<NumberBound, Pattern> h = new HashMap<NumberBound, Pattern>();
    private static final char i;
    private static final char j;

    public static double round(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public static double round(double d, int n) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToOneDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(1, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToTwoDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToThreeDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(3, 4);
        return bigDecimal.doubleValue();
    }

    public static String format3DigitNumber(Double d) {
        if (d == null) {
            return b.format(0L);
        }
        String string = b.format(d);
        return string;
    }

    public static String format6DigitNumber(Double d) {
        if (d == null) {
            return g.format(0L);
        }
        String string = g.format(d);
        return string;
    }

    public static String formatNumber(Double d, boolean bl) {
        if (d == null) {
            return a.format(0L);
        }
        String string = a.format(d);
        if (!bl && string.startsWith("-")) {
            return a.format(0L);
        }
        return string;
    }

    public static String formatNumber(Double d) {
        return NumberUtil.formatNumber(d, false);
    }

    public static String trimDecilamIfNotNeeded(Double d) {
        return NumberUtil.trimDecilamIfNotNeeded(d, false);
    }

    public static String trimDecilamIfNotNeeded(Double d, boolean bl) {
        if (d == null) {
            return c.format(0L);
        }
        String string = c.format(d);
        if (bl) {
            return string;
        }
        if (string.startsWith("-")) {
            return c.format(0L);
        }
        return string;
    }

    public static String formatNumberAcceptNegative(Double d) {
        if (d == null) {
            return a.format(0L);
        }
        return a.format(d);
    }

    public static Number parse(String string) throws ParseException {
        if (StringUtils.isEmpty((String)string)) {
            return 0;
        }
        return a.parse(string);
    }

    public static Number parseOrGetZero(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return 0;
            }
            return a.parse(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String getCurrencyFormat(Object object) {
        return CurrencyUtil.getCurrencySymbol() + f.format(object);
    }

    public static String getCurrencyFormatWithoutCurrencySymbol(Object object) {
        return f.format(object);
    }

    public static double getCurrencyFormatWithoutSymbol(Object object) {
        return Double.valueOf(f.format(object));
    }

    public static int getIntegerFormat(Object object) {
        return Integer.valueOf(e.format(object));
    }

    public static BigDecimal convertToBigDecimal(double d) {
        return new BigDecimal(Double.toString(d));
    }

    public static BigDecimal convertToBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public static boolean isZero(Double d) {
        String string = NumberUtil.d.format(d);
        try {
            return Math.abs(NumberUtil.d.parse(string).doubleValue()) == 0.0;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static Boolean isFractional(String string) {
        try {
            return NumberUtil.isFractional(Double.parseDouble(string));
        }
        catch (Exception exception) {
            PosLog.error(NumberUtil.class, exception);
            return null;
        }
    }

    public static Boolean isFractional(Double d) {
        int n;
        if (d == null || d.isNaN()) {
            return null;
        }
        double d2 = d;
        return d2 > (d = new Double(n = (int)d2));
    }

    public static String formatNumberIfNeeded(Double d) {
        Boolean bl = NumberUtil.isFractional(d);
        String string = bl != false ? NumberUtil.formatNumber(d) : String.valueOf((int)d.doubleValue());
        return string;
    }

    public static String formatAmount(Double d) {
        return f.format(d);
    }

    public static boolean isValidDouble(String string) {
        return NumberUtil.a(string, new NumberBound(8, 2));
    }

    public static boolean isValidDouble(String string, int n, int n2) {
        return NumberUtil.a(string, new NumberBound(n, n2));
    }

    private static boolean a(String string, NumberBound numberBound) {
        if (string == null) {
            return false;
        }
        Pattern pattern = NumberUtil.getPattern(numberBound);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        String string2 = "" + decimalFormatSymbols.getGroupingSeparator();
        string = string.replace(string2, "");
        return pattern.matcher(string).matches();
    }

    public static Pattern getPattern(NumberBound numberBound) {
        if (!h.containsKey(numberBound)) {
            NumberUtil.a(numberBound);
        }
        Pattern pattern = h.get(numberBound);
        return pattern;
    }

    private static void a(NumberBound numberBound) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[-+]?[0-9]{0,");
        stringBuilder.append(numberBound.getBeforeDecimal());
        stringBuilder.append("}(\\");
        stringBuilder.append(i);
        stringBuilder.append("[0-9]{0,");
        stringBuilder.append(numberBound.getAfterDecimal());
        stringBuilder.append("})?");
        String string = stringBuilder.toString();
        h.put(numberBound, Pattern.compile(string));
    }

    public static char getDecimalSeparator() {
        return i;
    }

    public static char getGroupingSeparator() {
        return j;
    }

    static {
        a.setMinimumFractionDigits(2);
        a.setMaximumFractionDigits(2);
        b.setMinimumFractionDigits(3);
        b.setMaximumFractionDigits(3);
        a.setGroupingUsed(false);
        b.setGroupingUsed(false);
        f.setGroupingUsed(true);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT));
        i = decimalFormatSymbols.getDecimalSeparator();
        j = decimalFormatSymbols.getGroupingSeparator();
    }
}

