/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.sun.jersey.api.client.ClientHandlerException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class CloudLoginPanel
extends JPanel {
    public static final String VIEW_NAME = "login";
    private POSTextField a;
    private POSTextField b;
    private POSPasswordField c;
    private JPanel d;
    private ActionListener e;
    private boolean f = false;
    private String g;
    private String h;

    public CloudLoginPanel(ActionListener actionListener) {
        this.e = actionListener;
        this.initComponents();
        this.updateView();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.d = new JPanel();
        this.d.setLayout((LayoutManager)new MigLayout("fillx,ins 20", "[][fill, grow]", ""));
        this.a = new POSTextField();
        this.b = new POSTextField();
        this.c = new POSPasswordField();
        if (Application.getInstance().isDevelopmentMode()) {
            this.d.add(new JLabel(Messages.getString("ServerAddress") + ":"));
            this.d.add((Component)this.a, "grow, wrap");
        }
        this.d.add(new JLabel(Messages.getString("CloudLoginPanel.2") + ":"));
        this.d.add((Component)this.b, "grow, wrap");
        this.d.add(new JLabel(Messages.getString("PASSWORD") + ":"));
        this.d.add((Component)this.c, "grow, wrap");
        JButton jButton = new JButton(Messages.getString("TestConnection"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudLoginPanel.this.checkConnection();
            }
        });
        JLabel jLabel = new JLabel(Messages.getString("CloudLoginPanel.7"));
        jLabel.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.d.add((Component)jLabel, "newline,span 2,right");
        this.d.add((Component)jButton, "newline,span,split 2,right");
        JButton jButton2 = new JButton(Messages.getString("CloudLoginPanel.11"));
        jButton2.setActionCommand("register");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudLoginPanel.this.e.actionPerformed(actionEvent);
            }
        });
        this.d.add(jButton2);
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        PosButton posButton = new PosButton();
        PosButton posButton2 = new PosButton();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.setLayout(new FlowLayout());
        posButton.setText(POSConstants.SAVE_BUTTON_TEXT.toUpperCase());
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudLoginPanel.this.doOk();
            }
        });
        jPanel.add(posButton);
        posButton2.setText(POSConstants.CANCEL);
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudLoginPanel.this.a(true);
            }
        });
        jPanel.add(posButton2);
        jPanel2.add((Component)jSeparator, "North");
        jPanel2.add((Component)jPanel, "Center");
        this.add(this.d);
        this.add((Component)jPanel2, "South");
    }

    protected void checkConnection() {
        try {
            String string = this.a.getText();
            String string2 = this.b.getText();
            String string3 = new String(this.c.getPassword());
            String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.0"));
                return;
            }
            if (StringUtils.isEmpty((String)string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.1"));
                return;
            }
            if (!EmailValidator.getInstance().isValid(string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.3"));
                return;
            }
            if (StringUtils.isEmpty((String)string3)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.4"));
                return;
            }
            PosResponse posResponse = PosWebService.get().checkConnection(string, string2, AESencrp.encrypt(string3), string4);
            if (posResponse != null) {
                if (posResponse.getResponseCode() == 200) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.13"));
                } else {
                    POSMessageDialog.showError(posResponse.getMsg());
                }
            }
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this.d);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void updateView() {
        try {
            Store store = StoreDAO.getRestaurant();
            String string = store.getProperty("web.service.url");
            String string2 = store.getProperty("web.service.password");
            String string3 = store.getProperty("web.service.username");
            if (StringUtils.isNotEmpty((String)string2)) {
                string2 = AESencrp.decrypt(string2);
            }
            this.a.setText(StringUtils.isEmpty((String)string) ? "https://siiopa.com/console" : string);
            this.b.setText(string3);
            this.c.setText(string2);
            this.g = string;
            this.h = string3;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private boolean a() throws Exception {
        String string = this.a.getText();
        String string2 = this.b.getText();
        String string3 = new String(this.c.getPassword());
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("CloudLoginPanel.0"));
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.1"));
        }
        if (!EmailValidator.getInstance().isValid(string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.3"));
        }
        if (StringUtils.isEmpty((String)string3)) {
            throw new PosException(Messages.getString("CloudLoginPanel.4"));
        }
        string3 = AESencrp.encrypt(string3);
        Store store = StoreDAO.getRestaurant();
        this.f = !string.equalsIgnoreCase(this.g) || !string2.equals(this.h);
        store.addProperty("web.service.url", string);
        store.addProperty("web.service.username", string2);
        store.addProperty("web.service.password", string3);
        String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
        PosResponse posResponse = PosWebService.get().login(string, string2, string3, string4);
        if (posResponse != null && posResponse.getResponseCode() == 200) {
            String string5 = posResponse.getStoreId();
            String string6 = posResponse.getCustomerId();
            store.addProperty("web.service.schema", string5);
            store.addProperty("web.service.customer.id", string6);
            store.setUuid(string5);
            StoreDAO.getInstance().saveOrUpdate(store);
            Application.getInstance().refreshStore();
            String string7 = AppConfig.getString("store_uuid");
            if (string7 != null && !posResponse.getStoreId().equals(string7)) {
                try {
                    AppConfig.put("store_uuid", posResponse.getStoreId());
                    OroMqttClient.getInstance().subscribe();
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception.getMessage());
                }
            }
            return true;
        }
        throw new Exception(posResponse.getMsg());
    }

    public void doOk() {
        try {
            int n;
            this.a();
            if (this.f) {
                StoreDAO.getInstance().removeLastUpdateTime();
            }
            this.a((n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.17"), Messages.getString("CONFIRM"))) != 0);
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }
}

