/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.MqttSender;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class OroMqttMessageReceiver
implements IMqttMessageListener {
    private List<OroMqttDataListener> dataListeners = new ArrayList<OroMqttDataListener>();

    public void messageArrived(String string, final MqttMessage mqttMessage) throws Exception {
        AsyncAction.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = POSUtil.decompress(mqttMessage.getPayload());
                    if (StringUtils.isEmpty((String)string)) {
                        return;
                    }
                    OroMqttMessageReceiver.this.debug("Notification received: ");
                    JSONObject jSONObject = new JSONObject(string);
                    if (!OroMqttMessageReceiver.this.isValidMessage(jSONObject)) {
                        return;
                    }
                    OroMqttMessageReceiver.this.messageReceived(jSONObject);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
        });
    }

    private void messageReceived(JSONObject jSONObject) throws Exception {
        String string;
        if (this.isPosLogFileRequest(jSONObject)) {
            MailService.doSendEmailPosLogFile(jSONObject.toString());
            return;
        }
        if (!this.isValidMqttSender(jSONObject)) {
            return;
        }
        BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
        String string2 = jSONObject.toString();
        switch (string = jSONObject.getString("request")) {
            case "Ticket Notification": {
                List<Ticket> list = baseDataServiceDao.saveOrUpdateTickets(string2, false);
                if (list != null && list.size() > 0) {
                    for (Ticket ticket : list) {
                        ActionHistoryDAO.saveHistory(ticket, "Mqtt ticket save", "Ticket found via mqtt. Id: " + ticket.getId());
                    }
                }
                this.fireTicketReceived();
            }
        }
    }

    private boolean isValidMqttSender(JSONObject jSONObject) {
        String string = jSONObject.getString("source");
        return StringUtils.isNotBlank((String)string) && MqttSender.valueOf(string) == MqttSender.ONLINE_ORDER;
    }

    private boolean isPosLogFileRequest(JSONObject jSONObject) {
        return jSONObject.getString("request").equals("Log File Request");
    }

    private boolean isValidMessage(JSONObject jSONObject) {
        String string;
        String string2;
        String string3 = jSONObject.getString("deviceId");
        if (string3 != null && string3.equals(Application.getInstance().getMqttDeviceId())) {
            return false;
        }
        if (!jSONObject.has("request")) {
            this.debug("Empty request");
            return false;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal == null) {
            return false;
        }
        boolean bl = terminal.isMasterTerminal();
        if (!bl) {
            this.debug("Notification skipped. This is not master terminal.");
        }
        if (StringUtils.isEmpty((String)(string2 = Application.getInstance().getCurrentTerminalOutletId()))) {
            this.debug("Notification skipped. No outlet is defined for this terminal.");
            return false;
        }
        String string4 = string = jSONObject.has("outletId") ? jSONObject.getString("outletId") : null;
        if (StringUtils.isNotEmpty((String)string) && !string.equals(string2)) {
            this.debug("Notification skipped. Outlet not match.");
            return false;
        }
        if (bl) {
            Integer n;
            Integer n2 = n = jSONObject.has("blockTerminalId") ? Integer.valueOf(jSONObject.getInt("blockTerminalId")) : null;
            if (n != null && n > 0 && terminal.getId() == n) {
                return false;
            }
        }
        return bl;
    }

    private void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    public void addDataListener(OroMqttDataListener oroMqttDataListener) {
        this.dataListeners.add(oroMqttDataListener);
    }

    public void removeDataListener(OroMqttDataListener oroMqttDataListener) {
        this.dataListeners.remove(oroMqttDataListener);
    }

    private void fireTicketReceived() {
        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
            oroMqttDataListener.ticketReceived();
        }
    }
}

