/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.SplitTicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ManuallySplitTicketDialog;
import com.floreantpos.ui.views.SplitTypeSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.POSUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;

public class SplitTicketAction
extends PosAction {
    private Ticket a;
    private boolean b = false;
    private RefreshableView c;

    public SplitTicketAction() {
        super(POSConstants.SPLIT_TICKET);
    }

    public SplitTicketAction(boolean bl) {
        super(POSConstants.SPLIT_TICKET);
        this.b = bl;
    }

    public SplitTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, dataChangeListener);
    }

    public SplitTicketAction(DataChangeListener dataChangeListener, boolean bl) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, dataChangeListener);
        this.b = bl;
    }

    public SplitTicketAction(Ticket ticket) {
        super(POSConstants.SPLIT_TICKET);
        this.a = ticket;
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            if (!(!StringUtils.isNotEmpty((String)this.a.getId()) || Hibernate.isInitialized(this.a.getTicketItems()) && Hibernate.isInitialized(this.a.getTransactions()))) {
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            }
            if (this.a == null || this.a.getTicketItems() == null || this.a.getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            if (this.a.hasLoyaltyDiscount()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.10"));
                return;
            }
            object = (Ticket)CopyUtil.deepCopy(this.a);
            if (((BaseTicket)object).getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SplitTicketAction.2"));
                return;
            }
            if (((BaseTicket)object).getGratuity() != null) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SplitTicketAction.4"));
                return;
            }
            if (this.a((Ticket)object) && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.5"), POSConstants.CONFIRM) != 0) {
                return;
            }
            SplitTypeSelectionDialog splitTypeSelectionDialog = new SplitTypeSelectionDialog((Ticket)object);
            splitTypeSelectionDialog.pack();
            splitTypeSelectionDialog.open();
            if (splitTypeSelectionDialog.isCanceled()) {
                return;
            }
            int n = splitTypeSelectionDialog.getSelectedSplitType();
            List<Ticket> list = this.a(n, (Ticket)object);
            if (list == null) {
                return;
            }
            boolean bl = false;
            for (Ticket ticket : list) {
                if (!StringUtils.isNotEmpty((String)ticket.getId())) continue;
                bl = true;
            }
            if (!bl) {
                object = this.a;
            }
            if (this.listener != null) {
                this.listener.dataChanged(object);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private boolean a(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getDiscounts() == null || ticketItem.getDiscounts().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Ticket> a(int n, Ticket ticket) throws Exception {
        if (!this.c(ticket)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.8"));
            return null;
        }
        List<Ticket> list = null;
        if (n == 0) {
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(3);
            numberSelectionDialog2.setTitle(Messages.getString("SplitTicketAction.333"));
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return null;
            }
            int n2 = (int)numberSelectionDialog2.getValue();
            if (n2 > 100) {
                SplitTicketAction.displayMaximumSplitQuantityEceeded();
                return null;
            }
            if (n2 > 0) {
                this.b(ticket);
                list = SplitTicketService.doEquallySplit(ticket, n2);
            }
        } else if (n == 1) {
            try {
                list = SplitTicketService.doSplitBySeatNumber(ticket);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                return null;
            }
        } else {
            this.b(ticket);
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("SplitTicketAction.333"));
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return null;
            }
            int n3 = (int)numberSelectionDialog2.getValue();
            if (n3 > 100) {
                SplitTicketAction.displayMaximumSplitQuantityEceeded();
                return null;
            }
            if (n3 <= 1) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.6"));
                return null;
            }
            ManuallySplitTicketDialog manuallySplitTicketDialog = new ManuallySplitTicketDialog();
            manuallySplitTicketDialog.allowCustomerSelection(this.b);
            manuallySplitTicketDialog.setTicket(ticket, n3);
            manuallySplitTicketDialog.open();
            if (manuallySplitTicketDialog.isCanceled()) {
                if (StringUtils.isNotEmpty((String)ticket.getId())) {
                    ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                }
                return null;
            }
            list = manuallySplitTicketDialog.getSplitTickets();
        }
        if (list == null || list.isEmpty() || list.size() == 1) {
            throw new PosException(Messages.getString("SplitTicketAction.7"));
        }
        this.a(list);
        return list;
    }

    private void b(Ticket ticket) {
        List<TicketItem> list = ticket.getTicketItems();
        if (list != null) {
            Iterator<TicketItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    iterator.remove();
                    ticketItem.setSeat(null);
                    continue;
                }
                ticketItem.setSeat(null);
                ticketItem.setSeatNumber(null);
            }
        }
    }

    public static void displayMaximumSplitQuantityEceeded() {
        POSMessageDialog.showError(POSUtil.getFocusedWindow(), String.format(Messages.getString("SplitTicketAction.1"), 100));
    }

    private void a(List<Ticket> list) {
        SplitedTicketSelectionDialog splitedTicketSelectionDialog = new SplitedTicketSelectionDialog(list);
        splitedTicketSelectionDialog.setDefaultCloseOperation(2);
        splitedTicketSelectionDialog.allowCustomerSelection(this.b);
        splitedTicketSelectionDialog.setSize(PosUIManager.getSize(800, 600));
        splitedTicketSelectionDialog.setRefreshableView(this.c);
        splitedTicketSelectionDialog.setListener(this.listener);
        splitedTicketSelectionDialog.open();
    }

    private boolean c(Ticket ticket) {
        if (ticket.getTicketItems() == null || ticket.getTicketItems().isEmpty()) {
            return Boolean.FALSE;
        }
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setRefreshableView(RefreshableView refreshableView) {
        this.c = refreshableView;
    }
}

