/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.DateChoserDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class AttendanceHistoryExplorer
extends TransparentPanel {
    private SimpleDateFormat a = new SimpleDateFormat("MMM dd, YYYY hh:mm a");
    private JButton b = new JButton(POSConstants.GO);
    private JButton c = new JButton(Messages.getString("AttendanceHistoryExplorer.0"));
    private JButton d = new JButton(Messages.getString("AttendanceHistoryExplorer.1"));
    private JXTable e;
    private JComboBox f;
    private JPanel g;
    private JXDatePicker h;
    private JXDatePicker i;

    public AttendanceHistoryExplorer() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.h = UiUtil.getCurrentMonthStart();
        this.h.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)new JLabel(POSConstants.START_DATE), "grow");
        jPanel.add((Component)this.h);
        this.i = UiUtil.getCurrentMonthEnd();
        jPanel.add((Component)new JLabel(POSConstants.END_DATE), "grow");
        this.i.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)this.i);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.f);
        jPanel.add((Component)this.b, "skip 1, al right");
        this.add((Component)jPanel, "North");
        this.g = new JPanel(new BorderLayout());
        this.add(this.g);
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.c);
        jPanel.add(this.d);
        this.add((Component)jPanel, "South");
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AttendanceHistoryExplorer.this.b();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(AttendanceHistoryExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AttendanceHistoryExplorer.this.e.getSelectedRow();
                if (n < 0) {
                    POSMessageDialog.showError(AttendanceHistoryExplorer.this, Messages.getString("AttendanceHistoryExplorer.4"));
                    return;
                }
                int n2 = AttendanceHistoryExplorer.this.e.convertRowIndexToModel(n);
                AttendenceHistoryTableModel attendenceHistoryTableModel = (AttendenceHistoryTableModel)AttendanceHistoryExplorer.this.e.getModel();
                AttendenceHistory attendenceHistory = (AttendenceHistory)attendenceHistoryTableModel.getRowData(n2);
                DateChoserDialog dateChoserDialog = new DateChoserDialog(attendenceHistory, Messages.getString("AttendanceHistoryExplorer.5"));
                dateChoserDialog.pack();
                dateChoserDialog.open();
                if (dateChoserDialog.isCanceled()) {
                    return;
                }
                if (dateChoserDialog.getAttendenceHistory() != null) {
                    attendenceHistory = dateChoserDialog.getAttendenceHistory();
                }
                AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
                attendenceHistoryDAO.saveOrUpdate(attendenceHistory);
                attendenceHistoryTableModel.updateItem(n);
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChoserDialog dateChoserDialog = new DateChoserDialog(Messages.getString("AttendanceHistoryExplorer.6"));
                dateChoserDialog.pack();
                dateChoserDialog.open();
                if (dateChoserDialog.isCanceled()) {
                    return;
                }
                AttendenceHistory attendenceHistory = null;
                if (dateChoserDialog.getAttendenceHistory() != null) {
                    attendenceHistory = dateChoserDialog.getAttendenceHistory();
                }
                AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
                attendenceHistoryDAO.saveOrUpdate(attendenceHistory);
                AttendenceHistoryTableModel attendenceHistoryTableModel = (AttendenceHistoryTableModel)AttendanceHistoryExplorer.this.e.getModel();
                attendenceHistoryTableModel.addItem(attendenceHistory);
            }
        });
    }

    private void b() {
        try {
            AttendenceHistoryDAO attendenceHistoryDAO;
            List<AttendenceHistory> list;
            this.g.removeAll();
            Date date = DateUtil.startOfDay(this.h.getDate());
            Date date2 = DateUtil.endOfDay(this.i.getDate());
            if (date.after(date2)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
                return;
            }
            User user = null;
            if (!this.f.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.f.getSelectedItem();
            }
            if ((list = (attendenceHistoryDAO = new AttendenceHistoryDAO()).findHistory(date, date2, user)) == null || list.isEmpty()) {
                return;
            }
            this.e = new JXTable();
            AttendenceHistoryTableModel attendenceHistoryTableModel = new AttendenceHistoryTableModel();
            attendenceHistoryTableModel.setRows(list);
            this.e.setModel((TableModel)attendenceHistoryTableModel);
            this.e.setRowHeight(PosUIManager.getSize(30));
            this.e.getSelectionModel().setSelectionMode(0);
            this.e.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
            JScrollPane jScrollPane = new JScrollPane((Component)this.e);
            this.g.add((Component)jScrollPane, "Center");
            this.resizeColumnWidth((JTable)this.e);
            this.g.revalidate();
            this.g.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(5);
        arrayList.add(20);
        arrayList.add(500);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(40);
        arrayList.add(40);
        arrayList.add(40);
        return arrayList;
    }

    class AttendenceHistoryTableModel
    extends ListTableModel {
        String[] a = new String[]{Messages.getString("AttendanceHistoryExplorer.14"), Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("AttendanceHistoryExplorer.11"), Messages.getString("AttendanceHistoryExplorer.12"), Messages.getString("AttendanceHistoryExplorer.13")};

        public AttendenceHistoryTableModel() {
            this.setColumnNames(this.a);
        }

        AttendenceHistoryTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.a);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttendenceHistory attendenceHistory = (AttendenceHistory)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    return attendenceHistory.getUser().getId();
                }
                case 2: {
                    return attendenceHistory.getUser().getFirstName() + " " + attendenceHistory.getUser().getLastName();
                }
                case 3: {
                    Date date = attendenceHistory.getClockInTime();
                    if (date != null) {
                        return AttendanceHistoryExplorer.this.a.format(date);
                    }
                    return "";
                }
                case 4: {
                    Date date = attendenceHistory.getClockOutTime();
                    if (date != null) {
                        return AttendanceHistoryExplorer.this.a.format(date);
                    }
                    return "";
                }
                case 5: {
                    return attendenceHistory.isClockedOut() == false;
                }
                case 6: {
                    if (attendenceHistory.getShift() == null) {
                        return "";
                    }
                    return attendenceHistory.getShift().getId();
                }
                case 7: {
                    return attendenceHistory.getTerminal().getId();
                }
            }
            return null;
        }
    }
}

