/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.AttributeEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class AttributeExplorer
extends TransparentPanel
implements RefreshableView,
ActionListener,
ListSelectionListener {
    private static final long a = 1L;
    private JXTreeTable b;
    private InvGroupTreeTableModel c;
    private List<AttributeGroup> d;

    public AttributeExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new JXTreeTable();
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setRootVisible(false);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.e();
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = AttributeExplorer.this.b.columnAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getClickCount() == 2 && n == 0) {
                    AttributeExplorer.this.b.expandPath(AttributeExplorer.this.b.getPathForRow(AttributeExplorer.this.b.getSelectedRow()));
                } else if (mouseEvent.getClickCount() == 2 && n != 0) {
                    AttributeExplorer.this.d();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.b), "Center");
        this.c();
        this.add((Component)this.a(), "North");
    }

    private JPanel a() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]10[]"));
        JButton jButton = new JButton(Messages.getString("AttributeExplorer.1"));
        jPanel.add(jButton);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("AttributeExplorer.3"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        jButton.addActionListener(actionEvent -> this.e());
        return jPanel;
    }

    private void b() {
        if (this.d != null) {
            AttributeGroup attributeGroup = new AttributeGroup();
            attributeGroup.setId("0");
            attributeGroup.setName("Root");
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)attributeGroup);
            defaultMutableTreeTableNode.setUserObject((Object)attributeGroup);
            for (AttributeGroup attributeGroup2 : this.d) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)attributeGroup2);
                defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
                this.a(defaultMutableTreeTableNode2);
            }
            this.c = new InvGroupTreeTableModel(defaultMutableTreeTableNode);
            this.b.setTreeTableModel((TreeTableModel)this.c);
        }
    }

    private void a(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        AttributeGroup attributeGroup = (AttributeGroup)defaultMutableTreeTableNode.getUserObject();
        if (attributeGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<Attribute> list = attributeGroup.getAttributes();
        for (Attribute attribute : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)attribute);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
    }

    private void c() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = new JButton(Messages.getString("AttributeExplorer.8"));
        JButton jButton2 = new JButton(Messages.getString("AttributeExplorer.9"));
        JButton jButton3 = explorerButtonPanel.getEditButton();
        JButton jButton4 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("AttributeExplorer.10"));
                    if (string == null) {
                        return;
                    }
                    if (string.length() > 30) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.11"));
                        return;
                    }
                    AttributeGroup attributeGroup = new AttributeGroup();
                    GenericDAO.getInstance().checkIdOrNameExists(attributeGroup.getId(), string, AttributeGroup.class);
                    attributeGroup.setName(string);
                    AttributeGroupDAO attributeGroupDAO = new AttributeGroupDAO();
                    attributeGroupDAO.saveOrUpdate(attributeGroup);
                    if (attributeGroup != null) {
                        MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)AttributeExplorer.this.c.getRoot();
                        AttributeExplorer.this.c.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)attributeGroup), mutableTreeTableNode, mutableTreeTableNode.getChildCount());
                    }
                    AttributeExplorer.this.b.expandAll();
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Attribute attribute = new Attribute();
                attribute.setGroup(AttributeExplorer.this.getSelectedAtrributeGroup());
                AttributeEntryForm attributeEntryForm = new AttributeEntryForm(attribute);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog(attributeEntryForm);
                beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 400));
                beanEditorDialog.open();
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
                Attribute attribute2 = (Attribute)attributeEntryForm.getBean();
                AttributeGroup attributeGroup = attribute2.getGroup();
                if (attribute2 != null) {
                    MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)AttributeExplorer.this.c.getRoot();
                    if (attributeGroup != null) {
                        MutableTreeTableNode mutableTreeTableNode2 = AttributeExplorer.this.findTreeNodeForAttribute(mutableTreeTableNode, attributeGroup.getId());
                        if (mutableTreeTableNode2 != null) {
                            AttributeExplorer.this.c.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)attribute2), mutableTreeTableNode2, mutableTreeTableNode2.getChildCount());
                        }
                    } else {
                        MutableTreeTableNode mutableTreeTableNode3 = AttributeExplorer.this.findTreeNodeForAttribute(mutableTreeTableNode, "0");
                        if (mutableTreeTableNode3 != null) {
                            AttributeExplorer.this.c.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)attribute2), mutableTreeTableNode3, mutableTreeTableNode3.getChildCount());
                        }
                    }
                }
                AttributeExplorer.this.b.expandAll();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeExplorer.this.d();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a();
            }

            private void a() {
                try {
                    int n = AttributeExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    TreePath treePath = AttributeExplorer.this.b.getPathForRow(n);
                    DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeTableNode.getUserObject() instanceof AttributeGroup) {
                        AttributeGroup attributeGroup = (AttributeGroup)defaultMutableTreeTableNode.getUserObject();
                        if (POSMessageDialog.showYesNoQuestionDialog(AttributeExplorer.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                            return;
                        }
                        AttributeGroupDAO attributeGroupDAO = AttributeGroupDAO.getInstance();
                        AttributeGroup attributeGroup2 = attributeGroupDAO.get(attributeGroup.getId());
                        attributeGroupDAO.delete(attributeGroup2);
                        MutableTreeTableNode mutableTreeTableNode = AttributeExplorer.this.findTreeNodeForAttribute((MutableTreeTableNode)AttributeExplorer.this.c.getRoot(), attributeGroup.getId());
                        if (mutableTreeTableNode.getParent() != null) {
                            AttributeExplorer.this.c.removeNodeFromParent(mutableTreeTableNode);
                        }
                    } else if (defaultMutableTreeTableNode.getUserObject() instanceof Attribute) {
                        Attribute attribute = (Attribute)defaultMutableTreeTableNode.getUserObject();
                        if (POSMessageDialog.showYesNoQuestionDialog(AttributeExplorer.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                            return;
                        }
                        AttributeDAO attributeDAO = AttributeDAO.getInstance();
                        Attribute attribute2 = attributeDAO.get(attribute.getId());
                        attributeDAO.delete(attribute2);
                        MutableTreeTableNode mutableTreeTableNode = AttributeExplorer.this.findTreeNodeForAttribute((MutableTreeTableNode)AttributeExplorer.this.c.getRoot(), attribute.getId());
                        if (mutableTreeTableNode.getParent() != null) {
                            AttributeExplorer.this.c.removeNodeFromParent(mutableTreeTableNode);
                        }
                    }
                    AttributeExplorer.this.b.repaint();
                    AttributeExplorer.this.b.revalidate();
                }
                catch (PosException posException) {
                    DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
                    detailsInfoDialog.open();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        this.add((Component)transparentPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void d() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof AttributeGroup) {
                try {
                    AttributeGroup attributeGroup = (AttributeGroup)defaultMutableTreeTableNode.getUserObject();
                    String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.15"), attributeGroup.getName());
                    if (string == null) {
                        return;
                    }
                    if (StringUtils.isBlank((String)string)) {
                        POSMessageDialog.showError(Messages.getString("AttributeExplorer.0"));
                        return;
                    }
                    if ((string = string.trim()).length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.16"));
                        return;
                    }
                    GenericDAO.getInstance().checkIdOrNameExists(attributeGroup.getId(), string, AttributeGroup.class);
                    attributeGroup.setName(string);
                    AttributeGroupDAO.getInstance().saveOrUpdate(attributeGroup);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof Attribute) {
                Attribute attribute = (Attribute)defaultMutableTreeTableNode.getUserObject();
                AttributeEntryForm attributeEntryForm = new AttributeEntryForm(attribute);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog(attributeEntryForm);
                beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 400));
                beanEditorDialog.open();
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            }
            this.e();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        this.d = AttributeGroupDAO.getInstance().findAll();
        this.b();
        this.b.expandAll();
    }

    public Attribute getSelectedAtrribute() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof AttributeGroup) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.17"));
                return null;
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof Attribute) {
                return (Attribute)defaultMutableTreeTableNode.getUserObject();
            }
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return null;
    }

    public AttributeGroup getSelectedAtrributeGroup() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof AttributeGroup) {
                return (AttributeGroup)defaultMutableTreeTableNode.getUserObject();
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof Attribute) {
                return ((Attribute)defaultMutableTreeTableNode.getUserObject()).getGroup();
            }
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return null;
    }

    public MutableTreeTableNode findTreeNodeForAttribute(MutableTreeTableNode mutableTreeTableNode, String string) {
        block5: {
            block4: {
                if (!(((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof AttributeGroup)) break block4;
                AttributeGroup attributeGroup = (AttributeGroup)mutableTreeTableNode.getUserObject();
                if (string.equals(attributeGroup.getId())) {
                    return mutableTreeTableNode;
                }
                Enumeration enumeration = mutableTreeTableNode.children();
                while (enumeration.hasMoreElements()) {
                    MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)enumeration.nextElement();
                    MutableTreeTableNode mutableTreeTableNode3 = this.findTreeNodeForAttribute(mutableTreeTableNode2, string);
                    if (mutableTreeTableNode3 == null) continue;
                    return mutableTreeTableNode3;
                }
                break block5;
            }
            if (!(((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof Attribute)) break block5;
            Attribute attribute = (Attribute)mutableTreeTableNode.getUserObject();
            if (string.equals(attribute.getId())) {
                return mutableTreeTableNode;
            }
            Enumeration enumeration = mutableTreeTableNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeTableNode mutableTreeTableNode4 = (MutableTreeTableNode)enumeration.nextElement();
                MutableTreeTableNode mutableTreeTableNode5 = this.findTreeNodeForAttribute(mutableTreeTableNode4, string);
                if (mutableTreeTableNode5 == null) continue;
                return mutableTreeTableNode5;
            }
        }
        return null;
    }

    @Override
    public void refresh() {
        this.e();
    }

    class InvGroupTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] b;

        public InvGroupTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
            super((TreeTableNode)defaultMutableTreeTableNode);
            this.b = new String[]{Messages.getString("AttributeExplorer.2"), Messages.getString("NAME"), Messages.getString("AttributeExplorer.4"), Messages.getString("AttributeExplorer.5")};
        }

        public void setRoot(TreeTableNode treeTableNode) {
            super.setRoot(treeTableNode);
        }

        public int getColumnCount() {
            return this.b.length;
        }

        public String getColumnName(int n) {
            return this.b[n];
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof AttributeGroup) {
                    AttributeGroup attributeGroup = (AttributeGroup)((DefaultMutableTreeTableNode)object).getUserObject();
                    if (attributeGroup == null) {
                        return "";
                    }
                    switch (n) {
                        case 0: {
                            return attributeGroup.getName();
                        }
                    }
                } else if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof Attribute) {
                    Attribute attribute = (Attribute)((DefaultMutableTreeTableNode)object).getUserObject();
                    if (attribute == null) {
                        return "";
                    }
                    switch (n) {
                        case 1: {
                            return attribute.getName();
                        }
                        case 2: {
                            return attribute.getSortOrder();
                        }
                        case 3: {
                            return attribute.isDefaultAttribute();
                        }
                    }
                }
            }
            return null;
        }
    }
}

