/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class CookingInstructionExplorer
extends TransparentPanel {
    private List<CookingInstruction> b;
    private JTable c;
    private CookingInstructionTableModel d;
    CookingInstructionDAO a = new CookingInstructionDAO();

    public CookingInstructionExplorer() {
        this.b = this.a.findAll();
        this.d = new CookingInstructionTableModel();
        this.c = new JTable(this.d);
        this.c.setRowHeight(PosUIManager.getSize(30));
        this.c.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.c));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(actionEvent -> this.a());
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(actionEvent -> this.b());
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(actionEvent -> this.c());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        try {
            String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), (Object)POSConstants.ENTER_INSTRUCTION_DESCRIPTION);
            if (string == null) {
                return;
            }
            if ((string = string.trim()).isEmpty()) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
                return;
            }
            if (string.length() > 60) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
                return;
            }
            CookingInstruction cookingInstruction = new CookingInstruction();
            cookingInstruction.setDescription(string);
            this.a.save(cookingInstruction);
            this.d.add(cookingInstruction);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        try {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            CookingInstruction cookingInstruction = this.b.get(n);
            String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), POSConstants.ENTER_INSTRUCTION_DESCRIPTION, cookingInstruction.getDescription());
            if (string == null) {
                return;
            }
            if ((string = string.trim()).isEmpty()) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
                return;
            }
            if (string.length() > 60) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
                return;
            }
            cookingInstruction.setDescription(string);
            this.a.saveOrUpdate(cookingInstruction);
            this.c.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void c() {
        try {
            int n = this.c.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                CookingInstruction cookingInstruction = this.b.get(n);
                this.a.delete(cookingInstruction);
                this.d.delete(cookingInstruction, n);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    class CookingInstructionTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.DESCRIPTION};

        CookingInstructionTableModel() {
        }

        @Override
        public int getRowCount() {
            if (CookingInstructionExplorer.this.b == null) {
                return 0;
            }
            return CookingInstructionExplorer.this.b.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (CookingInstructionExplorer.this.b == null) {
                return "";
            }
            CookingInstruction cookingInstruction = (CookingInstruction)CookingInstructionExplorer.this.b.get(n);
            switch (n2) {
                case 0: {
                    return cookingInstruction.getDescription();
                }
            }
            return null;
        }

        public void add(CookingInstruction cookingInstruction) {
            int n = CookingInstructionExplorer.this.b.size();
            CookingInstructionExplorer.this.b.add(cookingInstruction);
            this.fireTableRowsInserted(n, n);
        }

        public void delete(CookingInstruction cookingInstruction, int n) {
            CookingInstructionExplorer.this.b.remove(cookingInstruction);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

