/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.model.CouponForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class CouponExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a = new JTable();
    private CouponExplorerTableModel b;

    public CouponExplorer() {
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.a));
        JButton jButton = new JButton(POSConstants.NEW);
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    public void initData() throws Exception {
        DiscountDAO discountDAO = new DiscountDAO();
        List<Discount> list = discountDAO.findAll();
        this.b = new CouponExplorerTableModel(list);
        this.a.setModel(this.b);
    }

    private void a() {
        try {
            CouponForm couponForm = new CouponForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)couponForm);
            beanEditorDialog.openWithScale(900, 500);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            Discount discount = (Discount)couponForm.getBean();
            this.b.addCoupon(discount);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Discount discount) {
        try {
            CouponForm couponForm = new CouponForm(discount);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)couponForm);
            beanEditorDialog.openWithScale(900, 500);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, Discount discount) {
        try {
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                DiscountDAO.getInstance().delete(discount);
                this.b.deleteCoupon(discount, n);
            }
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.a();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_COUPON_TO_EDIT);
                return;
            }
            Discount discount = this.b.getCoupon(n);
            DiscountDAO.getInstance().refresh(discount);
            this.a(discount);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_COUPON_TO_DELETE);
                return;
            }
            Discount discount = this.b.getCoupon(n);
            DiscountDAO.getInstance().refresh(discount);
            this.a(n, discount);
        }
    }

    private class CouponExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, POSConstants.COUPON_TYPE, Messages.getString("CouponExplorer.0"), Messages.getString("CouponExplorer.1"), Messages.getString("CouponExplorer.2"), POSConstants.COUPON_VALUE, POSConstants.EXPIRY_DATE, POSConstants.ENABLED, POSConstants.NEVER_EXPIRE};
        List<Discount> b;

        CouponExplorerTableModel(List<Discount> list) {
            this.b = list;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            Discount discount = this.b.get(n);
            switch (n2) {
                case 0: {
                    return discount.getName();
                }
                case 1: {
                    return Discount.COUPON_TYPE_NAMES[discount.getType()];
                }
                case 2: {
                    return Discount.COUPON_QUALIFICATION_NAMES[discount.getQualificationType()];
                }
                case 3: {
                    return discount.getMinimumBuy();
                }
                case 4: {
                    return discount.getMaximumOff();
                }
                case 5: {
                    return (double)discount.getValue();
                }
                case 6: {
                    return discount.getExpiryDate();
                }
                case 7: {
                    return (boolean)discount.isEnabled();
                }
                case 8: {
                    return (boolean)discount.isNeverExpire();
                }
            }
            return null;
        }

        public void addCoupon(Discount discount) {
            int n = this.b.size();
            this.b.add(discount);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteCoupon(Discount discount, int n) {
            this.b.remove(discount);
            this.fireTableRowsDeleted(n, n);
        }

        public Discount getCoupon(int n) {
            return this.b.get(n);
        }
    }
}

