/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.Course;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CourseForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jdesktop.swingx.JXTable;

public class CourseExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable a;
    private BeanTableModel<Course> b = new BeanTableModel(Course.class);

    public CourseExplorer() {
        this.b.addColumn(POSConstants.NAME, Course.PROP_NAME);
        this.b.addColumn(Messages.getString("CourseExplorer.0"), Course.PROP_SHORT_NAME);
        this.b.addColumn(POSConstants.SORT_ORDER, Course.PROP_SORT_ORDER, 2, BeanTableModel.DataType.NUMBER);
        this.a = new JXTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    CourseExplorer.this.editSelectedRow();
                }
            }
        });
        this.b.initTableRenderer((JTable)this.a);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.a();
        this.initData();
    }

    private void a() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(actionEvent -> this.b());
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(actionEvent -> this.editSelectedRow());
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(actionEvent -> this.c());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    public void editSelectedRow() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            Course course = this.b.getRow(n);
            CourseForm courseForm = new CourseForm(course);
            courseForm.setExistingCourses(this.b.getRows());
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)courseForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 450));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void initData() {
        this.b.setRows(CourseDAO.getInstance().findAll());
    }

    private void b() {
        try {
            CourseForm courseForm = new CourseForm();
            courseForm.setExistingCourses(this.b.getRows());
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)courseForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 450));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            Course course = (Course)courseForm.getBean();
            this.b.addRow(course);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            Course course = this.b.getRow(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            CourseDAO.getInstance().delete(course);
            this.b.removeRow(n);
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

