/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSizeForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class MenuItemSizeExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<MenuItemSize> b = new BeanTableModel(MenuItemSize.class);

    public MenuItemSizeExplorer() {
        this.b.addColumn(POSConstants.NAME, "name");
        this.b.addColumn(Messages.getString("MenuItemSizeExplorer.0"), "translatedName");
        this.b.addColumn(Messages.getString("MenuItemSizeExplorer.2"), "description");
        this.b.addColumn(Messages.getString("MenuItemSizeExplorer.4"), "sizeInInch");
        this.b.addColumn(Messages.getString("MenuItemSizeExplorer.6"), "sortOrder");
        this.b.addColumn("Default", MenuItemSize.PROP_DEFAULT_SIZE);
        this.b.addRows(MenuItemSizeDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuItemSizeForm menuItemSizeForm = new MenuItemSizeForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemSizeForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuItemSize menuItemSize = (MenuItemSize)menuItemSizeForm.getBean();
                    MenuItemSizeExplorer.this.b.addRow(menuItemSize);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MenuItemSizeExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    n = MenuItemSizeExplorer.this.a.convertRowIndexToModel(n);
                    MenuItemSize menuItemSize = (MenuItemSize)MenuItemSizeExplorer.this.b.getRow(n);
                    MenuItemSizeForm menuItemSizeForm = new MenuItemSizeForm(menuItemSize);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemSizeForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuItemSizeExplorer.this.a.repaint();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MenuItemSizeExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        MenuItemSize menuItemSize = (MenuItemSize)MenuItemSizeExplorer.this.b.getRow(n);
                        MenuItemSizeDAO menuItemSizeDAO = new MenuItemSizeDAO();
                        menuItemSizeDAO.delete(menuItemSize);
                        MenuItemSizeExplorer.this.b.removeRow(n);
                    }
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton4 = new JButton(Messages.getString("MenuItemSizeExplorer.5"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MenuItemSizeExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SetDefault"));
                        return;
                    }
                    n = MenuItemSizeExplorer.this.a.convertRowIndexToModel(n);
                    MenuItemSize menuItemSize = (MenuItemSize)MenuItemSizeExplorer.this.b.getRow(n);
                    ArrayList<MenuItemSize> arrayList = new ArrayList<MenuItemSize>();
                    arrayList.add(menuItemSize);
                    for (MenuItemSize menuItemSize2 : MenuItemSizeExplorer.this.b.getRows()) {
                        if (!menuItemSize2.isDefaultSize().booleanValue()) continue;
                        menuItemSize2.setDefaultSize(false);
                        arrayList.add(menuItemSize2);
                    }
                    menuItemSize.setDefaultSize(true);
                    MenuItemSizeDAO menuItemSizeDAO = new MenuItemSizeDAO();
                    menuItemSizeDAO.saveOrUpdateList(arrayList);
                    MenuItemSizeExplorer.this.b.fireTableDataChanged();
                    MenuItemSizeExplorer.this.a.revalidate();
                    MenuItemSizeExplorer.this.a.repaint();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        this.add((Component)transparentPanel, "South");
    }
}

