/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MultiplierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;

public class MultiplierExplorer
extends TransparentPanel {
    private List<Multiplier> a = MultiplierDAO.getInstance().findAll();
    private JTable b;
    private MultiplierExplorerTableModel c = new MultiplierExplorerTableModel();
    private JButton d;
    private JButton e;

    public MultiplierExplorer() {
        this.b = new JTable(this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.b.getColumnModel().getColumn(6).setCellRenderer(new PosTableRenderer());
        this.b.setSelectionMode(0);
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = MultiplierExplorer.this.b.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                MultiplierExplorer.this.d.setEnabled(multiplier.isMain() == false);
                MultiplierExplorer.this.e.setEnabled(multiplier.isMain() == false);
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.b));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultiplierForm multiplierForm = new MultiplierForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)multiplierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.c.addMultiplier((Multiplier)multiplierForm.getBean());
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d = new JButton(POSConstants.EDIT);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    MultiplierForm multiplierForm = new MultiplierForm(multiplier);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)multiplierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MultiplierExplorer.this.b.repaint();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        this.e = new JButton(POSConstants.DELETE);
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    if (multiplier.isMain().booleanValue()) {
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(MultiplierExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        MultiplierDAO.getInstance().delete(multiplier);
                        MultiplierExplorer.this.c.deleteMultiplier(multiplier, n);
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(Messages.getString("MultiplierExplorer.2"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MultiplierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MultiplierExplorer.3"));
                        return;
                    }
                    Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
                    for (Multiplier multiplier2 : MultiplierExplorer.this.a) {
                        if (multiplier.getId().equals(multiplier2.getId())) {
                            multiplier2.setDefaultMultiplier(true);
                            continue;
                        }
                        multiplier2.setDefaultMultiplier(false);
                    }
                    MultiplierDAO.getInstance().saveOrUpdateMultipliers(MultiplierExplorer.this.a);
                    MultiplierExplorer.this.c.fireTableDataChanged();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton3 = new JButton(Messages.getString("MultiplierExplorer.0"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiplierExplorer.this.a();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(this.d);
        transparentPanel.add(this.e);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        MultiplierExplorerConfigurationDialog multiplierExplorerConfigurationDialog = new MultiplierExplorerConfigurationDialog(Messages.getString("MultiplierExplorer.1"));
        multiplierExplorerConfigurationDialog.pack();
        multiplierExplorerConfigurationDialog.open();
    }

    class MultiplierExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, Messages.getString("MultiplierExplorer.4"), POSConstants.RATE, POSConstants.SORT_ORDER, POSConstants.BUTTON_COLOR, POSConstants.TEXT_COLOR, Messages.getString("MultiplierExplorer.5")};

        MultiplierExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (MultiplierExplorer.this.a == null) {
                return 0;
            }
            return MultiplierExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (MultiplierExplorer.this.a == null) {
                return "";
            }
            Multiplier multiplier = (Multiplier)MultiplierExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return multiplier.getId();
                }
                case 1: {
                    return multiplier.getTicketPrefix();
                }
                case 2: {
                    return multiplier.getRate();
                }
                case 3: {
                    return multiplier.getSortOrder();
                }
                case 4: {
                    if (multiplier.getButtonColor() != null) {
                        return new Color(multiplier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    if (multiplier.getTextColor() != null) {
                        return new Color(multiplier.getTextColor());
                    }
                    return null;
                }
                case 6: {
                    return multiplier.isDefaultMultiplier();
                }
            }
            return null;
        }

        public void addMultiplier(Multiplier multiplier) {
            int n = MultiplierExplorer.this.a.size();
            MultiplierExplorer.this.a.add(multiplier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteMultiplier(Multiplier multiplier, int n) {
            MultiplierExplorer.this.a.remove(multiplier);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private class MultiplierExplorerConfigurationDialog
    extends OkCancelOptionDialog {
        private static final String b = " ";
        private JComboBox<Multiplier> c;
        private JComboBox<Multiplier> d;
        private JComboBox<Multiplier> e;
        private Store f;
        private Multiplier g;
        private Multiplier h;
        private Multiplier i;

        public MultiplierExplorerConfigurationDialog(String string) {
            super(POSUtil.getFocusedWindow(), string);
            this.f = DataProvider.get().getStore();
            this.a();
        }

        private void a() {
            this.setDefaultCloseOperation(2);
            this.setResizable(Boolean.FALSE);
            JPanel jPanel = new JPanel();
            MigLayout migLayout = new MigLayout("fill,inset 0", "sg, fill", "");
            jPanel.setLayout((LayoutManager)migLayout);
            JLabel jLabel = new JLabel(Messages.getString("MultiplierExplorer.8"));
            JLabel jLabel2 = new JLabel(Messages.getString("MultiplierExplorer.9"));
            JLabel jLabel3 = new JLabel(Messages.getString("MultiplierExplorer.10"));
            this.g = this.f.getExtraMultiplier();
            this.h = this.f.getHalfMultiplier();
            this.i = this.f.getQuarterMultiplier();
            ComboBoxModel comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.a) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.c = new JComboBox(comboBoxModel);
            this.c.setSelectedItem(this.g);
            comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.a) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.d = new JComboBox(comboBoxModel);
            this.d.setSelectedItem(this.h);
            comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            for (Multiplier multiplier : MultiplierExplorer.this.a) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.e = new JComboBox(comboBoxModel);
            this.e.setSelectedItem(this.i);
            jPanel.add((Component)jLabel, "grow");
            jPanel.add(this.c, "grow, wrap");
            jPanel.add((Component)jLabel2, "grow");
            jPanel.add(this.d, "grow, wrap");
            jPanel.add((Component)jLabel3, "grow");
            jPanel.add(this.e, "grow, wrap");
            this.c.addItemListener(itemEvent -> this.b());
            this.d.addItemListener(itemEvent -> this.c());
            this.e.addItemListener(itemEvent -> this.d());
            this.getContentPanel().add((Component)jPanel, "Center");
        }

        private void b() {
            try {
                Multiplier multiplier;
                this.g = multiplier = (Multiplier)this.c.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void c() {
            try {
                Multiplier multiplier;
                this.h = multiplier = (Multiplier)this.d.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void d() {
            try {
                Multiplier multiplier;
                this.i = multiplier = (Multiplier)this.e.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        @Override
        public void doOk() {
            try {
                if (this.g != null && this.g.equals(this.h)) {
                    String string = Messages.getString("MultiplierExplorer.11") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                if (this.g != null && this.g.equals(this.i)) {
                    String string = Messages.getString("MultiplierExplorer.13") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                if (this.h != null && this.h.equals(this.i)) {
                    String string = Messages.getString("MultiplierExplorer.15") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                StoreDAO.getInstance().saveOrUpdate(this.f.setExtraMultiplier(this.g).setHalfMultiplier(this.h).setQuarterMultiplier(this.i));
                this.setCanceled(false);
                this.dispose();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }
}

