/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;

public class SalesAreaExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<SalesArea> b = new BeanTableModel(SalesArea.class);
    private JButton c;
    private JButton d;
    private JButton e;

    public SalesAreaExplorer() {
        this.b.addColumn("NAME", "name");
        this.b.addColumn(Messages.getString("SalesAreaExplorer.1"), "department");
        List<SalesArea> list = SalesAreaDAO.getInstance().findAll();
        this.b.addRows(list);
        this.a = new JXTable(this.b);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)this.c(), "South");
        this.add((Component)this.a(), "North");
        this.resizeColumnWidth((JTable)this.a);
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SalesAreaExplorer.this.a.getSelectedRow() < 0) {
                    // empty if block
                }
            }
        });
    }

    private JPanel a() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    private void b() {
    }

    private TransparentPanel c() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        this.d = explorerButtonPanel.getAddButton();
        this.e = explorerButtonPanel.getEditButton();
        this.c = explorerButtonPanel.getDeleteButton();
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SalesAreaExplorer.this.e();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SalesArea salesArea = new SalesArea();
                    SalesAreaEntryForm salesAreaEntryForm = new SalesAreaEntryForm(salesArea);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)salesAreaEntryForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    SalesArea salesArea2 = (SalesArea)salesAreaEntryForm.getBean();
                    SalesAreaExplorer.this.b.addRow(salesArea2);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = SalesAreaExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = SalesAreaExplorer.this.a.convertRowIndexToModel(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    SalesArea salesArea = (SalesArea)SalesAreaExplorer.this.b.getRow(n);
                    SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
                    salesAreaDAO.delete(salesArea);
                    SalesAreaExplorer.this.b.removeRow(n);
                }
                catch (PosException posException) {
                    DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
                    detailsInfoDialog.open();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.d);
        transparentPanel.add(this.e);
        transparentPanel.add(this.c);
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(150);
        arrayList.add(100);
        arrayList.add(70);
        arrayList.add(230);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(85);
        arrayList.add(90);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(70);
        arrayList.add(50);
        return arrayList;
    }

    private void e() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            SalesArea salesArea = this.b.getRow(n);
            salesArea = SalesAreaDAO.getInstance().find(salesArea);
            this.b.setRow(n, salesArea);
            SalesAreaEntryForm salesAreaEntryForm = new SalesAreaEntryForm(salesArea);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)salesAreaEntryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }
}

