/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.menudesigner.PageItemActionSelectorDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class MenuPageDesignView
extends TransparentPanel
implements RefreshableView {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int a = 5;
    private static final int b = 5;
    private Dimension c;
    private MenuPage d;
    private JPanel e = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private Integer f = 0;
    private Integer g = 0;
    private MenuPageItem h = null;
    private JPanel i = new JPanel((LayoutManager)new MigLayout("ins 5 5"));
    private JComboBox j = new JComboBox();
    private JButton k;
    private JButton l;
    private JButton m;

    public MenuPageDesignView() {
        this.a();
    }

    private void a() {
        this.c = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        this.setLayout(new BorderLayout(5, 5));
        this.e.setBackground(Color.GRAY);
        this.e.setOpaque(true);
        this.i.add(new JLabel(POSConstants.ORDER_TYPE));
        this.b();
        this.j.addItemListener(itemEvent -> this.a(itemEvent));
        this.i.add((Component)this.j, "w 150!");
        this.k = new JButton(Messages.getString("MenuPageDesigner.26"));
        this.k.setEnabled(false);
        this.k.addActionListener(actionEvent -> this.save());
        this.l = new JButton(Messages.getString("Cancel"));
        this.l.setEnabled(false);
        this.l.addActionListener(actionEvent -> this.c());
        this.i.add((Component)new JSeparator(1), "gapright 10,grow");
        this.m = new JButton(Messages.getString("MenuPageDesigner.28"));
        this.m.addActionListener(actionEvent -> this.doDetachAllItems());
        this.i.add((Component)this.m, "flowx,cell 3 0,alignx right");
        this.i.add((Component)this.k, "alignx right");
        this.i.add((Component)this.l, "align right");
        this.add((Component)this.i, "North");
        this.add(this.e);
    }

    private void a(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (this.d == null) {
            return;
        }
        this.setEnabledSaveAndCancel(true);
    }

    private void b() {
        this.j.addItem(POSConstants.ALL);
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        if (list != null && list.size() > 0) {
            for (OrderType orderType : list) {
                this.j.addItem(orderType);
            }
        }
        this.j.setSelectedIndex(0);
    }

    public MenuPage getMenuPage() {
        return this.d;
    }

    public void setMenuPage(MenuPage menuPage) {
        try {
            if (menuPage == null) {
                this.d = null;
                this.reset();
                return;
            }
            this.d = MenuPageDAO.getInstance().getInitialized(menuPage.getId());
            this.f = this.d.getCols();
            if (this.f <= 0) {
                this.f = 4;
            }
            this.g = this.d.getRows();
            if (this.g <= 0) {
                this.g = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.f);
            if (this.d.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.e.setLayout((LayoutManager)migLayout);
            this.rendererSelectedOrderType();
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    protected void renderItems() {
        try {
            Serializable serializable;
            String string;
            this.reset();
            if (this.d == null) {
                return;
            }
            List<MenuPageItem> list = this.d();
            HashMap<String, ItemButton> hashMap = new HashMap<String, ItemButton>();
            for (int i = 0; i < this.g; ++i) {
                for (int j = 0; j < this.f; ++j) {
                    string = String.valueOf(j) + String.valueOf(i);
                    serializable = this.a(j, i, list);
                    ItemButton itemButton = (ItemButton)this.createItemButton(serializable);
                    hashMap.put(string, itemButton);
                    String string2 = String.format("cell %s %s", j, i);
                    if (!this.d.isFlixibleButtonSize().booleanValue()) {
                        string2 = string2 + String.format(", w %s!, h %s!", this.d.getButtonWidth(), this.d.getButtonHeight());
                    }
                    this.e.add((Component)itemButton, string2);
                }
            }
            for (MenuPageItem menuPageItem : list) {
                string = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
                serializable = (ItemButton)hashMap.get(string);
                if (serializable == null) continue;
                ((ItemButton)serializable).setMenuItem(menuPageItem.getMenuItem());
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void reset() {
        this.e.removeAll();
        this.e.revalidate();
        this.e.repaint();
    }

    public void fillSelectedPageItems(List<MenuPageItem> list) {
        int n = 0;
        for (int i = 0; i < this.e.getComponents().length; ++i) {
            ItemButton itemButton = (ItemButton)this.e.getComponent(i);
            if (itemButton.isEmptyItem()) {
                MenuPageItem menuPageItem = list.get(n);
                itemButton.setMenuItem(menuPageItem.getMenuItem());
                ++n;
            }
            if (n == list.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object object) {
        MenuPageItem menuPageItem = (MenuPageItem)object;
        ItemButton itemButton = new ItemButton(menuPageItem);
        return itemButton;
    }

    public void resetPage() {
        for (int i = 0; i < this.e.getComponents().length; ++i) {
            MenuPageItem menuPageItem;
            ItemButton itemButton = (ItemButton)this.e.getComponent(i);
            if (itemButton.isEmptyItem() || (menuPageItem = itemButton.a).getId() != null) continue;
            itemButton.setMenuItem(null);
        }
        this.revalidate();
        this.repaint();
        this.setEnabledSaveAndCancel(false);
    }

    private MenuPageItem a(int n, int n2, List<MenuPageItem> list) {
        for (MenuPageItem menuPageItem : list) {
            if (menuPageItem.getCol() != n || menuPageItem.getRow() != n2) continue;
            return menuPageItem;
        }
        MenuPageItem menuPageItem = new MenuPageItem(n, n2);
        menuPageItem.setMenuPage(this.d);
        return menuPageItem;
    }

    public void save() {
        try {
            if (this.d == null) {
                return;
            }
            this.a(this.d);
            this.d.setOrderTypeId(this.getSelectedOrderTypeId());
            MenuPageDAO.getInstance().saveOrUpdate(this.d);
            this.setEnabledSaveAndCancel(false);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    public String getSelectedOrderTypeId() {
        Object object = this.j.getSelectedItem();
        OrderType orderType = null;
        if (object instanceof OrderType) {
            orderType = (OrderType)object;
            return orderType.getId();
        }
        return null;
    }

    public void rendererSelectedOrderType() {
        if (this.d == null) {
            this.j.setSelectedItem(POSConstants.ALL);
            return;
        }
        String string = this.d.getOrderTypeId();
        if (StringUtils.isEmpty((String)string)) {
            this.j.setSelectedItem(POSConstants.ALL);
        } else {
            this.j.setSelectedItem(DataProvider.get().getOrderType(string));
        }
    }

    private void c() {
        try {
            if (this.d == null) {
                return;
            }
            List<MenuPageItem> list = this.d.getPageItems();
            if (list != null) {
                Iterator<MenuPageItem> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MenuPageItem menuPageItem = iterator.next();
                    if (menuPageItem.getId() != null) continue;
                    iterator.remove();
                }
            }
            this.refresh();
            this.setEnabledSaveAndCancel(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void setEnabledSaveAndCancel(boolean bl) {
        this.k.setEnabled(bl);
        this.l.setEnabled(bl);
    }

    public boolean isEnabledSaveButton() {
        return this.k.isEnabled();
    }

    public JButton getDetachAllButton() {
        return this.m;
    }

    @Override
    public void refresh() {
        if (this.d != null) {
            this.setMenuPage(this.d);
        }
    }

    private void a(MenuPage menuPage) {
        List<MenuPageItem> list = menuPage.getPageItems();
        if (list != null) {
            Iterator<MenuPageItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                MenuPageItem menuPageItem = iterator.next();
                if (menuPageItem.getMenuItemId() != null) continue;
                iterator.remove();
            }
        }
    }

    private List<MenuPageItem> d() {
        if (this.d == null) {
            return new ArrayList<MenuPageItem>(0);
        }
        List<MenuPageItem> list = this.d.getPageItems();
        if (list == null) {
            list = new ArrayList<MenuPageItem>();
        }
        return list;
    }

    public void doDetachAllItems() {
        if (this.d == null || this.d.getPageItems() == null || this.d.getPageItems().size() < 1) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.53"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.54"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        if (this.d.getPageItems() != null) {
            this.d.getPageItems().clear();
        }
        MenuPageDAO.getInstance().saveOrUpdate(this.d);
        this.setMenuPage(this.d);
    }

    public class ItemButton
    extends PosButton
    implements Transferable,
    MouseListener,
    MouseMotionListener {
        MenuPageItem a;
        private DataFlavor e = new DataFlavor(MenuPageItem.class, "menuPageItem");
        private final DataFlavor[] f = new DataFlavor[]{this.e};
        private DragAndDropTransferHandler g;

        ItemButton(MenuPageItem menuPageItem) {
            this.a = menuPageItem;
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText(Messages.getString("MenuPageDesignView.10"));
            this.setPreferredSize(MenuPageDesignView.this.c);
            this.updateView();
            this.g = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.g);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int a() {
            return this.a.getRow();
        }

        int b() {
            return this.a.getCol();
        }

        public void setMenuPageItem(MenuPageItem menuPageItem) {
            this.a = menuPageItem;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.a.setMenuItem(menuItem);
            this.a.setMenuPage(MenuPageDesignView.this.d);
            this.updateView();
        }

        public boolean isEmptyItem() {
            return this.a.getMenuItem() == null;
        }

        public void updateView() {
            MenuItem menuItem = this.a.getMenuItem();
            if (menuItem == null) {
                this.setIcon(null);
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                this.setText("<html><body><center>+</center></body></html>");
                return;
            }
            ImageIcon imageIcon = menuItem.getImage();
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setIcon(null);
                this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
            }
            Color color = menuItem.getButtonColor();
            if (color != null) {
                this.setBackground(color);
            } else {
                this.setBackground(Color.WHITE);
            }
            Color color2 = menuItem.getTextColor();
            if (color2 != null) {
                this.setForeground(color2);
            } else {
                this.setForeground(Color.black);
            }
        }

        private void c() {
            try {
                Object object;
                Object object2;
                MenuItem menuItem = this.a.getMenuItem();
                if (menuItem == null) {
                    menuItem = this.d();
                    if (menuItem == null) {
                        return;
                    }
                } else {
                    object2 = new PageItemActionSelectorDialog(this.a);
                    ((Window)object2).setSize(PosUIManager.getSize(500, 350));
                    ((POSDialog)object2).open();
                    if (((POSDialog)object2).isCanceled()) {
                        return;
                    }
                    object = ((PageItemActionSelectorDialog)object2).getActionCommand();
                    if (((String)object).equals("REPLACE")) {
                        menuItem = this.d();
                        if (menuItem == null) {
                            return;
                        }
                    } else if (((String)object).equals("EDIT")) {
                        this.a(menuItem);
                    } else if (((String)object).equals("DETACH")) {
                        menuItem = null;
                    }
                }
                this.a.setMenuItem(menuItem);
                this.a.setMenuPage(MenuPageDesignView.this.d);
                object2 = MenuPageDesignView.this.d.getPageItems();
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        MenuPageItem menuPageItem = (MenuPageItem)object.next();
                        if (!this.a.isRowColumnEquals(menuPageItem)) continue;
                        object.remove();
                    }
                }
                MenuPageDesignView.this.d.addTopageItems(this.a);
                this.a.setMenuPage(MenuPageDesignView.this.d);
                MenuPageDesignView.this.setEnabledSaveAndCancel(true);
                MenuPageDesignView.this.renderItems();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesignView.17"), exception);
            }
        }

        private MenuItem d() {
            MenuItemSelectionDialog menuItemSelectionDialog = MenuItemSelectionDialog.getInstance();
            menuItemSelectionDialog.setSelectionMode(0);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(800, 600));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return null;
            }
            MenuItem menuItem = menuItemSelectionDialog.getSelectedRowData();
            if (menuItem == null) {
                return null;
            }
            MenuItemDAO.getInstance().refresh(menuItem);
            List<MenuPageItem> list = MenuPageDesignView.this.d.getPageItems();
            if (list != null) {
                for (MenuPageItem menuPageItem : list) {
                    if (!menuItem.getId().equals(menuPageItem.getMenuItemId())) continue;
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ItemAlreadyExists"));
                    return null;
                }
            }
            return menuItem;
        }

        public void doReplaceMenuPageItem(MenuItem menuItem) {
            try {
                menuItem = this.d();
                if (menuItem == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        private void a(MenuItem menuItem) {
            try {
                MenuPageItem menuPageItem;
                MenuItemDAO.getInstance().initialize(menuItem);
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
                this.a.setMenuItem(menuItem);
                if (this.a.getId() != null && (menuPageItem = MenuPageItemDAO.getInstance().get(this.a.getId())) != null) {
                    this.a.setVersion(menuPageItem.getVersion());
                }
                this.updateView();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, exception.getMessage(), exception);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                ItemButton itemButton = (ItemButton)mouseEvent.getSource();
                TransferHandler transferHandler = itemButton.getTransferHandler();
                transferHandler.exportAsDrag(itemButton, mouseEvent, 2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.c();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.f.length; ++i) {
                if (!dataFlavor.equals(this.f[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.e)) {
                return this.a;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ItemButton b = null;

        public DragAndDropTransferHandler(ItemButton itemButton) {
            this.b = itemButton;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return this.b;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(this.b.e);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
            try {
                if (jComponent instanceof ItemButton && MenuPageDesignView.this.h != null) {
                    this.b.setMenuPageItem(MenuPageDesignView.this.h);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> list = menuPage.getPageItems();
                    if (list != null) {
                        for (MenuPageItem menuPageItem : list) {
                            if (menuPageItem == null || !menuPageItem.getRandomId().equals(MenuPageDesignView.this.h.getRandomId())) continue;
                            menuPageItem.setRow(this.b.a());
                            menuPageItem.setCol(this.b.b());
                            break;
                        }
                    }
                    MenuPageDesignView.this.h = null;
                    this.b.updateView();
                    this.b.getModel().setPressed(false);
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), exception);
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            boolean bl = false;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                Transferable transferable = transferSupport.getTransferable();
                MenuPageItem menuPageItem = (MenuPageItem)transferable.getTransferData(this.b.e);
                MenuPageDesignView.this.h = this.b.a;
                MenuPageDesignView.this.h.setImage(this.b.a.getImage());
                MenuPageDesignView.this.h.setImageId(this.b.a.getImageId());
                if (menuPageItem != null) {
                    int n = menuPageItem.getRow();
                    int n2 = menuPageItem.getCol();
                    Color color = menuPageItem.getButtonColor();
                    menuPageItem.setButtonColor(this.b.getBackground());
                    menuPageItem.setRow(this.b.a());
                    menuPageItem.setCol(this.b.b());
                    this.b.setMenuPageItem(menuPageItem);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> list = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem2 : list) {
                        if (menuPageItem2 == null || !menuPageItem2.getRandomId().equals(menuPageItem.getRandomId())) continue;
                        menuPageItem2.setRow(this.b.a());
                        menuPageItem2.setCol(this.b.b());
                        break;
                    }
                    MenuPageDesignView.this.h.setButtonColor(color);
                    MenuPageDesignView.this.h.setRow(n);
                    MenuPageDesignView.this.h.setCol(n2);
                }
                this.b.updateView();
                MenuPageDesignView.this.setEnabledSaveAndCancel(true);
                bl = true;
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"));
            }
            return bl;
        }
    }
}

