/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ChargeConfigurationView
extends ConfigurationView {
    private DoubleTextField a;
    private DoubleTextField b;
    private DoubleTextField c;
    private JCheckBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JComboBox g;
    private JComboBox h;
    private JCheckBox i;
    private Outlet j;
    private Store k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private JLabel o;
    private IntegerTextField p;

    public ChargeConfigurationView(Store store) {
        this.k = store;
        this.a();
        this.c();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("RestaurantConfigurationView.42") + ":");
        jPanel.add((Component)jLabel, "alignx trailing");
        this.a = new DoubleTextField();
        jPanel.add((Component)this.a, "growx");
        JLabel jLabel2 = new JLabel("%");
        jPanel.add((Component)jLabel2, "wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        jPanel.add((Component)jLabel3, "flowy,alignx trailing");
        this.b = new DoubleTextField();
        jPanel.add((Component)this.b, "growx");
        JLabel jLabel4 = new JLabel("%");
        jPanel.add((Component)jLabel4, "wrap");
        JLabel jLabel5 = new JLabel(Messages.getString("ChargeConfigurationView.0"));
        jPanel.add((Component)jLabel5, "flowy,alignx trailing");
        this.c = new DoubleTextField();
        jPanel.add((Component)this.c, "growx");
        JLabel jLabel6 = new JLabel("%");
        jPanel.add((Component)jLabel6, "wrap");
        JLabel jLabel7 = new JLabel(Messages.getString("ChargeConfigurationView.1"));
        this.g = new OverflowCombobox();
        jPanel.add((Component)jLabel7, "alignx trailing");
        jPanel.add((Component)this.g, "grow, wrap");
        JLabel jLabel8 = new JLabel(Messages.getString("ChargeConfigurationView.3"));
        this.h = new JComboBox();
        jPanel.add((Component)jLabel8, "alignx trailing");
        jPanel.add((Component)this.h, "grow, wrap");
        this.d = new JCheckBox(Messages.getString("ChargeConfigurationView.5"));
        jPanel.add((Component)this.d, "skip 1, wrap");
        this.e = new JCheckBox(Messages.getString("TaxConfigurationView.4"));
        jPanel.add((Component)this.e, "skip 1,wrap");
        this.f = new JCheckBox(Messages.getString("ChargeConfigurationView.2"));
        jPanel.add((Component)this.f, "skip 1,wrap");
        this.i = new JCheckBox(Messages.getString("ChargeConfigurationView.6"));
        jPanel.add((Component)this.i, "skip 1,wrap");
        this.l = new JCheckBox(Messages.getString("ChargeConfigurationView.7"));
        jPanel.add((Component)this.l, "skip 1, wrap");
        this.m = new JCheckBox(Messages.getString("ChargeConfigurationView.21"));
        jPanel.add((Component)this.m, "skip 1, wrap");
        this.n = new JCheckBox(Messages.getString("ResetTokenNo"));
        this.n.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)this.n, "cell 1 10,growx");
        this.o = new JLabel(Messages.getString("NextTokenSequence"));
        jPanel.add((Component)this.o, "cell 0 11,alignx trailing");
        this.p = new IntegerTextField();
        jPanel.add((Component)this.p, "cell 1 11,growx");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void b() {
        if (this.n.isSelected()) {
            this.a(true);
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl) {
        this.o.setVisible(bl);
        this.p.setVisible(bl);
    }

    private void c() {
        ArrayList<TaxGroup> arrayList = new ArrayList<TaxGroup>();
        arrayList.add(null);
        arrayList.addAll(TaxGroupDAO.getInstance().findAll());
        this.g.setModel(new ComboBoxModel(arrayList));
        ArrayList<Currency> arrayList2 = new ArrayList<Currency>();
        arrayList2.add(null);
        arrayList2.addAll(CurrencyDAO.getInstance().findAll());
        this.h.setModel(new ComboBoxModel(arrayList2));
        this.m.setSelected(!this.k.isShowVoidedItemsOnTicket());
        boolean bl = this.k.getBooleanProperty("reset.token", true);
        this.n.setSelected(bl);
        String string = this.k.getProperty("token_no.start");
        String string2 = string == null ? String.valueOf(1) : string;
        this.p.setText(string2);
        this.a(bl);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        double d = 0.0;
        double d2 = 0.0;
        String string = null;
        String string2 = null;
        if (StringUtils.isEmpty(string)) {
            string = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = "$";
        }
        d = this.a.getDoubleOrZero();
        d2 = this.b.getDoubleOrZero();
        double d3 = this.c.getDoubleOrZero();
        if (d3 > 100.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ChargeConfigurationView.8"));
            return false;
        }
        this.k.setCurrencyName(string);
        this.k.setCurrencySymbol(string2);
        this.k.addProperty("overtime.markup", String.valueOf(d3));
        this.k.addProperty("store.peny.rounding", String.valueOf(this.i.isSelected()));
        this.k.addProperty("store.allow.multiple.discount", String.valueOf(this.l.isSelected()));
        this.k.setShowVoidedItemsOnTicket(!this.m.isSelected());
        this.k.setUseDetailedReconciliation(this.d.isSelected());
        this.k.setItemPriceIncludesTax(this.e.isSelected());
        this.k.setEnableFloridaTaxRule(this.f.isSelected());
        if (this.n.isSelected()) {
            int n = this.p.getInteger();
            if (n < 1) {
                throw new PosException(Messages.getString("TokenNoGreaterOne"));
            }
            this.k.addProperty("token_no.start", String.valueOf(n));
        }
        this.k.addProperty("reset.token", String.valueOf(this.n.isSelected()));
        if (this.j != null) {
            this.j.setServiceChargePercentage(d);
            this.j.setDefaultGratuityPercentage(d2);
            TaxGroup taxGroup = (TaxGroup)this.g.getSelectedItem();
            this.j.setTaxGroup(taxGroup);
            Currency currency = (Currency)this.h.getSelectedItem();
            this.j.setCurrency(currency);
            OutletDAO.getInstance().saveOrUpdate(this.j);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.j = OutletDAO.getInstance().get(DataProvider.get().getStore().getDefaultOutletId());
        if (this.j != null) {
            this.a.setText(String.valueOf(this.j.getServiceChargePercentage()));
            this.b.setText(String.valueOf(this.j.getDefaultGratuityPercentage()));
            this.g.setSelectedItem(this.j.getTaxGroup());
            this.h.setSelectedItem(this.j.getCurrency());
        }
        this.c.setText(String.valueOf(this.k.getOvertimeMarkup()));
        this.d.setSelected(this.k.isUseDetailedReconciliation());
        this.e.setSelected(this.k.isItemPriceIncludesTax());
        this.f.setSelected(this.k.isEnableFloridaTaxRule());
        this.i.setSelected(this.k.isAllowPenyRounding());
        this.l.setSelected(this.k.isAllowMulDiscount());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_CHARGE;
    }
}

