/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.AddPrinterGroupDialog;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrinterGroupView
extends JPanel {
    private JList<PrinterGroup> a;
    private DefaultListModel<PrinterGroup> b;

    public PrinterGroupView() {
    }

    public PrinterGroupView(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterGroupView.this.doAddPrinterGroup();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterGroupView.this.doEditPrinterGroup();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterGroupView.this.a();
            }
        });
        jPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        this.b = new DefaultListModel();
        List<PrinterGroup> list = PrinterGroupDAO.getInstance().findAll();
        for (PrinterGroup printerGroup : list) {
            this.b.addElement(printerGroup);
        }
        this.a = new JList<PrinterGroup>(this.b);
        jScrollPane.setViewportView(this.a);
    }

    private void a() {
        PrinterGroup printerGroup = this.a.getSelectedValue();
        if (printerGroup == null) {
            String string = Messages.getString("PrinterGroupView.0");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
            return;
        }
        try {
            String string = Messages.getString("PrinterGroupView.1");
            String string2 = Messages.getString("PrinterGroupView.2");
            string2 = String.format(string2, printerGroup.getName());
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string);
            if (n != 0) {
                return;
            }
            PrinterGroupDAO.getInstance().delete(printerGroup.getId());
            this.b.removeElement(printerGroup);
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
        this.b();
    }

    protected void doEditPrinterGroup() {
        try {
            PrinterGroup printerGroup = this.a.getSelectedValue();
            if (printerGroup == null) {
                String string = Messages.getString("PrinterGroupView.0");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                return;
            }
            AddPrinterGroupDialog addPrinterGroupDialog = new AddPrinterGroupDialog();
            addPrinterGroupDialog.setPrinterGroup(printerGroup);
            addPrinterGroupDialog.open();
            if (addPrinterGroupDialog.isCanceled()) {
                return;
            }
            PrinterGroup printerGroup2 = addPrinterGroupDialog.getPrinterGroup();
            GenericDAO.getInstance().checkIdOrNameExists(printerGroup2.getId(), printerGroup2.getName(), PrinterGroup.class);
            PrinterGroupDAO.getInstance().saveOrUpdate(printerGroup2);
            this.a.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddPrinterGroup() {
        try {
            AddPrinterGroupDialog addPrinterGroupDialog = new AddPrinterGroupDialog();
            addPrinterGroupDialog.open();
            if (addPrinterGroupDialog.isCanceled()) {
                return;
            }
            PrinterGroup printerGroup = addPrinterGroupDialog.getPrinterGroup();
            GenericDAO.getInstance().checkIdOrNameExists(printerGroup.getId(), printerGroup.getName(), PrinterGroup.class);
            PrinterGroupDAO.getInstance().saveOrUpdate(printerGroup);
            this.b.addElement(printerGroup);
            this.a.repaint();
            this.a.setSelectedValue(printerGroup, Boolean.TRUE);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        this.b.clear();
        List<PrinterGroup> list = PrinterGroupDAO.getInstance().findAll();
        for (PrinterGroup printerGroup : list) {
            this.b.addElement(printerGroup);
        }
    }
}

