/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.TerminalForm;
import com.floreantpos.config.ui.CardConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DatabaseConfigurationView;
import com.floreantpos.config.ui.GiftCardConfigurationView;
import com.floreantpos.config.ui.KitchenDisplayConfigurationView;
import com.floreantpos.config.ui.PaymentOptionConfigurationView;
import com.floreantpos.config.ui.PeripheralConfigurationView;
import com.floreantpos.config.ui.PrintConfigurationView;
import com.floreantpos.config.ui.TicketImportConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.TicketImportPlugin;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class TerminalConfigurationDialog
extends POSDialog
implements ActionListener,
ChangeListener {
    private static final String a = POSConstants.OK;
    private static final String b = POSConstants.CANCEL;
    private JTabbedPane c = new JTabbedPane();
    private List<ConfigurationView> d = new ArrayList<ConfigurationView>();
    private Terminal e;

    public TerminalConfigurationDialog() {
        this(DataProvider.get().getCurrentTerminal());
    }

    public TerminalConfigurationDialog(Terminal terminal) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        boolean bl;
        this.e = terminal;
        boolean bl2 = bl = this.e.getId() == DataProvider.get().getCurrentTerminal().getId();
        if (bl) {
            this.setTitle(POSConstants.CONFIGURE_WINDOW_TITLE);
        } else {
            this.setTitle("Configure Terminal " + terminal.getId());
        }
        this.a();
    }

    private void a() {
        Object object;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.c.addChangeListener(this);
        jPanel.add((Component)this.c, "span, grow");
        this.addView(new TerminalForm(this.e));
        this.addView(new PrintConfigurationView(this.e));
        if (DataProvider.get().getCurrentTerminal().equals(this.e)) {
            this.addView(new CardConfigurationView());
            this.addView(new DatabaseConfigurationView());
            this.addView(new PeripheralConfigurationView());
            this.addView(new GiftCardConfigurationView());
            this.addView(new KitchenDisplayConfigurationView());
            DataProvider.get().refreshCurrentTerminal();
            this.addView(new PaymentOptionConfigurationView(DataProvider.get().getCurrentTerminal()));
            object = (TicketImportPlugin)ExtensionManager.getPlugin(TicketImportPlugin.class);
            if (object != null) {
                this.addView(new TicketImportConfigurationView());
            }
        }
        object = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton jButton = new JButton(b);
        jButton.addActionListener(this);
        ((Container)object).add((Component)jButton, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton jButton2 = new JButton(a);
        jButton2.addActionListener(this);
        ((Container)object).add((Component)jButton2, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)object, "South");
        this.setDefaultCloseOperation(2);
        for (FloreantPlugin floreantPlugin : ExtensionManager.getPlugins()) {
            floreantPlugin.initConfigurationView(this);
        }
        this.add((Component)jPanel, "Center");
    }

    public void addView(ConfigurationView configurationView) {
        this.c.addTab(configurationView.getName(), configurationView);
        this.d.add(configurationView);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ConfigurationView configurationView = (ConfigurationView)this.c.getSelectedComponent();
        if (!configurationView.isInitialized()) {
            try {
                configurationView.initialize();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (a.equalsIgnoreCase(actionEvent.getActionCommand())) {
            try {
                for (ConfigurationView configurationView : this.d) {
                    if (!configurationView.isInitialized() || configurationView.save()) continue;
                    return;
                }
                this.setCanceled(false);
                this.dispose();
            }
            catch (StaleStateException staleStateException) {
                POSMessageDialog.showError(this, staleStateException.getMessage());
            }
            catch (PosException posException) {
                POSMessageDialog.showError(this, posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        } else if (b.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.setCanceled(true);
            this.dispose();
        }
    }
}

