/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.JarUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import org.apache.commons.lang.StringUtils;

public class ExtensionManager {
    private List<FloreantPlugin> a;
    private List<FloreantPlugin> b;
    private static ExtensionManager c;

    private synchronized void a() {
        Object object;
        PluginManager pluginManager = PluginManagerFactory.createPluginManager();
        String string = JarUtil.getJarLocation(Application.class);
        URI uRI = new File(string).toURI();
        pluginManager.addPluginsFrom(uRI, new AddPluginsFromOption[0]);
        String string2 = System.getProperty("pluginsPath");
        if (StringUtils.isNotEmpty((String)string2)) {
            for (String string3 : object = string2.split(",")) {
                PosLog.debug(this.getClass(), "loading plugins from " + string3);
                pluginManager.addPluginsFrom(new File(string3).toURI(), new AddPluginsFromOption[0]);
            }
        } else {
            object = new File("plugins/").toURI();
            PosLog.debug(this.getClass(), "loading plugins from " + ((URI)object).toString());
            pluginManager.addPluginsFrom((URI)object, new AddPluginsFromOption[0]);
        }
        object = new PluginManagerUtil(pluginManager);
        List list = (List)object.getPlugins();
        Collections.sort(list, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin plugin, Plugin plugin2) {
                return plugin.getClass().getName().compareToIgnoreCase(plugin2.getClass().getName());
            }
        });
        ArrayList<FloreantPlugin> arrayList = new ArrayList<FloreantPlugin>();
        this.b = new ArrayList<FloreantPlugin>(3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3;
            string3 = (Plugin)iterator.next();
            if (!(string3 instanceof FloreantPlugin)) continue;
            FloreantPlugin floreantPlugin = (FloreantPlugin)((Object)string3);
            if (floreantPlugin.getMinParentNumericVersion() > VersionInfo.getNumericVersion()) {
                String string4 = Messages.getString("ExtensionManager.2");
                string4 = String.format(string4, floreantPlugin.getProductName(), floreantPlugin.getMinParentVersion(), floreantPlugin.getProductName());
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string4);
                continue;
            }
            if (floreantPlugin.requireLicense()) {
                floreantPlugin.initLicense();
                if (floreantPlugin.hasValidLicense() && floreantPlugin.isActivated()) {
                    arrayList.add(floreantPlugin);
                    continue;
                }
                this.b.add(floreantPlugin);
                continue;
            }
            arrayList.add(floreantPlugin);
        }
        this.a = Collections.unmodifiableList(arrayList);
    }

    public static List<FloreantPlugin> getPlugins() {
        return ExtensionManager.getInstance().a;
    }

    public static List<FloreantPlugin> getInactivePlugins() {
        if (ExtensionManager.getInstance().b == null) {
            return new ArrayList<FloreantPlugin>(0);
        }
        return ExtensionManager.getInstance().b;
    }

    public static List<FloreantPlugin> getPlugins(Class clazz) {
        ArrayList<FloreantPlugin> arrayList = new ArrayList<FloreantPlugin>();
        for (FloreantPlugin floreantPlugin : ExtensionManager.getInstance().a) {
            if (!clazz.isAssignableFrom(floreantPlugin.getClass())) continue;
            arrayList.add(floreantPlugin);
        }
        return arrayList;
    }

    public static FloreantPlugin getPlugin(Class clazz) {
        for (FloreantPlugin floreantPlugin : ExtensionManager.getInstance().a) {
            if (!clazz.isAssignableFrom(floreantPlugin.getClass())) continue;
            if (floreantPlugin.isActivated()) {
                return floreantPlugin;
            }
            return null;
        }
        return null;
    }

    public static synchronized ExtensionManager getInstance() {
        if (c == null) {
            c = new ExtensionManager();
            c.a();
        }
        return c;
    }

    public static void checkForPluginUpdate() {
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            if (!(floreantPlugin instanceof AbstractFloreantPlugin)) continue;
            AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)floreantPlugin;
            abstractFloreantPlugin.checkForUpdate();
        }
    }

    public static AbstractFloreantPlugin findByPluginName(String string) {
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            if (!(floreantPlugin instanceof AbstractFloreantPlugin)) continue;
            AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)floreantPlugin;
            String string2 = abstractFloreantPlugin.getProductName();
            if (string == null || string2 == null || !string.equalsIgnoreCase(string2.trim().toLowerCase())) continue;
            return abstractFloreantPlugin;
        }
        throw new PosException(Messages.getString("ExtensionManager.1"));
    }
}

