/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "image", "scaledImage", "properties", "imageData"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class OrderType
extends BaseOrderType
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String BAR_TAB = "BAR_TAB";
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private byte[] imageBytes;

    public OrderType() {
    }

    public TaxGroup getDefaultTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getDefaultTaxGroupId());
    }

    public void setDefaultTaxGroup(TaxGroup taxGroup) {
        this.setDefaultTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    public TaxGroup getForHereTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getForHereTaxGroupId());
    }

    public void setForHereTaxGroup(TaxGroup taxGroup) {
        this.setForHereTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    public TaxGroup getToGoTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getToGoTaxGroupId());
    }

    public void setToGoTaxGroup(TaxGroup taxGroup) {
        this.setToGoTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    @Override
    public Integer getButtonColorCode() {
        Integer n = super.getButtonColorCode();
        if (n == null || n == 0 || n == -1316371 || n == -1250856) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    public Color getButtonColor() {
        Integer n = this.getButtonColorCode();
        if (n == null) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public void setButtonColor(Color color) {
        if (color != null) {
            this.setButtonColorCode(color.getRGB());
        }
    }

    public OrderType(String string) {
        super(string);
    }

    public String name() {
        return super.getName();
    }

    public OrderType valueOf() {
        return this;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            string.replaceAll("_", " ");
        }
        return string;
    }

    @XmlTransient
    public ImageIcon getImage() {
        if (this.imageBytes == null) {
            return null;
        }
        return new ImageIcon(this.imageBytes);
    }

    @Override
    @XmlTransient
    public void setImageData(Blob blob) {
        super.setImageData(blob);
        if (blob != null) {
            try {
                int n = (int)blob.length();
                this.imageBytes = blob.getBytes(1L, n);
            }
            catch (SQLException sQLException) {
                PosLog.error(this.getClass(), sQLException);
            }
        }
    }

    public ImageIcon getScaledImage(int n, int n2) {
        Image image = null;
        if (this.imageBytes != null) {
            ImageIcon imageIcon = new ImageIcon(this.imageBytes);
            image = imageIcon.getImage().getScaledInstance(n, n2, 4);
            return new ImageIcon(image);
        }
        return null;
    }

    public String getUniqueId() {
        return ("order_type_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] byArray) {
        this.imageBytes = byArray;
    }
}

