/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseRecepieItem;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"recepie", "unit"})
public class RecepieItem
extends BaseRecepieItem {
    private static final long serialVersionUID = 1L;
    private double cost;
    private transient IUnit unit;
    private String groupName;
    private String groupId;

    public RecepieItem() {
    }

    public RecepieItem(String string) {
        super(string);
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public void setUnit(IUnit iUnit) {
        this.unit = iUnit;
    }

    public IUnit getUnit() {
        List<IUnit> list;
        MenuItem menuItem = this.getInventoryItem();
        if (menuItem == null) {
            return null;
        }
        MenuItemDAO.getInstance().initialize(menuItem);
        if (menuItem != null && (list = menuItem.getUnits()) != null && list.size() > 0) {
            for (IUnit iUnit : list) {
                if (this.getUnitCode() == null || !this.getUnitCode().equals(iUnit.getUniqueCode())) continue;
                this.unit = iUnit;
            }
        }
        return this.unit;
    }

    public void calculatePercentage() {
        MenuItem menuItem = this.getInventoryItem();
        if (menuItem != null) {
            double d = menuItem.getBaseUnitQuantity(this.getUnitCode());
            this.setPercentage(this.getQuantity() * d * 100.0);
            this.setCost(menuItem.getCost() * this.getQuantity() * d);
        }
    }

    @Override
    public String toString() {
        MenuItem menuItem = super.getInventoryItem();
        if (menuItem == null) {
            return "";
        }
        return menuItem.toString();
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }
}

