/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Store;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIgnoreProperties(ignoreUnknown=true, value={"enable"})
@XmlRootElement
public class Tax
extends BaseTax
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public Tax() {
    }

    public Tax(String string) {
        super(string);
    }

    public Tax(String string, String string2) {
        super(string, string2);
    }

    public Tax(String string, String string2, double d) {
        super(string, string2);
        this.setRate(d);
    }

    public String getUniqueId() {
        return ("tax_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String toString() {
        return this.getName() + " (" + NumberUtil.formatAmount(this.getRate()) + "%)";
    }

    public Boolean isEnable() {
        return this.enable == null ? false : this.enable;
    }

    public void setEnable(Boolean bl) {
        this.enable = bl;
    }

    public static BigDecimal applyFloridaTaxRule(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = NumberUtil.round(bigDecimal2);
        Store store = DataProvider.get().getStore();
        if (store.isEnableFloridaTaxRule()) {
            int n = bigDecimal.multiply(new BigDecimal(100)).intValue();
            if (bigDecimal3.compareTo(bigDecimal2) == 1 && ((n %= 100) == 8 || n == 9)) {
                bigDecimal3 = NumberUtil.round(NumberUtil.round(bigDecimal2).subtract(new BigDecimal(0.01)));
            } else if (n > 9 && bigDecimal3.compareTo(bigDecimal2) == -1) {
                bigDecimal3 = NumberUtil.round(bigDecimal3.add(new BigDecimal(0.01)));
            }
        }
        return bigDecimal3;
    }
}

