/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Tax;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.beans.Transient;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"inventoryAdjusted", "menuItem"})
@XmlSeeAlso(value={ModifiableTicketItem.class, ComboTicketItem.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ModifiableTicketItem.class), @JsonSubTypes.Type(value=ComboTicketItem.class)})
public class TicketItem
extends BaseTicketItem
implements ITicketItem {
    public static final String JSON_PROP_VOID_REASON = "voidReason";
    public static final String PROPERTY_COOKING_INSTRUCTION = "COOKING_INSTRUCTION";
    public static final String PROPERTY_TAX = "TAX";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient com.google.gson.JsonObject propertiesContainer;
    private String classType;
    private MenuItem menuItem;
    private int tableRowNum;
    private Double quantityToShip;
    public static final int HALF = 0;
    public static final int FULL = 1;
    public static final int SHARED_FULL = 2;
    public static final int SHARED_CUSTOM = 3;
    private Boolean includeVoidQuantity;
    private VoidItem voidItem;
    private List<TicketItemCookingInstruction> cookingInstructions;
    private List<TicketItemTax> taxes;
    private List<TicketItemDiscount> discounts;
    private TicketItem parentTicketItem;
    private Integer sortOrder;

    public TicketItem() {
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(String string) {
        super(string);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(Ticket ticket, String string, double d, double d2, TicketItemTax ticketItemTax) {
        this.setName(string);
        this.setUnitPrice(d);
        this.setQuantity(d2);
        this.addTotaxes(ticketItemTax);
        this.setTicket(ticket);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem createNew() {
        if (this instanceof ModifiableTicketItem) {
            return new ModifiableTicketItem();
        }
        return new TicketItem();
    }

    public Boolean isHasModifiers() {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        return list != null && list.size() > 0;
    }

    public TicketItemModifier getSizeModifier() {
        return null;
    }

    public void setSizeModifier(TicketItemModifier ticketItemModifier) {
    }

    public List<TicketItemModifier> getTicketItemModifiers() {
        return null;
    }

    public void setTicketItemModifiers(List<TicketItemModifier> list) {
    }

    public void addToticketItemModifiers(TicketItemModifier ticketItemModifier) {
    }

    public TicketItem clone() {
        return (TicketItem)SerializationUtils.clone((Serializable)this);
    }

    public TicketItem cloneAsNew() {
        try {
            TicketItem ticketItem = (TicketItem)CopyUtil.deepCopy(this);
            ticketItem.setId(null);
            ticketItem.setVersion(0L);
            ticketItem.setPrintedToKitchen(false);
            ticketItem.setInventoryAdjustQty(0.0);
            ticketItem.setCloudSynced(false);
            ticketItem.setHasSyncError(false);
            ticketItem.setSeat(null);
            if (ticketItem.getSizeModifier() != null) {
                ticketItem.getSizeModifier().setId(null);
                ticketItem.getSizeModifier().setPrintedToKitchen(false);
            }
            List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
            ticketItem.setTicketItemModifiers(null);
            if (list != null && list.size() > 0) {
                for (TicketItemModifier serializable2 : list) {
                    serializable2.setId(null);
                    serializable2.setPrintedToKitchen(false);
                    ticketItem.addToticketItemModifiers(serializable2);
                }
            }
            List<TicketItem> list2 = ticketItem.getComboItems();
            ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
            if (this.isComboItem().booleanValue()) {
                ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
                if (list2 != null) {
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        TicketItem ticketItem2 = (TicketItem)iterator.next();
                        TicketItem ticketItem3 = ticketItem2.cloneAsNew();
                        ticketItem3.setId(null);
                        ticketItem3.setParentTicketItem(comboTicketItem);
                        arrayList.add(ticketItem3);
                    }
                    comboTicketItem.setComboItems(arrayList);
                }
                return comboTicketItem;
            }
            ticketItem.setComboItems(null);
            return ticketItem;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        this.buildTaxes();
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    ticketItemTax.setName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_RATE));
                    ticketItemTax.setTaxAmount(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_TAX_AMOUNT));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        this.taxes = this.getTaxes();
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setDiscounts(List<TicketItemDiscount> list) {
        this.discounts = list;
    }

    public List<TicketItemDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
            String string = super.getDiscountsProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JSONArray jSONArray = new JSONArray(string);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                    ticketItemDiscount.setTicketItem(this);
                    ticketItemDiscount.setDiscountId(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                    ticketItemDiscount.setName(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_NAME));
                    ticketItemDiscount.setType(OrgJsonUtil.getInt(jSONObject, TicketItemDiscount.PROP_TYPE));
                    ticketItemDiscount.setAutoApply(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_AUTO_APPLY));
                    ticketItemDiscount.setCouponQuantity(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                    ticketItemDiscount.setMinimumAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                    ticketItemDiscount.setValue(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_VALUE));
                    ticketItemDiscount.setAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_AMOUNT));
                    this.discounts.add(ticketItemDiscount);
                }
            }
        }
        return this.discounts;
    }

    public void addTodiscounts(TicketItemDiscount ticketItemDiscount) {
        this.discounts = this.getDiscounts();
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
        }
        this.discounts.add(ticketItemDiscount);
        ActionHistoryDAO.addTicketItemDiscountAddedActionHistory(this.getTicket(), ticketItemDiscount);
    }

    public void buildDiscounts() {
        if (this.discounts == null || this.discounts.isEmpty()) {
            this.setDiscountsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemDiscount ticketItemDiscount : this.discounts) {
            jSONArray.put((Object)ticketItemDiscount.toJson());
        }
        this.setDiscountsProperty(jSONArray.toString());
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return this.isPrintedToKitchen() == false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = list;
        this.buildCoookingInstructions();
    }

    public void addCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>(2);
        }
        for (TicketItemCookingInstruction ticketItemCookingInstruction : list) {
            this.addCookingInstruction(ticketItemCookingInstruction);
        }
    }

    public void addCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            return;
        }
        this.cookingInstructions.add(ticketItemCookingInstruction);
        this.buildCoookingInstructions();
    }

    public void buildCoookingInstructions() {
        if (this.cookingInstructions == null || this.cookingInstructions.isEmpty()) {
            this.setCookingInstructionsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemCookingInstruction ticketItemCookingInstruction : this.cookingInstructions) {
            jSONArray.put((Object)ticketItemCookingInstruction.toJson());
        }
        this.setCookingInstructionsProperty(jSONArray.toString());
    }

    public void removeCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        List<TicketItemCookingInstruction> list = this.getCookingInstructions();
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<TicketItemCookingInstruction> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemCookingInstruction ticketItemCookingInstruction2 = iterator.next();
            if (ticketItemCookingInstruction2.getTableRowNum() != ticketItemCookingInstruction.getTableRowNum()) continue;
            iterator.remove();
            this.buildCoookingInstructions();
            return;
        }
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier) {
        return this.addTicketItemModifier(menuModifier, n, orderType, multiplier, 1.0);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier, double d) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        ticketItemModifier.setPageItemId(menuModifier.getPageItemId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemQuantity(d);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        double d2 = menuModifier.getPriceForMultiplier(multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefix() + " " + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(d2);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(orderType, this));
        ticketItemModifier.setModifierType(n);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        if (StringUtils.isNotEmpty((String)menuModifier.getTranslatedName())) {
            ticketItemModifier.addProperty("translatedName", menuModifier.getTranslatedName());
        }
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, boolean bl) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemCount(1);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        if (bl) {
            ticketItemModifier.setUnitPrice(menuModifier.getExtraPrice());
            ticketItemModifier.setModifierType(3);
        } else {
            ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            ticketItemModifier.setModifierType(1);
        }
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(ticketItemModifier.getTicketItem().getTicket().getOrderType(), this));
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public void updateModifiersUnitPrice(double d) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * d / 100.0);
            }
        }
    }

    public void updateModifiersUnitPriceByGroup(MenuItemModifierSpec menuItemModifierSpec) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        if (list != null) {
            double d = 0.0;
            for (TicketItemModifier object : list) {
                if (object.isInfoOnly().booleanValue() || !object.getGroupId().equals(menuItemModifierSpec.getId())) continue;
                arrayList.add(object);
                d += object.getItemQuantity().doubleValue();
            }
            Double d2 = menuItemModifierSpec.getPrice((int)d);
            if (d2 != null && d > 0.0) {
                for (TicketItemModifier ticketItemModifier : arrayList) {
                    ticketItemModifier.setUnitPrice(ticketItemModifier.getMultiplierPrice(d2 / (double)((int)d)));
                }
            }
        }
    }

    public boolean contains(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        int n = 0;
        if (list != null) {
            for (TicketItemModifier ticketItemModifier2 : list) {
                if (ticketItemModifier2.isInfoOnly().booleanValue() || !ticketItemModifier.getName().trim().equals(ticketItemModifier2.getName().trim())) continue;
                ++n;
            }
        }
        return n > 1;
    }

    public TicketItemModifier removeTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (!ticketItemModifier2.getItemId().equals(ticketItemModifier.getItemId()) || ticketItemModifier2.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iterator.remove();
            return ticketItemModifier2;
        }
        return ticketItemModifier;
    }

    public TicketItemModifier removeTicketItemModifier(int n) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        TicketItemModifier ticketItemModifier = list.get(n);
        list.remove(n);
        return ticketItemModifier;
    }

    public void calculatePrice() {
        Serializable serializable;
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        BigDecimal bigDecimal4 = this.calculateDiscount(bigDecimal3);
        BigDecimal bigDecimal5 = this.calculateServiceCharge(bigDecimal3);
        BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal7 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal8 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal9 = null;
        bigDecimal9 = this.isTaxOnServiceCharge() != false ? this.calculateTax(bigDecimal3.subtract(bigDecimal4).add(bigDecimal5)) : this.calculateTax(bigDecimal3.subtract(bigDecimal4));
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            serializable = new HashSet();
            for (TicketItemModifier comparable2 : list) {
                if (comparable2.isInfoOnly().booleanValue()) continue;
                comparable2.calculatePrice();
                if (comparable2.isShouldSectionWisePrice().booleanValue() && serializable.contains(comparable2.getItemId())) continue;
                bigDecimal6 = bigDecimal6.add(NumberUtil.convertToBigDecimal(comparable2.getSubTotalAmount()));
                bigDecimal7 = bigDecimal7.add(NumberUtil.convertToBigDecimal(comparable2.getDiscountAmount()));
                bigDecimal8 = bigDecimal8.add(NumberUtil.convertToBigDecimal(comparable2.getTaxAmount()));
                bigDecimal5 = bigDecimal5.add(NumberUtil.convertToBigDecimal(comparable2.getServiceCharge()));
                serializable.add(comparable2.getItemId());
            }
        }
        serializable = bigDecimal3.add(bigDecimal6);
        BigDecimal bigDecimal10 = this.calculateDiscount((BigDecimal)serializable);
        BigDecimal bigDecimal11 = bigDecimal9.add(bigDecimal8);
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal13 = NumberUtil.convertToBigDecimal("0");
        if (this.isTaxIncluded().booleanValue()) {
            bigDecimal12 = ((BigDecimal)serializable).subtract(bigDecimal10).add(bigDecimal5);
            bigDecimal13 = bigDecimal3.subtract(bigDecimal4).add(bigDecimal5);
        } else {
            bigDecimal12 = ((BigDecimal)serializable).subtract(bigDecimal10).add(bigDecimal11).add(bigDecimal5);
            bigDecimal13 = bigDecimal3.subtract(bigDecimal4).add(bigDecimal9).add(bigDecimal5);
        }
        this.setSubtotalAmount(NumberUtil.round(((BigDecimal)serializable).doubleValue()));
        this.setSubtotalAmountWithoutModifiers(NumberUtil.round(bigDecimal3.doubleValue()));
        this.setDiscountAmount(NumberUtil.round(bigDecimal10.doubleValue()));
        this.setDiscountWithoutModifiers(NumberUtil.round(bigDecimal4.doubleValue()));
        this.setTaxAmount(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setTaxAmountWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setServiceCharge(NumberUtil.round(bigDecimal5.doubleValue()));
        this.setTotalAmount(NumberUtil.round(bigDecimal12.doubleValue()));
        this.setTotalAmountWithoutModifiers(NumberUtil.round(bigDecimal13.doubleValue()));
        this.setAdjustedUnitPrice(bigDecimal.doubleValue());
        this.setAdjustedDiscount(NumberUtil.round(bigDecimal10.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(bigDecimal4.doubleValue()));
        this.setAdjustedSubtotal(NumberUtil.round(((BigDecimal)serializable).doubleValue()));
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(bigDecimal3.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(bigDecimal12.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(bigDecimal13.doubleValue()));
    }

    public void calculateAdjustedPrice() {
        Serializable serializable;
        BigDecimal bigDecimal;
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems());
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount());
        BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount());
        BigDecimal bigDecimal5 = bigDecimal2.subtract(bigDecimal4);
        BigDecimal bigDecimal6 = bigDecimal5.subtract(bigDecimal3);
        BigDecimal bigDecimal7 = bigDecimal = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(NumberUtil.convertToBigDecimal(this.getDiscountWithoutModifiers()));
        if (bigDecimal5.compareTo(BigDecimal.ZERO) != 0) {
            bigDecimal7 = bigDecimal.multiply(bigDecimal6).divide(bigDecimal5, 4, RoundingMode.HALF_UP);
        }
        BigDecimal bigDecimal8 = NumberUtil.convertToBigDecimal(this.getServiceCharge());
        BigDecimal bigDecimal9 = this.calculateTax(bigDecimal7.add(bigDecimal8));
        BigDecimal bigDecimal10 = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal bigDecimal11 = bigDecimal7.divide(bigDecimal10, 4, RoundingMode.HALF_UP);
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal13 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal14 = NumberUtil.convertToBigDecimal("0");
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            serializable = new HashSet();
            for (TicketItemModifier comparable2 : list) {
                if (comparable2.isInfoOnly().booleanValue()) continue;
                comparable2.calculateAdjustedPrice();
                if (!comparable2.isShouldSectionWisePrice().booleanValue() && serializable.contains(comparable2.getItemId())) continue;
                bigDecimal12 = bigDecimal12.add(bigDecimal10.multiply(NumberUtil.convertToBigDecimal(comparable2.getAdjustedSubtotal()).abs()));
                bigDecimal13 = bigDecimal13.add(bigDecimal10.multiply(NumberUtil.convertToBigDecimal(comparable2.getAdjustedDiscount()).abs()));
                bigDecimal14 = bigDecimal14.add(bigDecimal10.multiply(NumberUtil.convertToBigDecimal(comparable2.getAdjustedTax()).abs()));
                serializable.add(comparable2.getItemId());
            }
        }
        serializable = bigDecimal7.add(bigDecimal12);
        BigDecimal bigDecimal15 = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(bigDecimal7);
        BigDecimal bigDecimal16 = bigDecimal15.add(bigDecimal13);
        BigDecimal bigDecimal17 = bigDecimal9.add(bigDecimal14);
        BigDecimal bigDecimal18 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal19 = NumberUtil.convertToBigDecimal(0.0);
        if (this.isTaxIncluded().booleanValue()) {
            bigDecimal18 = ((BigDecimal)serializable).add(bigDecimal8);
            bigDecimal19 = bigDecimal7.add(bigDecimal8);
        } else {
            bigDecimal18 = ((BigDecimal)serializable).add(bigDecimal17).add(bigDecimal8);
            bigDecimal19 = bigDecimal7.add(bigDecimal9).add(bigDecimal8);
        }
        this.setAdjustedUnitPrice(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setAdjustedDiscount(NumberUtil.round(bigDecimal16.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(bigDecimal15.doubleValue()));
        this.setAdjustedSubtotal(NumberUtil.round(((BigDecimal)serializable).doubleValue()));
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(bigDecimal7.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(bigDecimal17.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(bigDecimal18.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(bigDecimal19.doubleValue()));
    }

    public BigDecimal calculateServiceCharge(BigDecimal bigDecimal) {
        Double d = this.getServiceChargeRate();
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getOrderType() == null) {
            return new BigDecimal("0");
        }
        if (!this.isServiceChargeApplicable().booleanValue() || d == 0.0 || !ticket.getOrderType().isServiceChargeApplicable().booleanValue()) {
            return new BigDecimal("0");
        }
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(d / 100.0);
        return NumberUtil.round(bigDecimal.multiply(bigDecimal2));
    }

    public boolean isMergable(TicketItem ticketItem, boolean bl) {
        if (this.isTreatAsSeat().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) {
            return false;
        }
        if (this.isFractionalUnit().booleanValue() || ticketItem.isFractionalUnit().booleanValue()) {
            return false;
        }
        if (this.getQuantity() > 0.0 && ticketItem.getQuantity() < 0.0 || this.getQuantity() < 0.0 && ticketItem.getQuantity() > 0.0) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMenuItemId()) || StringUtils.isEmpty((String)ticketItem.getMenuItemId())) {
            return false;
        }
        if (this.hasCookingInstructions() || ticketItem.hasCookingInstructions()) {
            return false;
        }
        if (!this.getMenuItemId().equals(ticketItem.getMenuItemId())) {
            return false;
        }
        if (!this.getUnitPrice().equals(ticketItem.getUnitPrice())) {
            return false;
        }
        if (this.getSeatNumber() != ticketItem.getSeatNumber()) {
            return false;
        }
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            return true;
        }
        return this.isMergableModifiers(this.getTicketItemModifiers(), ticketItem.getTicketItemModifiers(), bl);
    }

    public boolean isMergableModifiers(List<TicketItemModifier> list, List<TicketItemModifier> list2, boolean bl) {
        if (list2 == null || list == null) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Comparator<TicketItemModifier> comparator = new Comparator<TicketItemModifier>(){

            @Override
            public int compare(TicketItemModifier ticketItemModifier, TicketItemModifier ticketItemModifier2) {
                return ticketItemModifier.getItemId().compareTo(ticketItemModifier2.getItemId());
            }
        };
        Collections.sort(list, comparator);
        Collections.sort(list2, comparator);
        Iterator<TicketItemModifier> iterator = list.iterator();
        Iterator<TicketItemModifier> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier;
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (comparator.compare(ticketItemModifier2, ticketItemModifier = iterator2.next()) != 0) {
                return false;
            }
            if (!bl) continue;
            ticketItemModifier2.merge(ticketItemModifier);
        }
        return true;
    }

    public void doCalculateComboItemPrice() {
        if (!(this instanceof ComboTicketItem)) {
            return;
        }
        ComboTicketItem comboTicketItem = (ComboTicketItem)this;
        List<ComboGroup> list = comboTicketItem.getMenuItem().getComboGroups();
        if (list == null || list.isEmpty()) {
            return;
        }
        double d = comboTicketItem.getComboItemsPrice();
        for (ComboGroup comboGroup : list) {
            List<MenuItem> list2;
            if (comboGroup == null || (list2 = comboGroup.getItems()) == null || list2.isEmpty()) continue;
            List<TicketItem> list3 = comboTicketItem.getComboItems();
            for (MenuItem menuItem : list2) {
                if (menuItem == null || StringUtils.isEmpty((String)menuItem.getId())) continue;
                for (TicketItem ticketItem : list3) {
                    if (ticketItem == null || StringUtils.isEmpty((String)ticketItem.getMenuItemId()) || !menuItem.getId().equals(ticketItem.getMenuItemId()) || ticketItem.getGroupId() == null) continue;
                    d += comboGroup.getItemPrice(menuItem.getId());
                }
            }
        }
        comboTicketItem.setUnitPrice(d);
    }

    public void merge(TicketItem ticketItem) {
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
            return;
        }
        if (this.isMergable(ticketItem, false)) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
        }
    }

    public boolean hasCookingInstructions() {
        return this.getCookingInstructions() != null && this.getCookingInstructions().size() > 0;
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    bigDecimal2 = bigDecimal2.add(NumberUtil.convertToBigDecimal(ticketItemDiscount.calculateDiscount(bigDecimal.doubleValue() - bigDecimal2.doubleValue())));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double d = bigDecimal.doubleValue() == 0.0 ? 0.0 : Math.abs(ticketItemDiscount.getValue() * 100.0 / bigDecimal.doubleValue());
                TicketItemDiscount ticketItemDiscount2 = new TicketItemDiscount();
                ticketItemDiscount2.setType(1);
                ticketItemDiscount2.setValue(d);
                ticketItemDiscount2.setTicketItem(this);
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(ticketItemDiscount2.calculateDiscount(bigDecimal.doubleValue()));
                bigDecimal2 = bigDecimal2.add(bigDecimal3);
                ticketItemDiscount.setAmount(bigDecimal3.doubleValue());
            }
        }
        this.buildDiscounts();
        if (bigDecimal2.compareTo(bigDecimal.abs()) > 0) {
            return bigDecimal;
        }
        return NumberUtil.round(bigDecimal2);
    }

    public double getAmountByType(TicketItemDiscount ticketItemDiscount) {
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return ticketItemDiscount.getValue() * this.getUnitPrice() / 100.0;
            }
        }
        return 0.0;
    }

    private BigDecimal calculateTax(BigDecimal bigDecimal) {
        Object object;
        Ticket ticket = this.getTicket();
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal("0");
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (this.isTaxIncluded().booleanValue()) {
                object = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax comparable2 : list) {
                    object = ((BigDecimal)object).add(NumberUtil.convertToBigDecimal(comparable2.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN));
                }
                if (((BigDecimal)object).compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return bigDecimal2;
                }
                BigDecimal bigDecimal3 = ((BigDecimal)object).add(NumberUtil.convertToBigDecimal(1.0));
                BigDecimal bigDecimal5 = bigDecimal.divide(bigDecimal3, 4, RoundingMode.HALF_EVEN);
                for (TicketItemTax ticketItemTax : list) {
                    object = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    BigDecimal bigDecimal4 = bigDecimal5.multiply((BigDecimal)object);
                    ticketItemTax.setTaxAmount(bigDecimal4.doubleValue());
                    bigDecimal2 = bigDecimal2.add(bigDecimal4);
                }
            } else {
                object = list.iterator();
                while (object.hasNext()) {
                    TicketItemTax ticketItemTax = (TicketItemTax)object.next();
                    BigDecimal bigDecimal5 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    if (bigDecimal5.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) continue;
                    BigDecimal bigDecimal6 = bigDecimal.multiply(bigDecimal5);
                    ticketItemTax.setTaxAmount(bigDecimal6.doubleValue());
                    bigDecimal2 = bigDecimal2.add(bigDecimal6);
                }
            }
        }
        this.buildTaxes();
        this.addProperty("tax.exempt.amount", String.valueOf(bigDecimal2));
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        Object object2 = object = ticket == null ? null : ticket.getCustomer();
        if (object != null && ((BaseCustomer)object).isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        return Tax.applyFloridaTaxRule(bigDecimal, bigDecimal2);
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    @Override
    public String getNameDisplay() {
        return this.getNameDisplay(this.getName());
    }

    public String getNameDisplay(String string) {
        if (this.isTreatAsSeat().booleanValue()) {
            return string;
        }
        String string2 = "";
        if (this.getQuantity() < 0.0) {
            if (this.isVoided().booleanValue() && this.getVoidedItemId() != null) {
                string2 = string2 + "*Voided* ";
                string2 = string2 + this.getItemQuantityDisplay(true);
            } else {
                string2 = string2 + this.getItemQuantityDisplay();
            }
        } else {
            string2 = string2 + this.getItemQuantityDisplay();
        }
        if (this.isComboItem().booleanValue()) {
            List<TicketItem> list = this.getComboItems();
            if (list != null && !list.isEmpty()) {
                string2 = string2 + string;
                string2 = string2 + "\n";
                Iterator<TicketItem> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    string2 = string2 + " #" + NumberUtil.trimDecilamIfNotNeeded(ticketItem.getQuantity(), true) + " " + ticketItem.getName();
                    List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
                    if (iterator.hasNext() || list2 != null) {
                        string2 = string2 + "\n";
                    }
                    if (list2 == null || list2.isEmpty()) continue;
                    Iterator<TicketItemModifier> iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        TicketItemModifier ticketItemModifier = iterator2.next();
                        string2 = string2 + ticketItemModifier.getNameDisplay();
                        if (iterator2.hasNext()) {
                            string2 = string2 + "\n";
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        string2 = string2 + "\n";
                    }
                }
                return string2;
            }
        } else if (this.getSizeModifier() != null) {
            string2 = string2 + this.getSizeModifier().getNameDisplay().replaceAll(" -- ", "") + " " + this.getName();
            return string2;
        }
        string2 = string2 + string;
        return string2;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return this.getItemQuantityDisplay(false);
    }

    public String getItemQuantityDisplay(boolean bl) {
        if (this.isTreatAsSeat().booleanValue()) {
            return "";
        }
        Double d = bl ? Math.abs(this.getQuantity()) : this.getQuantity();
        if (!this.isFractionalUnit().booleanValue() && d == 1.0) {
            return "";
        }
        String string = NumberUtil.trimDecilamIfNotNeeded(d, true);
        String string2 = this.getUnitName();
        if (string2.equals("") || "ea".equals(string2) || "pc".equals(string2)) {
            return string + "x ";
        }
        return string + string2 + " ";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmountWithoutModifiers());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmountWithoutModifiers());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubtotalAmountWithoutModifiers());
    }

    @Override
    public String getItemCode() {
        return String.valueOf(this.getMenuItemId());
    }

    public List<Printer> getPrinters(OrderType orderType) {
        PrinterGroup printerGroup = this.getPrinterGroup();
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        List<Printer> list = posPrinters.getKitchenPrinters();
        arrayList.addAll(posPrinters.getStickerPrinters());
        if (printerGroup == null && (list == null || list.isEmpty()) && posPrinters.isPrintToKds()) {
            arrayList.add(VirtualPrinter.getKdsPrinter());
        }
        if (printerGroup == null && list != null && list.size() > 0) {
            Printer printer = list.get(0);
            if (StringUtils.isBlank((String)printer.getDeviceName())) {
                arrayList.add(VirtualPrinter.getKdsPrinter());
            } else {
                arrayList.add(printer);
            }
            return arrayList;
        }
        if (printerGroup != null) {
            List<String> list2 = printerGroup.getPrinterNames();
            for (Printer printer : list) {
                VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
                if (StringUtils.isBlank((String)printer.getDeviceName()) || !list2.contains(virtualPrinter.getName())) continue;
                arrayList.add(printer);
            }
        }
        if (arrayList.isEmpty() && posPrinters.isPrintToKds()) {
            arrayList.add(VirtualPrinter.getKdsPrinter());
        }
        return arrayList;
    }

    @Override
    public boolean canAddDiscount() {
        return true;
    }

    @Override
    public boolean canVoid() {
        return true;
    }

    @Override
    public boolean canAddAdOn() {
        return true;
    }

    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    @Transient
    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        String string = null;
        if (menuItem != null) {
            string = menuItem.getId();
        }
        super.setMenuItemId(string);
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getKitchenStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setKitchenStatus(kitchenStatus.name());
    }

    @Override
    public String getUnitName() {
        if (super.getUnitName() == null) {
            return "";
        }
        return super.getUnitName();
    }

    public Double getQuantityToShip() {
        return this.quantityToShip == null ? 0.0 : this.quantityToShip;
    }

    public void setQuantityToShip(Double d) {
        this.quantityToShip = d;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        if (this.isVoided().booleanValue() && this.getVoidedItemId() != null) {
            return "(" + NumberUtil.formatAmount(Math.abs(this.getSubtotalAmount())) + ")";
        }
        return NumberUtil.formatAmount(this.getSubtotalAmount());
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            boolean bl;
            String string = ticketItemModifier.getItemId();
            String string2 = menuModifier.getMenuItemModifierGroup().getId();
            String string3 = ticketItemModifier.getGroupId();
            String string4 = ticketItemModifier.getMultiplierName();
            boolean bl2 = bl = string == null || string2 == null || string3 == null;
            if (bl) {
                return null;
            }
            if (!multiplier.getId().equals(string4)) {
                return null;
            }
            if (!string2.equals(string3) || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public List<TicketItemModifier> findTicketItemModifiersFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        if (list == null) {
            return arrayList;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId()) || !multiplier.getId().equals(ticketItemModifier.getMultiplierName())) continue;
            arrayList.add(ticketItemModifier);
        }
        return arrayList;
    }

    public double findTicketItemModifierByMenuModifier(MenuModifier menuModifier) {
        if (menuModifier == null) {
            return 0.0;
        }
        double d = 0.0;
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        if (list != null) {
            for (Multiplier multiplier : list) {
                List<TicketItemModifier> list2 = this.findTicketItemModifiersFor(menuModifier, multiplier);
                if (list2 == null || list2.isEmpty()) continue;
                for (TicketItemModifier ticketItemModifier : list2) {
                    d += ticketItemModifier.getItemQuantity().doubleValue();
                }
            }
        }
        return d;
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string) {
        return this.findTicketItemModifierFor(menuModifier, string, null);
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string2 = ticketItemModifier.getItemId();
            if (multiplier != null && string2 != null && string2.equals(menuModifier.getId()) && string != null && string.equals(ticketItemModifier.getSectionName()) && multiplier != null && multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                return ticketItemModifier;
            }
            if (string2 == null || !string2.equals(menuModifier.getId()) || string == null || !string.equals(ticketItemModifier.getSectionName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public int countModifierFromGroup(MenuItemModifierSpec menuItemModifierSpec) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getGroupId();
            if (string == null || !string.equals(menuItemModifierSpec.getId())) continue;
            n = (int)((double)n + ticketItemModifier.getItemQuantity());
        }
        return n;
    }

    public boolean requiredModifiersAdded(MenuItemModifierSpec menuItemModifierSpec) {
        int n = menuItemModifierSpec.getMinQuantity();
        if (n == 0) {
            return true;
        }
        return this.countModifierFromGroup(menuItemModifierSpec) >= n;
    }

    public boolean deleteTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null || list.isEmpty()) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (ticketItemModifier2 != ticketItemModifier) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean deleteTicketItemModifierByName(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (!ticketItemModifier2.getName().equals(ticketItemModifier.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setPizzaSectionMode(PIZZA_SECTION_MODE pIZZA_SECTION_MODE) {
        this.setPizzaSectionModeType(pIZZA_SECTION_MODE.getValue());
    }

    public PIZZA_SECTION_MODE getPizzaSectionMode() {
        return PIZZA_SECTION_MODE.from(this.getPizzaSectionModeType());
    }

    public TicketItemModifier findTicketItemModifierByPageItem(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getPageItemId();
            if (string == null || !string.equals(menuModifier.getPageItemId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier findTicketItemComboModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId()) || ticketItemModifier.getModifierType() != 3) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier removeTicketItemModifierByPageItem(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            String string = ticketItemModifier2.getPageItemId();
            if (string == null || !string.equals(ticketItemModifier.getPageItemId()) || ticketItemModifier2.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iterator.remove();
            return ticketItemModifier2;
        }
        return ticketItemModifier;
    }

    public void removeTicketItemDiscount(TicketItemDiscount ticketItemDiscount) {
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list == null) {
            return;
        }
        Iterator<TicketItemDiscount> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscount ticketItemDiscount2 = iterator.next();
            if (ticketItemDiscount2.getTableRowNum() != ticketItemDiscount.getTableRowNum()) continue;
            iterator.remove();
            return;
        }
    }

    public boolean isInventoryAdjusted() {
        return this.getQuantity().doubleValue() == this.getInventoryAdjustQty().doubleValue();
    }

    public Boolean isIncludeVoidQuantity() {
        return this.includeVoidQuantity == null ? false : this.includeVoidQuantity;
    }

    public void setIncludeVoidQuantity(Boolean bl) {
        this.includeVoidQuantity = bl;
    }

    public void setVoidItem(VoidItem voidItem) {
        this.voidItem = voidItem;
    }

    public VoidItem getVoidItem() {
        return this.voidItem;
    }

    public void markVoided(String string, boolean bl, double d, boolean bl2) {
        this.setVoided(true);
        this.setVoidDate(StoreDAO.getServerTimestamp());
        this.setQuantity(-d);
        this.setVoidItem(this.createVoidItem(string, bl, d));
        if (bl2) {
            this.setReturned(true);
        }
        this.addProperty(JSON_PROP_VOID_REASON, string);
    }

    public VoidItem createVoidItem(String string, boolean bl, double d) {
        TicketItem ticketItem = this.cloneAsNew();
        ticketItem.setQuantity(d);
        ticketItem.calculatePrice();
        VoidItem voidItem = new VoidItem();
        if (ticketItem.getTicket() != null) {
            voidItem.setTicketId(ticketItem.getTicket().getId());
        }
        voidItem.setVoidReason(string);
        voidItem.setItemId(ticketItem.getId());
        voidItem.setMenuItemId(ticketItem.getMenuItemId());
        voidItem.setMenuItemName(ticketItem.getName());
        voidItem.setUnitPrice(ticketItem.getUnitPrice());
        voidItem.setQuantity(d);
        voidItem.setItemWasted(bl);
        voidItem.setVoidDate(new Date());
        voidItem.setModifier(false);
        voidItem.setPrinterGroup(ticketItem.getPrinterGroup());
        User user = Application.getCurrentUser();
        voidItem.setVoidByUser(user);
        voidItem.setTerminal(Application.getInstance().getTerminal());
        if (user.getActiveDrawerPullReport() != null) {
            voidItem.setCashDrawerId(user.getActiveDrawerPullReport().getId());
        }
        voidItem.setTaxAmount(ticketItem.getTaxAmountWithoutModifiers());
        voidItem.setTotalPrice(ticketItem.getAdjustedTotalWithoutModifiers());
        double d2 = ticketItem.getQuantity();
        double d3 = voidItem.getQuantity();
        ArrayList<VoidItem> arrayList = new ArrayList<VoidItem>();
        if (ticketItem.isHasModifiers().booleanValue()) {
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                VoidItem voidItem2 = new VoidItem();
                double d4 = ticketItemModifier.getItemQuantity() * d3 / d2;
                if (!(d4 > 0.0)) continue;
                String string2 = voidItem.getVoidReason();
                if (!StringUtils.isEmpty((String)string2)) {
                    voidItem2.setVoidReason(string2);
                }
                voidItem2.setModifierId(ticketItemModifier.getItemId());
                voidItem2.setItemId(ticketItemModifier.getId());
                voidItem2.setMenuItemName(ticketItemModifier.getNameDisplay());
                voidItem2.setUnitPrice(ticketItemModifier.getUnitPrice());
                voidItem2.setQuantity(d4);
                voidItem2.setItemWasted(voidItem.isItemWasted());
                voidItem2.setVoidDate(new Date());
                voidItem2.setModifier(true);
                voidItem2.setVoidByUser(user);
                voidItem2.setTerminal(Application.getInstance().getTerminal());
                voidItem2.setCashDrawerId(user.getActiveDrawerPullReport().getId());
                voidItem2.setTaxAmount(ticketItemModifier.getTaxAmount());
                voidItem2.setTotalPrice(ticketItemModifier.getAdjustedSubtotal() + ticketItemModifier.getTaxAmount());
                voidItem2.setTicketId(voidItem.getTicketId());
                arrayList.add(voidItem2);
            }
        }
        voidItem.setVoidModifiers(arrayList);
        return voidItem;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isRefundable() {
        return true;
    }

    public List<TicketItemCookingInstruction> getCookingInstructions() {
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            String string = super.getCookingInstructionsProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                    ticketItemCookingInstruction.setDescription(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_DESCRIPTION));
                    ticketItemCookingInstruction.setPrintedToKitchen(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_PRINTED_TO_KITCHEN));
                    ticketItemCookingInstruction.setSaved(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_SAVED));
                    this.cookingInstructions.add(ticketItemCookingInstruction);
                }
            }
        }
        return this.cookingInstructions;
    }

    public PrinterGroup getPrinterGroup() {
        PrinterGroup printerGroup = DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
        if (printerGroup == null) {
            DataProvider.get().getDefaultPrinterGroup();
        }
        return printerGroup;
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String string = null;
        if (printerGroup != null) {
            string = printerGroup.getId();
        }
        super.setPrinterGroupId(string);
    }

    public TicketItem getParentTicketItem() {
        return this.parentTicketItem;
    }

    public void setParentTicketItem(TicketItem ticketItem) {
        this.parentTicketItem = ticketItem;
    }

    public List<TicketItem> getComboItems() {
        return null;
    }

    public void setComboItems(List<TicketItem> list) {
    }

    public void addTocomboItems(TicketItem ticketItem) {
    }

    public Integer getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder;
        }
        if (StringUtils.isEmpty((String)this.getCourseId())) {
            return 0;
        }
        Course course = DataProvider.get().getCourse(this.getCourseId());
        if (course != null) {
            return course.getSortOrder();
        }
        return 0;
    }

    public void setSortOrder(Integer n) {
        this.sortOrder = n;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new com.google.gson.JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
            super.setProperties(this.propertiesContainer.toString());
        }
    }

    public void setUnitSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitSelection() {
        String string = this.getProperty("menuitem.allow_unit_selection");
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public void setItemIsGiftCard(String string, double d) {
        this.setQuantity(1.0);
        this.setShouldPrintToKitchen(false);
        this.setInventoryItem(false);
        this.setName(Messages.getString("GiftCardAddBalanceView.22"));
        this.setCategoryName(Messages.getString("GiftCard"));
        this.setGroupName(Messages.getString("GiftCard"));
        this.setUnitPrice(d);
        this.addProperty("isGiftCard", String.valueOf(true));
        this.addProperty("giftCardNo", string);
    }

    public boolean isGiftCard() {
        return Boolean.valueOf(this.getProperty("isGiftCard"));
    }

    public String getGiftCardNo() {
        return this.getProperty("giftCardNo");
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String string) {
        this.classType = string;
    }

    public void setReturned(Boolean bl) {
        this.addProperty("returned", String.valueOf(bl));
    }

    public boolean isReturned() {
        return Boolean.valueOf(this.getProperty("returned"));
    }

    public double getTaxAmountFromProperty() {
        return POSUtil.parseDouble(this.getProperty("tax.exempt.amount"));
    }

    public double getComboItemsPrice() {
        double d = 0.0;
        List<TicketItem> list = this.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (ticketItem.getGroupId() != null) continue;
                d += ticketItem.getUnitPrice().doubleValue();
            }
        }
        return d;
    }

    public static enum PIZZA_SECTION_MODE {
        FULL(1),
        HALF(2),
        QUARTER(3);

        private final int value;

        private PIZZA_SECTION_MODE(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static PIZZA_SECTION_MODE from(int n) {
            if (n == 2) {
                return HALF;
            }
            if (n == 3) {
                return QUARTER;
            }
            return FULL;
        }

        public String toString() {
            return this.name();
        }
    }
}

